/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.ConfigurationDialog;
import com.eviware.soapui.support.components.DirectoryFormComponent;
import com.eviware.soapui.support.components.JButtonBar;
import com.eviware.soapui.support.components.SimpleForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SwingConfigurationDialogImpl
implements ConfigurationDialog {
    private JDialog dialog;
    private SimpleForm form;
    private boolean result;
    private Map<String, String> values;
    private Map<String, ConfigurationDialog.FieldType> fieldTypes = new HashMap<String, ConfigurationDialog.FieldType>();
    private final String title;
    private Dimension size;
    private JComponent content;
    private ActionList actions;
    private String description;
    private ImageIcon icon;

    public SwingConfigurationDialogImpl(String title, String helpUrl, String description, ImageIcon icon) {
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.form = new SimpleForm("10px,left:pref,10px,left:pref,5px");
        this.actions = new DefaultActionList("Actions");
        if (helpUrl != null) {
            this.actions.addAction(new ShowOnlineHelpAction(helpUrl));
            this.actions.addSeparator();
        }
        OkAction okAction = new OkAction();
        this.actions.addAction(okAction);
        this.actions.addAction(new CancelAction());
        this.actions.setDefaultAction(okAction);
    }

    @Override
    public boolean show(Map<String, String> values) {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.values = values;
        this.result = false;
        this.form.setValues(values);
        if (this.size == null) {
            this.dialog.pack();
        } else {
            this.dialog.setSize(this.size);
        }
        UISupport.showDialog(this.dialog);
        return this.result;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension preferredSize) {
        this.size = preferredSize;
    }

    @Override
    public void addTextField(String name, String tooltip) {
        this.addTextField(name, tooltip, ConfigurationDialog.FieldType.TEXT);
    }

    @Override
    public void addTextField(String name, String tooltip, ConfigurationDialog.FieldType type) {
        if (type == ConfigurationDialog.FieldType.DIRECTORY) {
            this.form.append(name, new DirectoryFormComponent(tooltip));
        } else {
            this.form.appendTextField(name, tooltip);
        }
        this.fieldTypes.put(name, type);
    }

    @Override
    public void addCheckBox(String caption, String label, boolean selected) {
        this.form.appendCheckBox(caption, label, selected);
    }

    public void setContent(JComponent content) {
        this.content = content;
    }

    private void buildDialog() {
        this.dialog = new JDialog(UISupport.getMainFrame(), this.title, true);
        this.form.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JPanel panel = new JPanel(new BorderLayout());
        JComponent contentPanel = this.content == null ? this.form.getPanel() : this.content;
        panel.add((Component)contentPanel, "Center");
        JButtonBar buttons = UISupport.initDialogActions(this.actions, this.dialog);
        buttons.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        if (this.content == null) {
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)new JSeparator(), "North");
            p.add((Component)buttons, "Center");
            panel.add((Component)p, "South");
        } else {
            panel.add((Component)buttons, "South");
        }
        if (this.description != null || this.icon != null) {
            this.dialog.getContentPane().add((Component)UISupport.buildDescription(this.title, this.description, this.icon), "North");
        }
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
    }

    @Override
    public void addComboBox(String label, Object[] objects, String tooltip) {
        this.form.appendComboBox(label, objects, tooltip);
    }

    @Override
    public void setValues(String id, String[] values) {
        JComponent component = this.form.getComponent(id);
        if (component instanceof JComboBox) {
            ((JComboBox)component).setModel(new DefaultComboBoxModel<String>(values));
        } else if (component instanceof JList) {
            ((JList)component).setModel(new DefaultComboBoxModel<String>(values));
        } else {
            throw new RuntimeException("Could not set values on [" + component + "]");
        }
    }

    @Override
    public void addComboBox(String label, String tooltip) {
        this.form.appendComboBox(label, new String[0], tooltip);
    }

    public void addComponent(JComponent component) {
        this.form.addComponent(component);
    }

    @Override
    public void getValues(Map<String, String> values) {
        this.form.getValues(values);
    }

    @Override
    public ActionList getActions() {
        return this.actions;
    }

    @Override
    public void hide() {
        this.dialog.setVisible(false);
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingConfigurationDialogImpl.this.dialog.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super("OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingConfigurationDialogImpl.this.result = true;
            SwingConfigurationDialogImpl.this.form.getValues(SwingConfigurationDialogImpl.this.values);
            SwingConfigurationDialogImpl.this.dialog.setVisible(false);
            try {
                SoapUI.saveSettings();
            }
            catch (Exception e1) {
                SoapUI.logError(e1, "There was an error when attempting to save your preferences");
                UISupport.showErrorMessage(e1);
            }
        }
    }
}

