/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JFormComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileListFormComponent
extends JPanel
implements JFormComponent,
ActionListener {
    private DefaultListModel listModel = new DefaultListModel();
    private JButton addButton;
    private JButton removeButton;
    private JList list = new JList(this.listModel);

    public FileListFormComponent(String tooltip) {
        this.list.setToolTipText(tooltip);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setPreferredSize(new Dimension(300, 70));
        this.add((Component)scrollPane, "Center");
        Box box = new Box(1);
        this.addButton = new JButton("Add..");
        this.addButton.addActionListener(this);
        box.add(this.addButton);
        box.add(Box.createVerticalStrut(5));
        this.removeButton = new JButton("Remove..");
        this.removeButton.addActionListener(this);
        box.add(this.removeButton);
        box.add(Box.createVerticalGlue());
        this.add((Component)box, "East");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileListFormComponent.this.removeButton.setEnabled(FileListFormComponent.this.list.getSelectedIndex() != -1);
            }
        });
        this.removeButton.setEnabled(this.list.getSelectedIndex() != -1);
    }

    @Override
    public void setValue(String value) {
        String[] files;
        this.listModel.clear();
        for (String file : files = value.split(";")) {
            if (file.trim().length() <= 0) continue;
            this.listModel.addElement(file);
        }
    }

    @Override
    public String getValue() {
        Object[] values = this.listModel.toArray();
        StringBuffer buf = new StringBuffer();
        for (int c = 0; c < values.length; ++c) {
            if (c > 0) {
                buf.append(';');
            }
            buf.append(values[c]);
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.addButton) {
            File file = UISupport.getFileDialogs().open(this, "Add file", null, null, null);
            if (file != null) {
                this.listModel.addElement(file.getAbsolutePath());
            }
        } else if (arg0.getSource() == this.removeButton && this.list.getSelectedIndex() != -1) {
            Object elm = this.listModel.getElementAt(this.list.getSelectedIndex());
            if (UISupport.confirm("Remove [" + elm.toString() + "] from list", "Remove")) {
                this.listModel.remove(this.list.getSelectedIndex());
            }
        }
    }
}

