/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action.swing;

import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.actions.MarkerAction;
import com.eviware.soapui.support.components.JXToolBar;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class ActionSupport {
    public static final Action SEPARATOR_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };

    public static JPopupMenu buildPopup(ActionList actions) {
        if (actions == null || actions.getActionCount() == 0) {
            return null;
        }
        JPopupMenu popup = new JPopupMenu(actions.getLabel());
        return ActionSupport.addActions(actions, popup);
    }

    public static JMenu buildMenu(ActionList actions) {
        if (actions == null || actions.getActionCount() == 0) {
            return null;
        }
        JMenu menu = new JMenu(actions.getLabel());
        return ActionSupport.addActions(actions, menu);
    }

    public static JPopupMenu addActions(ActionList actions, JPopupMenu popup) {
        if (actions == null || actions.getActionCount() == 0) {
            return popup;
        }
        for (int i = 0; i < actions.getActionCount(); ++i) {
            Action action = actions.getActionAt(i);
            if (action instanceof MarkerAction) continue;
            if (action == SEPARATOR_ACTION) {
                popup.addSeparator();
                continue;
            }
            if (action instanceof ActionListAction) {
                ActionList actionList = ((ActionListAction)action).getActionList();
                if (actionList == null || actionList.getActionCount() == 0) {
                    System.err.println("null/empty ActionList in action " + action.getValue("Name"));
                    continue;
                }
                popup.add(ActionSupport.buildMenu(actionList));
                continue;
            }
            popup.add(action);
        }
        return popup;
    }

    public static JMenu addActions(ActionList actions, JMenu menu) {
        if (actions == null || menu == null) {
            return menu;
        }
        for (int i = 0; i < actions.getActionCount(); ++i) {
            Action action = actions.getActionAt(i);
            if (action instanceof MarkerAction) continue;
            if (action == SEPARATOR_ACTION) {
                menu.addSeparator();
                continue;
            }
            if (action instanceof ActionListAction) {
                JMenu subMenu = ActionSupport.buildMenu(((ActionListAction)action).getActionList());
                if (subMenu == null) {
                    subMenu = new JMenu(((ActionListAction)action).getActionList().getLabel());
                }
                menu.add(subMenu);
                continue;
            }
            if (action == null) continue;
            menu.add(action);
        }
        return menu;
    }

    public static JPopupMenu insertActions(ActionList actions, JPopupMenu popup, int index) {
        for (int i = 0; i < actions.getActionCount(); ++i) {
            Action action = actions.getActionAt(i);
            if (action instanceof MarkerAction) continue;
            if (action == SEPARATOR_ACTION) {
                popup.insert(new JPopupMenu.Separator(), index + i);
                continue;
            }
            if (action instanceof ActionListAction) {
                popup.insert(ActionSupport.buildMenu(((ActionListAction)action).getActionList()), index + i);
                continue;
            }
            popup.insert(action, index + i);
        }
        return popup;
    }

    public static void addActions(ActionList actionList, ButtonBarBuilder builder) {
        for (int c = 0; c < actionList.getActionCount(); ++c) {
            Action action = actionList.getActionAt(c);
            if (action == SEPARATOR_ACTION) {
                builder.addUnrelatedGap();
                continue;
            }
            if (c > 0) {
                builder.addRelatedGap();
            }
            builder.addFixed((JComponent)new JButton(action));
        }
    }

    public static void addActions(ActionList actionList, JXToolBar toolbar) {
        for (int c = 0; c < actionList.getActionCount(); ++c) {
            Action action = actionList.getActionAt(c);
            if (action == SEPARATOR_ACTION) {
                toolbar.addUnrelatedGap();
                continue;
            }
            if (c > 0) {
                toolbar.addRelatedGap();
            }
            toolbar.addFixed(new JButton(action));
        }
    }

    public static class ActionListAction
    extends AbstractAction {
        private final ActionList actionList;

        public ActionListAction(ActionList actionList) {
            this.actionList = actionList;
        }

        public ActionList getActionList() {
            return this.actionList;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action defaultAction = this.actionList.getDefaultAction();
            if (defaultAction != null) {
                defaultAction.actionPerformed(e);
            }
        }
    }
}

