/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.support.StringUtils;
import net.sf.json.JSON;
import net.sf.json.JSONNull;
import net.sf.json.JSONSerializer;
import net.sf.json.groovy.JsonSlurper;

public class JsonUtil {
    private static final String WHILE_1 = "while(1);";

    public static boolean isValidJson(String value) {
        try {
            JSON json = new JsonSlurper().parseText(value);
            return json != null && !(json instanceof JSONNull);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean seemsToBeJsonContentType(String contentType) {
        return contentType != null && (contentType.contains("javascript") || contentType.contains("json"));
    }

    public static boolean seemsToBeJson(String content) {
        if (!StringUtils.hasContent(content)) {
            return false;
        }
        try {
            new JsonSlurper().parseText(content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public JSON parseTrimmedText(String text) {
        if (text == null) {
            return null;
        }
        String trimmedText = text.trim();
        if (trimmedText.startsWith(WHILE_1)) {
            trimmedText = trimmedText.substring(WHILE_1.length()).trim();
        }
        return JSONSerializer.toJSON((Object)trimmedText);
    }
}

