/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.security.scan.XmlBombSecurityScan;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.SimpleForm;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class XmlBombSecurityScanConfigPanel
extends JPanel {
    private static final String ATTACHMENT_PREFIX_FIELD = "Attachment Prefix Field";
    private static final String ENABLE_ATTACHMENT_FIELD = "Send bomb as attachment";
    private List<String> xmlBombList;
    private JTextArea attachementArea;
    private int xmlBombPosition = -1;
    private PreviousAttachement previous;
    private NextAttachement next;
    private JLabel current;
    private JLabel max;
    protected int internalPosition;
    protected int externalPosition;
    private SimpleForm form;
    private XmlBombSecurityScan xmlChk;

    public XmlBombSecurityScanConfigPanel(XmlBombSecurityScan xmlCheck) {
        super(new BorderLayout());
        this.xmlChk = xmlCheck;
        this.xmlBombList = xmlCheck.getXmlBombList();
        this.form = new SimpleForm();
        this.form.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 3));
        this.form.addSpace(5);
        this.form.addComponent(new JLabel("Xml Bomb Attacments"));
        JCheckBox attachXml = this.form.appendCheckBox(ENABLE_ATTACHMENT_FIELD, null, xmlCheck.isAttachXmlBomb());
        attachXml.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                XmlBombSecurityScanConfigPanel.this.form.getComponent(XmlBombSecurityScanConfigPanel.ATTACHMENT_PREFIX_FIELD).setEnabled(((JCheckBox)XmlBombSecurityScanConfigPanel.this.form.getComponent(XmlBombSecurityScanConfigPanel.ENABLE_ATTACHMENT_FIELD)).isSelected());
                XmlBombSecurityScanConfigPanel.this.xmlChk.setAttachXmlBomb(((JCheckBox)XmlBombSecurityScanConfigPanel.this.form.getComponent(XmlBombSecurityScanConfigPanel.ENABLE_ATTACHMENT_FIELD)).isSelected());
            }
        });
        JTextField attachmentPrefixField = this.form.appendTextField(ATTACHMENT_PREFIX_FIELD, ATTACHMENT_PREFIX_FIELD);
        attachmentPrefixField.setMaximumSize(new Dimension(80, 10));
        attachmentPrefixField.setColumns(20);
        attachmentPrefixField.setText(xmlCheck.getAttachmentPrefix());
        attachmentPrefixField.setEnabled(xmlCheck.isAttachXmlBomb());
        attachmentPrefixField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                XmlBombSecurityScanConfigPanel.this.xmlChk.setAttachmentPrefix(((JTextField)XmlBombSecurityScanConfigPanel.this.form.getComponent(XmlBombSecurityScanConfigPanel.ATTACHMENT_PREFIX_FIELD)).getText());
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.previous = new PreviousAttachement();
        toolbar.add(this.previous);
        this.previous.setEnabled(false);
        this.next = new NextAttachement();
        toolbar.add(this.next);
        toolbar.add(new AddXmlAttachement());
        toolbar.add(new RemoveAttachement());
        toolbar.add(new SaveAttachement());
        this.current = new JLabel("  current:0");
        toolbar.add(this.current);
        this.max = new JLabel("  max:" + this.xmlBombList.size());
        toolbar.add(this.max);
        this.form.append(toolbar);
        this.attachementArea = new JTextArea(10, 15);
        this.xmlBombPosition = 0;
        if (this.xmlBombList.size() > 0) {
            this.attachementArea.setText(this.xmlBombList.get(this.xmlBombPosition));
            if (this.xmlBombList.size() == 1) {
                this.next.setEnabled(false);
            }
        } else {
            this.next.setEnabled(false);
        }
        this.form.append(new JScrollPane(this.attachementArea));
        this.form.addSpace(5);
        this.add(this.form.getPanel());
    }

    private class RemoveAttachement
    extends AbstractAction {
        public RemoveAttachement() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Remove current Xml Bomb");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!XmlBombSecurityScanConfigPanel.this.xmlBombList.isEmpty()) {
                XmlBombSecurityScanConfigPanel.this.xmlBombList.remove(XmlBombSecurityScanConfigPanel.this.xmlBombPosition);
                if (XmlBombSecurityScanConfigPanel.this.xmlBombPosition >= XmlBombSecurityScanConfigPanel.this.xmlBombList.size() && !XmlBombSecurityScanConfigPanel.this.xmlBombList.isEmpty()) {
                    XmlBombSecurityScanConfigPanel.this.xmlBombPosition = XmlBombSecurityScanConfigPanel.this.xmlBombList.size() - 1;
                } else if (XmlBombSecurityScanConfigPanel.this.xmlBombList.isEmpty()) {
                    XmlBombSecurityScanConfigPanel.this.xmlBombPosition = 0;
                    XmlBombSecurityScanConfigPanel.this.next.setEnabled(false);
                    XmlBombSecurityScanConfigPanel.this.previous.setEnabled(false);
                }
                if (XmlBombSecurityScanConfigPanel.this.xmlBombList.size() == 1) {
                    XmlBombSecurityScanConfigPanel.this.xmlBombPosition = 0;
                    XmlBombSecurityScanConfigPanel.this.next.setEnabled(false);
                    XmlBombSecurityScanConfigPanel.this.previous.setEnabled(false);
                }
                if (XmlBombSecurityScanConfigPanel.this.xmlBombList.size() - 1 == XmlBombSecurityScanConfigPanel.this.xmlBombPosition) {
                    XmlBombSecurityScanConfigPanel.this.next.setEnabled(false);
                }
                if (XmlBombSecurityScanConfigPanel.this.xmlBombList.isEmpty()) {
                    XmlBombSecurityScanConfigPanel.this.attachementArea.setText("");
                } else {
                    XmlBombSecurityScanConfigPanel.this.attachementArea.setText((String)XmlBombSecurityScanConfigPanel.this.xmlBombList.get(XmlBombSecurityScanConfigPanel.this.xmlBombPosition));
                }
                XmlBombSecurityScanConfigPanel.this.current.setText("  current:" + XmlBombSecurityScanConfigPanel.this.xmlBombPosition);
                XmlBombSecurityScanConfigPanel.this.max.setText("  max:" + XmlBombSecurityScanConfigPanel.this.xmlBombList.size());
            }
        }
    }

    private class AddXmlAttachement
    extends AbstractAction {
        public AddXmlAttachement() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Add new Xml Bomb");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XmlBombSecurityScanConfigPanel.this.xmlBombList.add("");
            XmlBombSecurityScanConfigPanel.this.attachementArea.setText("");
            XmlBombSecurityScanConfigPanel.this.max.setText("  max:" + XmlBombSecurityScanConfigPanel.this.xmlBombList.size());
            XmlBombSecurityScanConfigPanel.this.xmlBombPosition = XmlBombSecurityScanConfigPanel.this.xmlBombList.size() - 1;
            XmlBombSecurityScanConfigPanel.this.current.setText("  current:" + XmlBombSecurityScanConfigPanel.this.xmlBombPosition);
            XmlBombSecurityScanConfigPanel.this.next.setEnabled(false);
            if (XmlBombSecurityScanConfigPanel.this.xmlBombList.size() > 1) {
                XmlBombSecurityScanConfigPanel.this.previous.setEnabled(true);
            }
        }
    }

    private class SaveAttachement
    extends AbstractAction {
        public SaveAttachement() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/save_all.gif"));
            this.putValue("ShortDescription", "Save Xml Bomb");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XmlBombSecurityScanConfigPanel.this.xmlBombList.set(XmlBombSecurityScanConfigPanel.this.xmlBombPosition, XmlBombSecurityScanConfigPanel.this.attachementArea.getText());
        }
    }

    private class NextAttachement
    extends AbstractAction {
        public NextAttachement() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/right_arrow.gif"));
            this.putValue("ShortDescription", "Next Xml Bomb");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XmlBombSecurityScanConfigPanel.this.xmlBombPosition++;
            XmlBombSecurityScanConfigPanel.this.previous.setEnabled(true);
            XmlBombSecurityScanConfigPanel.this.attachementArea.setText((String)XmlBombSecurityScanConfigPanel.this.xmlBombList.get(XmlBombSecurityScanConfigPanel.this.xmlBombPosition));
            if (XmlBombSecurityScanConfigPanel.this.xmlBombPosition == XmlBombSecurityScanConfigPanel.this.xmlBombList.size() - 1) {
                this.setEnabled(false);
            }
            XmlBombSecurityScanConfigPanel.this.current.setText("  current:" + XmlBombSecurityScanConfigPanel.this.xmlBombPosition);
        }
    }

    private class PreviousAttachement
    extends AbstractAction {
        public PreviousAttachement() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/left_arrow.gif"));
            this.putValue("ShortDescription", "Previous Xml Bomb");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XmlBombSecurityScanConfigPanel.this.xmlBombPosition--;
            XmlBombSecurityScanConfigPanel.this.next.setEnabled(true);
            XmlBombSecurityScanConfigPanel.this.attachementArea.setText((String)XmlBombSecurityScanConfigPanel.this.xmlBombList.get(XmlBombSecurityScanConfigPanel.this.xmlBombPosition));
            if (XmlBombSecurityScanConfigPanel.this.xmlBombPosition == 0) {
                this.setEnabled(false);
            }
            XmlBombSecurityScanConfigPanel.this.current.setText("  current:" + XmlBombSecurityScanConfigPanel.this.xmlBombPosition);
        }
    }
}

