/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.MalformedXmlAttributeConfig;
import com.eviware.soapui.config.MalformedXmlConfig;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.ui.MalformedXmlAdvancedSettingsPanel;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class MalformedXmlSecurityScan
extends AbstractSecurityScanWithProperties {
    public static final String TYPE = "MalformedXmlSecurityScan";
    public static final String NAME = "Malformed XML";
    private Map<SecurityCheckedParameter, ArrayList<String>> parameterMutations = new HashMap<SecurityCheckedParameter, ArrayList<String>>();
    private boolean mutation;
    private MalformedXmlConfig malformedXmlConfig;
    private MalformedXmlAttributeConfig malformedAttributeConfig;
    private MalformedXmlAdvancedSettingsPanel advancedSettingsPanel;

    public MalformedXmlSecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
        if (config.getConfig() == null || !(config.getConfig() instanceof MalformedXmlConfig)) {
            this.initMalformedXmlConfig();
        } else {
            this.malformedXmlConfig = (MalformedXmlConfig)config.getConfig();
            this.malformedAttributeConfig = this.malformedXmlConfig.getAttributeMutation();
        }
    }

    protected void initMalformedXmlConfig() {
        ((SecurityScanConfig)this.getConfig()).setConfig(MalformedXmlConfig.Factory.newInstance());
        this.malformedXmlConfig = (MalformedXmlConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        this.malformedXmlConfig.addNewAttributeMutation();
        this.malformedXmlConfig.setInsertNewElement(true);
        this.malformedXmlConfig.setNewElementValue("<xml>xml <joke> </xml> </joke>");
        this.malformedXmlConfig.setChangeTagName(true);
        this.malformedXmlConfig.setLeaveTagOpen(true);
        this.malformedXmlConfig.setInsertInvalidCharacter(true);
        this.malformedAttributeConfig = this.malformedXmlConfig.getAttributeMutation();
        this.malformedAttributeConfig.setMutateAttributes(true);
        this.malformedAttributeConfig.setInsertInvalidChars(true);
        this.malformedAttributeConfig.setLeaveAttributeOpen(true);
        this.malformedAttributeConfig.setAddNewAttribute(true);
        this.malformedAttributeConfig.setNewAttributeName("newAttribute");
        this.malformedAttributeConfig.setNewAttributeValue("XXX");
    }

    @Override
    protected void execute(SecurityTestRunner runner, TestStep testStep, SecurityTestRunContext context) {
        try {
            StringToStringMap paramsUpdated = this.update(testStep, context);
            MessageExchange message = (MessageExchange)((Object)testStep.run((TestCaseRunner)((Object)runner), context));
            this.createMessageExchange(paramsUpdated, message, context);
        }
        catch (XmlException e) {
            SoapUI.logError(e, "[MalformedXmlSecurityScan]XPath seems to be invalid!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
        catch (Exception e) {
            SoapUI.logError(e, "[MalformedXmlSecurityScan]Property value is not valid xml!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
    }

    protected StringToStringMap update(TestStep testStep, SecurityTestRunContext context) throws XmlException, Exception {
        StringToStringMap params = new StringToStringMap();
        if (this.parameterMutations.size() == 0) {
            this.mutateParameters(testStep, context);
        }
        if (this.getExecutionStrategy().getStrategy() == StrategyTypeConfig.ONE_BY_ONE) {
            for (SecurityCheckedParameter param : this.getParameterHolder().getParameterList()) {
                if (!this.parameterMutations.containsKey(param) || this.parameterMutations.get(param).size() <= 0) continue;
                TestProperty property = testStep.getProperties().get(param.getName());
                String value = context.expand(property.getValue());
                if (param.getXpath() == null || param.getXpath().trim().length() == 0) break;
                if (value == null || value.trim().equals("")) continue;
                XmlObjectTreeModel model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
                XmlObjectTreeModel.XmlTreeNode[] nodes = model.selectTreeNodes(context.expand(param.getXpath()));
                StringBuffer buffer = new StringBuffer(value);
                for (int cnt = 0; cnt < nodes.length; ++cnt) {
                    int start = value.indexOf("<" + nodes[cnt].getNodeName());
                    for (int cnt2 = 0; cnt2 < cnt; ++cnt2) {
                        start = value.indexOf("<" + nodes[cnt].getNodeName(), start + 1);
                    }
                    String nodeXml = this.getXmlForNode(nodes[cnt]);
                    int end2 = value.indexOf("<" + nodes[cnt].getNodeName(), start + 1);
                    if (end2 <= 0) {
                        end2 = nodeXml.endsWith("</" + nodes[cnt].getDomNode().getNodeName() + ">") ? value.indexOf("</" + nodes[cnt].getDomNode().getNodeName() + ">") + ("</" + nodes[cnt].getDomNode().getNodeName() + ">").length() : value.indexOf(">", value.indexOf("/", start));
                    }
                    if (end2 <= 0 || end2 <= start) break;
                    buffer.replace(start, end2 + 1, this.parameterMutations.get(param).get(0));
                }
                params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                this.parameterMutations.get(param).remove(0);
                testStep.getProperties().get(param.getName()).setValue(buffer.toString());
                break;
            }
        } else {
            for (TestProperty property : testStep.getPropertyList()) {
                String value = context.expand(property.getValue());
                if (!XmlUtils.seemsToBeXml(value)) continue;
                StringBuffer buffer = new StringBuffer(value);
                XmlObjectTreeModel model = null;
                model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
                for (SecurityCheckedParameter param : this.getParameterHolder().getParameterList()) {
                    if (param.getXpath() == null || param.getXpath().trim().length() == 0) {
                        if (!this.parameterMutations.containsKey(param)) continue;
                        testStep.getProperties().get(param.getName()).setValue(this.parameterMutations.get(param).get(0));
                        params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                        this.parameterMutations.get(param).remove(0);
                        continue;
                    }
                    if (value == null || value.trim().equals("") || !param.getName().equals(property.getName())) continue;
                    XmlObjectTreeModel.XmlTreeNode[] nodes = model.selectTreeNodes(context.expand(param.getXpath()));
                    if (!this.parameterMutations.containsKey(param) || this.parameterMutations.get(param).size() <= 0) continue;
                    for (int cnt = 0; cnt < nodes.length; ++cnt) {
                        int start = value.indexOf("<" + nodes[cnt].getNodeName());
                        for (int cnt2 = 0; cnt2 < cnt; ++cnt2) {
                            start = value.indexOf("<" + nodes[cnt].getNodeName(), start + 1);
                        }
                        String nodeXml = this.getXmlForNode(nodes[cnt]);
                        int end3 = value.indexOf("<" + nodes[cnt].getNodeName(), start + 1);
                        if (end3 <= 0) {
                            end3 = nodeXml.endsWith("</" + nodes[cnt].getDomNode().getNodeName() + ">") ? value.indexOf("</" + nodes[cnt].getDomNode().getNodeName() + ">") : value.indexOf(">", value.indexOf("/", start));
                        }
                        if (end3 <= 0 || end3 <= start) break;
                        buffer.replace(start, end3 + 1, this.parameterMutations.get(param).get(0));
                    }
                    params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                    this.parameterMutations.get(param).remove(0);
                }
                if (model == null) continue;
                property.setValue(buffer.toString());
            }
        }
        return params;
    }

    protected void mutateParameters(TestStep testStep, SecurityTestRunContext context) throws XmlException, IOException {
        this.mutation = true;
        for (SecurityCheckedParameter parameter : this.getParameterHolder().getParameterList()) {
            if (!parameter.isChecked()) continue;
            TestProperty property = this.getTestStep().getProperties().get(parameter.getName());
            if (parameter.getXpath() == null || parameter.getXpath().trim().length() == 0 || property.getValue() == null && property.getDefaultValue() == null) continue;
            String value = context.expand(property.getValue());
            XmlObjectTreeModel model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
            XmlObjectTreeModel.XmlTreeNode[] nodes = model.selectTreeNodes(context.expand(parameter.getXpath()));
            if (nodes.length <= 0 || nodes[0] instanceof XmlObjectTreeModel.AttributeXmlTreeNode) continue;
            if (!this.parameterMutations.containsKey(parameter)) {
                this.parameterMutations.put(parameter, new ArrayList());
            }
            this.parameterMutations.get(parameter).addAll(this.mutateNode(nodes[0], value));
        }
    }

    protected Collection<? extends String> mutateNode(XmlObjectTreeModel.XmlTreeNode node, String xml) throws IOException {
        Object buffer;
        ArrayList<String> result = new ArrayList<String>();
        String nodeXml = this.getXmlForNode(node);
        if (this.malformedXmlConfig.getInsertNewElement()) {
            buffer = new StringBuffer(nodeXml);
            if (nodeXml.endsWith("</" + node.getDomNode().getNodeName() + ">")) {
                ((StringBuffer)buffer).insert(nodeXml.indexOf(">") + 1, this.malformedXmlConfig.getNewElementValue());
            } else {
                ((StringBuffer)buffer).delete(nodeXml.lastIndexOf("/"), nodeXml.length());
                ((StringBuffer)buffer).append(">" + this.malformedXmlConfig.getNewElementValue() + "</" + node.getDomNode().getNodeName() + ">");
            }
            result.add(((StringBuffer)buffer).toString());
        }
        if (this.malformedXmlConfig.getChangeTagName()) {
            String original = node.getNodeName();
            if (original.toUpperCase().equals(original)) {
                result.add(nodeXml.replaceAll(original, original.toLowerCase()));
            } else if (original.toLowerCase().equals(original)) {
                result.add(nodeXml.replaceAll(original, original.toUpperCase()));
            } else {
                StringBuffer buffer2 = new StringBuffer();
                for (char ch : original.toCharArray()) {
                    if (Character.isUpperCase(ch)) {
                        buffer2.append(Character.toLowerCase(ch));
                        continue;
                    }
                    buffer2.append(Character.toUpperCase(ch));
                }
                result.add(nodeXml.replaceAll(original, buffer2.toString()));
                buffer2 = new StringBuffer();
                for (char ch : original.toCharArray()) {
                    if (Character.isUpperCase(ch)) {
                        buffer2.append("_").append(Character.toLowerCase(ch));
                        continue;
                    }
                    buffer2.append(ch);
                }
                result.add(nodeXml.replaceAll(original, buffer2.toString()));
            }
        }
        if (this.malformedXmlConfig.getLeaveTagOpen()) {
            if (nodeXml.endsWith("</" + node.getDomNode().getNodeName() + ">")) {
                buffer = new StringBuffer(nodeXml);
                ((StringBuffer)buffer).delete(((StringBuffer)buffer).indexOf("</" + node.getDomNode().getNodeName() + ">"), ((StringBuffer)buffer).length());
                result.add(((StringBuffer)buffer).toString());
                buffer = new StringBuffer(nodeXml);
                ((StringBuffer)buffer).delete(0, ((StringBuffer)buffer).indexOf(">") + 1);
                result.add(((StringBuffer)buffer).toString());
                buffer = new StringBuffer(nodeXml);
                ((StringBuffer)buffer).delete(0, ((StringBuffer)buffer).indexOf(">") + 1);
                ((StringBuffer)buffer).delete(((StringBuffer)buffer).indexOf("</" + node.getDomNode().getNodeName() + ">") + 1, ((StringBuffer)buffer).indexOf("</" + node.getDomNode().getNodeName() + ">") + 2);
                result.add(((StringBuffer)buffer).toString());
            } else {
                buffer = new StringBuffer(nodeXml);
                ((StringBuffer)buffer).delete(nodeXml.lastIndexOf("/"), nodeXml.length());
                result.add(((StringBuffer)buffer).toString());
            }
        }
        if (this.malformedXmlConfig.getInsertInvalidCharacter()) {
            for (Object ch : (Object)new char[]{'<', '>', '&'}) {
                StringBuffer buffer3 = new StringBuffer(nodeXml);
                if (nodeXml.endsWith("</" + node.getDomNode().getNodeName() + ">")) {
                    buffer3.insert(buffer3.indexOf("</" + node.getDomNode().getNodeName() + ">"), (char)ch);
                } else {
                    buffer3.delete(nodeXml.lastIndexOf("/"), nodeXml.length());
                    buffer3.append('>').append((char)ch).append("</").append(node.getDomNode().getNodeName()).append(">");
                }
                result.add(buffer3.toString());
            }
        }
        if (this.malformedAttributeConfig.getMutateAttributes()) {
            if (this.malformedAttributeConfig.getAddNewAttribute() && this.malformedAttributeConfig.getNewAttributeName().trim().length() > 0) {
                buffer = new StringBuffer(nodeXml);
                ((StringBuffer)buffer).insert(node.getNodeName().length() + 1, " " + this.malformedAttributeConfig.getNewAttributeName() + "=\"" + this.malformedAttributeConfig.getNewAttributeValue() + "\" ");
                result.add(((StringBuffer)buffer).toString());
            }
            if (this.malformedAttributeConfig.getInsertInvalidChars() && node.getDomNode().hasAttributes()) {
                for (Object ch : (Object)new char[]{'\"', '\'', '<', '>', '&'}) {
                    StringBuffer buffer4 = new StringBuffer(nodeXml);
                    buffer4.insert(buffer4.indexOf("=") + 3, (char)ch);
                    result.add(buffer4.toString());
                }
            }
            if (this.malformedAttributeConfig.getLeaveAttributeOpen() && node.getDomNode().hasAttributes()) {
                buffer = new StringBuffer(nodeXml);
                ((StringBuffer)buffer).delete(((StringBuffer)buffer).indexOf("=") + 1, ((StringBuffer)buffer).indexOf("=") + 2);
                result.add(((StringBuffer)buffer).toString());
            }
        }
        return result;
    }

    private String getXmlForNode(XmlObjectTreeModel.XmlTreeNode nodes) {
        XmlOptions options = new XmlOptions();
        options.setSaveOuter();
        options.setSavePrettyPrint();
        String xml = nodes.getXmlObject().xmlText(options);
        return XmlUtils.removeUnneccessaryNamespaces(xml);
    }

    @Override
    public String getConfigDescription() {
        return "Configures Malformed XML Security Scan";
    }

    @Override
    public String getConfigName() {
        return "Malformed XML Security Scan";
    }

    @Override
    public String getHelpURL() {
        return "http://soapui.org/Security/malformed-xml.html";
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected boolean hasNext(TestStep testStep, SecurityTestRunContext context) {
        boolean hasNext = false;
        if (!(this.parameterMutations != null && this.parameterMutations.size() != 0 || this.mutation)) {
            hasNext = this.getParameterHolder().getParameterList().size() > 0;
        } else {
            for (SecurityCheckedParameter param : this.parameterMutations.keySet()) {
                if (this.parameterMutations.get(param).size() <= 0) continue;
                hasNext = true;
                break;
            }
        }
        if (!hasNext) {
            this.parameterMutations.clear();
            this.mutation = false;
        }
        return hasNext;
    }

    @Override
    protected void clear() {
        this.parameterMutations.clear();
        this.mutation = false;
    }

    @Override
    public JComponent getAdvancedSettingsPanel() {
        if (this.advancedSettingsPanel == null) {
            this.advancedSettingsPanel = new MalformedXmlAdvancedSettingsPanel(this.malformedXmlConfig);
        }
        return this.advancedSettingsPanel.getPanel();
    }

    @Override
    public void release() {
        if (this.advancedSettingsPanel != null) {
            this.advancedSettingsPanel.release();
        }
        super.release();
    }
}

