/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.boundary.AbstractBoundary;
import com.eviware.soapui.security.boundary.BoundaryRestrictionUtill;
import com.eviware.soapui.security.boundary.enumeration.EnumerationValues;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.scan.PropertyMutation;
import com.eviware.soapui.support.SecurityScanUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;

public class BoundarySecurityScan
extends AbstractSecurityScanWithProperties {
    public static final String TYPE = "BoundaryScan";
    public static final String NAME = "Boundary Scan";
    private static final String REQUEST_MUTATIONS_STACK = "RequestMutationsStack";
    private RestrictionLabel restrictionLabel = new RestrictionLabel();
    StrategyTypeConfig.Enum strategy = StrategyTypeConfig.ONE_BY_ONE;

    public BoundarySecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
    }

    @Override
    public JComponent getComponent() {
        JPanel panel = UISupport.createEmptyPanel(5, 75, 0, 5);
        panel.add((Component)this.restrictionLabel.getJLabel(), "Center");
        return panel;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void execute(SecurityTestRunner securityTestRunner, TestStep testStep, SecurityTestRunContext context) {
        PropertyMutation mutation = this.popMutation(context);
        if (mutation != null) {
            this.updateRequestProperty(testStep, mutation);
            MessageExchange message = (MessageExchange)((Object)testStep.run((TestCaseRunner)((Object)securityTestRunner), context));
            this.createMessageExchange(mutation.getMutatedParameters(), message, context);
        }
    }

    private PropertyMutation popMutation(SecurityTestRunContext context) {
        Stack requestMutationsStack = (Stack)context.get(REQUEST_MUTATIONS_STACK);
        return requestMutationsStack.empty() ? null : (PropertyMutation)requestMutationsStack.pop();
    }

    private void extractMutations(TestStep testStep, SecurityTestRunContext context) throws XmlException, Exception {
        this.strategy = this.getExecutionStrategy().getStrategy();
        XmlObjectTreeModel model = null;
        List<SecurityCheckedParameter> scpList = this.getParameterHolder().getParameterList();
        StringToStringMap stsmap = new StringToStringMap();
        for (SecurityCheckedParameter scp : scpList) {
            XmlObjectTreeModel.XmlTreeNode mynode;
            if (!scp.isChecked() || scp.getXpath().trim().length() <= 0) continue;
            XmlObjectTreeModel.XmlTreeNode[] treeNodes = null;
            if (((Object)((Object)this.strategy)).equals((Object)StrategyTypeConfig.ONE_BY_ONE)) {
                stsmap = new StringToStringMap();
                model = SecurityScanUtil.getXmlObjectTreeModel(testStep, scp);
            } else if (model == null) {
                model = SecurityScanUtil.getXmlObjectTreeModel(testStep, scp);
            }
            if ((treeNodes = model.selectTreeNodes(context.expand(scp.getXpath()))).length <= 0 || !(mynode = treeNodes[0]).isLeaf()) continue;
            if (mynode.getSchemaType() != null && mynode.getSchemaType().getEnumerationValues() != null && mynode.getSchemaType().getEnumerationValues().length > 0) {
                EnumerationValues nodeInfo = new EnumerationValues(mynode.getSchemaType().getBaseType().getShortJavaName());
                for (XmlAnySimpleType s : mynode.getSchemaType().getEnumerationValues()) {
                    nodeInfo.addValue(s.getStringValue());
                }
                this.updateEnumNodeValue(mynode, nodeInfo);
                stsmap.put(scp.getLabel(), mynode.getNodeText());
                if (!((Object)((Object)this.strategy)).equals((Object)StrategyTypeConfig.ONE_BY_ONE)) continue;
                PropertyMutation pm = new PropertyMutation();
                pm.setPropertyName(scp.getName());
                pm.setPropertyValue(model.getXmlObject().toString());
                stsmap = new StringToStringMap();
                stsmap.put(scp.getLabel(), mynode.getNodeText());
                pm.setMutatedParameters(stsmap);
                this.addMutation(context, pm);
                continue;
            }
            SchemaTypeImpl simpleType = (SchemaTypeImpl)mynode.getSchemaType();
            XmlObjectTreeModel model2 = new XmlObjectTreeModel(simpleType.getTypeSystem(), simpleType.getParseObject());
            this.extractRestrictions(model2, context, mynode, model, scp, stsmap);
        }
        if (model != null && ((Object)((Object)this.strategy)).equals((Object)StrategyTypeConfig.ALL_AT_ONCE)) {
            PropertyMutation pm = new PropertyMutation();
            pm.setPropertyName("Request");
            pm.setPropertyValue(model.getXmlObject().toString());
            pm.setMutatedParameters(stsmap);
            this.addMutation(context, pm);
        }
    }

    private void addMutation(SecurityTestRunContext context, PropertyMutation mutation) {
        Stack stack = (Stack)context.get(REQUEST_MUTATIONS_STACK);
        stack.push(mutation);
    }

    private void updateRequestProperty(TestStep testStep, PropertyMutation mutation) {
        testStep.getProperty(mutation.getPropertyName()).setValue(mutation.getPropertyValue());
    }

    public String extractRestrictions(XmlObjectTreeModel model2, SecurityTestRunContext context, XmlObjectTreeModel.XmlTreeNode nodeToUpdate, XmlObjectTreeModel model, SecurityCheckedParameter scp, StringToStringMap stsmap) throws XmlException, Exception {
        this.getNextChild(model2.getRootNode(), context, nodeToUpdate, model, scp, stsmap);
        return nodeToUpdate.getXmlObject().toString();
    }

    private void getNextChild(XmlObjectTreeModel.XmlTreeNode node, SecurityTestRunContext context, XmlObjectTreeModel.XmlTreeNode nodeToUpdate, XmlObjectTreeModel model, SecurityCheckedParameter scp, StringToStringMap stsmap) {
        String baseType = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            XmlObjectTreeModel.XmlTreeNode mynode = node.getChild(i);
            if ("xsd:restriction".equals(mynode.getParent().getNodeName())) {
                if (mynode.getNodeName().equals("@base")) {
                    baseType = mynode.getNodeText();
                } else {
                    this.createMutation(baseType, mynode, context, nodeToUpdate, model, scp, stsmap);
                }
            }
            this.getNextChild(mynode, context, nodeToUpdate, model, scp, stsmap);
        }
    }

    private void createMutation(String baseType, XmlObjectTreeModel.XmlTreeNode mynode, SecurityTestRunContext context, XmlObjectTreeModel.XmlTreeNode nodeToUpdate, XmlObjectTreeModel model, SecurityCheckedParameter scp, StringToStringMap stsmap) {
        String nodeValue;
        String value = null;
        String nodeName = mynode.getNodeName();
        value = AbstractBoundary.outOfBoundaryValue(baseType, nodeName, nodeValue = mynode.getChild(0).getNodeText());
        if (value != null) {
            nodeToUpdate.setValue(1, value);
            PropertyMutation pm = new PropertyMutation();
            pm.setPropertyName(scp.getName());
            pm.setPropertyValue(model.getXmlObject().toString());
            if (((Object)((Object)this.strategy)).equals((Object)StrategyTypeConfig.ONE_BY_ONE)) {
                stsmap = new StringToStringMap();
                stsmap.put(scp.getLabel() + " (" + nodeName + "='" + nodeValue + "') ", value);
                pm.setMutatedParameters(stsmap);
                this.addMutation(context, pm);
            } else {
                stsmap.put(scp.getLabel() + " (" + nodeName + "='" + nodeValue + "') ", value);
            }
        } else {
            SoapUI.log.warn((Object)("No out of boundary value is created for restriction " + nodeName + " of baseType:" + baseType));
        }
    }

    public void updateEnumNodeValue(XmlObjectTreeModel.XmlTreeNode mynode, EnumerationValues enumerationValues) {
        int size = EnumerationValues.maxLengthStringSize(enumerationValues.getValuesList());
        String value = EnumerationValues.createOutOfBoundaryValue(enumerationValues, size);
        if (value != null) {
            mynode.setValue(1, value);
        }
    }

    @Override
    protected boolean hasNext(TestStep testStep, SecurityTestRunContext context) {
        if (!context.hasProperty(REQUEST_MUTATIONS_STACK)) {
            Stack requestMutationsList = new Stack();
            context.put(REQUEST_MUTATIONS_STACK, (Object)requestMutationsList);
            try {
                this.extractMutations(testStep, context);
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
            return this.checkIfStackHasContent(context);
        }
        Stack stack = (Stack)context.get(REQUEST_MUTATIONS_STACK);
        if (stack.empty()) {
            context.remove(REQUEST_MUTATIONS_STACK);
            return false;
        }
        return true;
    }

    private boolean checkIfStackHasContent(SecurityTestRunContext context) {
        Stack stack = (Stack)context.get(REQUEST_MUTATIONS_STACK);
        if (stack.empty()) {
            context.remove(REQUEST_MUTATIONS_STACK);
            return false;
        }
        return true;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public String getConfigDescription() {
        return "Configuration for Boundary Security Scan";
    }

    @Override
    public String getConfigName() {
        return "Configuration for Boundary Security Scan";
    }

    @Override
    public String getHelpURL() {
        return "http://www.soapui.org/Security/boundary-scan.html";
    }

    public void refreshRestrictionLabel(int row) {
        if (row == -1) {
            this.restrictionLabel.setJlabel("- no parameter selected -");
            return;
        }
        SecurityCheckedParameter parameter = this.getParameterAt(row);
        if (parameter == null) {
            return;
        }
        String name = parameter.getName();
        String xpath = parameter.getXpath();
        TestProperty tp = this.getTestStep().getProperty(name);
        XmlObjectTreeModel xmlObjectTreeModel = null;
        if (tp.getSchemaType() != null && XmlUtils.seemsToBeXml(tp.getValue())) {
            try {
                xmlObjectTreeModel = new XmlObjectTreeModel(tp.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(tp.getValue()));
            }
            catch (XmlException e) {
                SoapUI.logError(e);
            }
            XmlObjectTreeModel.XmlTreeNode[] treeNodes = xmlObjectTreeModel.selectTreeNodes(xpath);
            if (treeNodes.length == 0) {
                this.restrictionLabel.setJlabel("<html><pre>    </pre></html>");
                return;
            }
            List<String> list = null;
            if (treeNodes[0].getSchemaType() != null && treeNodes[0].getSchemaType().getEnumerationValues() != null) {
                list = BoundaryRestrictionUtill.extractEnums(treeNodes[0]);
                this.restrictionLabel.setJlabel(list.toString().replaceFirst(",", ""));
            } else {
                SchemaTypeImpl simpleType = (SchemaTypeImpl)treeNodes[0].getSchemaType();
                if (simpleType != null && !simpleType.isNoType()) {
                    XmlObjectTreeModel model2 = new XmlObjectTreeModel(simpleType.getTypeSystem(), simpleType.getParseObject());
                    list = BoundaryRestrictionUtill.getRestrictions(model2.getRootNode(), new ArrayList<String>());
                    if (list.isEmpty()) {
                        list.add("No restrictions in schema are specified for this parameter!");
                    }
                    this.restrictionLabel.setJlabel(list.toString());
                } else {
                    this.restrictionLabel.setJlabel("parameter is missing type in schema");
                }
            }
        } else {
            this.restrictionLabel.setJlabel("- no parameter selected -");
        }
    }

    public class RestrictionLabel {
        private String text = "";
        private JLabel jlabel = new JLabel();
        private int limit = 70;

        public RestrictionLabel() {
            this.setJlabel(this.text);
        }

        public void setJlabel(String text) {
            text = text.replace("[", "");
            if ((text = text.replace("]", "")).length() > this.limit) {
                this.jlabel.setToolTipText(text.length() < 250 ? text : text.substring(0, 249) + " ... ");
                this.jlabel.setText(text.substring(0, this.limit - 5) + " ... ");
            } else {
                this.jlabel.setText(text);
            }
        }

        public JLabel getJLabel() {
            return this.jlabel;
        }
    }
}

