/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.boundary;

import com.eviware.soapui.security.boundary.AbstractBoundary;
import com.eviware.soapui.security.boundary.BoundaryUtils;
import java.text.SimpleDateFormat;

public class TimeBoundary
extends AbstractBoundary {
    private static final int OFFSET = 60;
    public static final String TIME_FORMAT = "HH:mm:ssZ";
    private static final ThreadLocal<SimpleDateFormat> simpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TimeBoundary.TIME_FORMAT);
        }
    };

    @Override
    public String outOfBoundary(int restrictionAttribute, String value) {
        switch (restrictionAttribute) {
            case 6: {
                return BoundaryUtils.createTime(value, (int)(Math.random() * 60.0), simpleDateFormat.get());
            }
            case 7: {
                return BoundaryUtils.createTime(value, -((int)(Math.random() * 60.0)), simpleDateFormat.get());
            }
            case 8: {
                return BoundaryUtils.createTime(value, (int)(Math.random() * 60.0 + 1.0), simpleDateFormat.get());
            }
            case 9: {
                return BoundaryUtils.createTime(value, -((int)(Math.random() * 60.0)) - 1, simpleDateFormat.get());
            }
        }
        return null;
    }
}

