/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.boundary;

import com.eviware.soapui.security.boundary.AbstractBoundary;
import com.eviware.soapui.security.boundary.BoundaryUtils;
import java.text.SimpleDateFormat;

public class DateTimeBoundary
extends AbstractBoundary {
    private static final int OFFSET = 10;
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    static final ThreadLocal<SimpleDateFormat> simpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateTimeBoundary.DATE_FORMAT);
        }
    };

    @Override
    public String outOfBoundary(int restrictionAttribute, String value) {
        switch (restrictionAttribute) {
            case 6: {
                return BoundaryUtils.createDate(value, (int)(Math.random() * 10.0), simpleDateFormat.get());
            }
            case 7: {
                return BoundaryUtils.createDate(value, -((int)(Math.random() * 10.0)), simpleDateFormat.get());
            }
            case 8: {
                return BoundaryUtils.createDate(value, (int)(Math.random() * 10.0 + 1.0), simpleDateFormat.get());
            }
            case 9: {
                return BoundaryUtils.createDate(value, -((int)(Math.random() * 10.0)) - 1, simpleDateFormat.get());
            }
        }
        return null;
    }
}

