/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.iface.SoapUIListener;
import com.eviware.soapui.plugins.ApiImporter;
import com.eviware.soapui.plugins.InstalledPluginRecord;
import com.eviware.soapui.plugins.InvalidPluginException;
import com.eviware.soapui.plugins.JarClassLoader;
import com.eviware.soapui.plugins.LoaderBase;
import com.eviware.soapui.plugins.MissingPluginClassException;
import com.eviware.soapui.plugins.Plugin;
import com.eviware.soapui.plugins.PluginAware;
import com.eviware.soapui.plugins.PluginConfiguration;
import com.eviware.soapui.plugins.PluginDependencies;
import com.eviware.soapui.plugins.PluginDependency;
import com.eviware.soapui.plugins.PluginId;
import com.eviware.soapui.plugins.PluginInfo;
import com.eviware.soapui.plugins.SoapUIFactory;
import com.eviware.soapui.plugins.Version;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.SoapUIActionRegistry;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistry;
import com.eviware.soapui.support.listener.ListenerRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

public class PluginLoader
extends LoaderBase {
    public static Logger log = Logger.getLogger(PluginLoader.class);

    public PluginLoader(SoapUIFactoryRegistry factoryRegistry, SoapUIActionRegistry actionRegistry, ListenerRegistry listenerRegistry) {
        super(listenerRegistry, actionRegistry, factoryRegistry);
    }

    InstalledPluginRecord loadPlugin(File pluginFile, Collection<JarClassLoader> dependencyClassLoaders) throws IOException {
        ReflectionsAndClassLoader tuple = this.makeJarFileScanner(pluginFile, dependencyClassLoaders);
        Class<?> pluginClass = this.readPluginConfigurationClasses(pluginFile, tuple.reflections);
        Plugin plugin = this.loadPlugin(pluginClass, tuple.reflections);
        return new InstalledPluginRecord(plugin, tuple.jarClassLoader);
    }

    private ReflectionsAndClassLoader makeJarFileScanner(File pluginFile, Collection<JarClassLoader> dependencyClassLoaders) throws IOException {
        File tempFile = File.createTempFile("soapuios", ".jar");
        tempFile.deleteOnExit();
        FileUtils.copyFile((File)pluginFile, (File)tempFile);
        JarClassLoader jarClassLoader = new JarClassLoader(tempFile, PluginLoader.class.getClassLoader(), dependencyClassLoaders);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(jarClassLoader.getURLs()).addClassLoader((ClassLoader)jarClassLoader);
        if (jarClassLoader.hasScripts()) {
            configurationBuilder.addClassLoader((ClassLoader)jarClassLoader.getScriptClassLoader());
            configurationBuilder.addScanners(new Scanner[]{new TypeAnnotationsScanner()});
            configurationBuilder.setMetadataAdapter((MetadataAdapter)new LoaderBase.GroovyAndJavaReflectionAdapter(jarClassLoader));
        }
        return new ReflectionsAndClassLoader(new Reflections((Configuration)configurationBuilder), jarClassLoader);
    }

    private Class<?> readPluginConfigurationClasses(File pluginFile, Reflections jarFileScanner) {
        Set pluginClasses = jarFileScanner.getTypesAnnotatedWith(PluginConfiguration.class);
        if (pluginClasses.isEmpty()) {
            log.warn((Object)("No plugin classes found in JAR file " + pluginFile));
            throw new MissingPluginClassException("No plugin class found in " + pluginFile);
        }
        if (pluginClasses.size() > 1) {
            throw new InvalidPluginException("Multiple plugin classes found in " + pluginFile + ": " + pluginClasses);
        }
        return (Class)pluginClasses.iterator().next();
    }

    Plugin loadPlugin(Class<?> pluginClass, Reflections jarFileScanner) {
        try {
            PluginConfiguration configurationAnnotation = pluginClass.getAnnotation(PluginConfiguration.class);
            Version minimumReadyApiVersion = Version.fromString(configurationAnnotation.minimumReadyApiVersion());
            Version installedReadyApiVersion = Version.fromString(SoapUI.SOAPUI_VERSION);
            if (minimumReadyApiVersion.compareTo(installedReadyApiVersion) > 0) {
                throw new InvalidPluginException("Plugin " + configurationAnnotation.name() + " requires version " + minimumReadyApiVersion + " of ReadyAPI. Current application version: " + installedReadyApiVersion);
            }
            Plugin plugin = Plugin.class.isAssignableFrom(pluginClass) ? (Plugin)pluginClass.newInstance() : new EmptyPlugin(configurationAnnotation);
            boolean autoDetect = configurationAnnotation.autoDetect();
            if (plugin.isActive()) {
                plugin.initialize();
                Collection<SoapUIFactory> factories = this.loadPluginFactories(plugin, autoDetect, jarFileScanner);
                List<SoapUIAction> actions = this.loadPluginActions(plugin, autoDetect, jarFileScanner);
                List<Class<? extends SoapUIListener>> listeners = this.loadPluginListeners(plugin, autoDetect, jarFileScanner);
                return this.createLoadedPluginInstance(plugin, factories, actions, listeners);
            }
            return plugin;
        }
        catch (InvalidPluginException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvalidPluginException("Error loading plugin " + pluginClass, e);
        }
    }

    private LoadedPlugin createLoadedPluginInstance(Plugin plugin, Collection<SoapUIFactory> factories, List<SoapUIAction> actions, List<Class<? extends SoapUIListener>> listeners) {
        LoadedPlugin loadedPlugin = new LoadedPlugin(plugin, factories, actions, listeners);
        for (SoapUIFactory factory : factories) {
            if (!(factory instanceof PluginAware)) continue;
            ((PluginAware)((Object)factory)).setPlugin(loadedPlugin);
        }
        for (SoapUIAction action : actions) {
            if (!(action instanceof PluginAware)) continue;
            ((PluginAware)((Object)action)).setPlugin(loadedPlugin);
        }
        return loadedPlugin;
    }

    private Collection<SoapUIFactory> loadPluginFactories(Plugin plugin, boolean autoDetect, Reflections jarFileScanner) throws IllegalAccessException, InstantiationException {
        HashSet<SoapUIFactory> factories = new HashSet<SoapUIFactory>(plugin.getFactories());
        if (!factories.isEmpty()) {
            this.registerFactories(factories);
        }
        if (autoDetect) {
            factories.addAll(this.loadFactories(jarFileScanner));
        }
        return factories;
    }

    private List<Class<? extends SoapUIListener>> loadPluginListeners(Plugin plugin, boolean autoDetect, Reflections jarFileScanner) throws IllegalAccessException, InstantiationException {
        ArrayList<Class<? extends SoapUIListener>> listeners = new ArrayList<Class<? extends SoapUIListener>>(plugin.getListeners());
        if (!listeners.isEmpty()) {
            this.registerListeners(listeners);
        }
        if (autoDetect) {
            listeners.addAll(this.loadListeners(jarFileScanner));
        }
        return listeners;
    }

    private List<SoapUIAction> loadPluginActions(Plugin plugin, boolean autoDetect, Reflections jarFileScanner) throws InstantiationException, IllegalAccessException {
        ArrayList<SoapUIAction> actions = new ArrayList<SoapUIAction>(plugin.getActions());
        if (!actions.isEmpty()) {
            this.registerActions(actions);
        }
        if (autoDetect) {
            actions.addAll(this.loadActions(jarFileScanner));
        }
        return actions;
    }

    public void unloadPlugin(Plugin plugin) {
        this.unregisterActions(plugin.getActions());
        this.unregisterListeners(plugin.getListeners());
        this.unregisterFactories(plugin.getFactories());
    }

    public PluginInfo loadPluginInfoFrom(File pluginFile, Collection<JarClassLoader> dependencyClassLoaders) throws IOException {
        ReflectionsAndClassLoader tuple = this.makeJarFileScanner(pluginFile, dependencyClassLoaders);
        Class<?> pluginClass = this.readPluginConfigurationClasses(pluginFile, tuple.reflections);
        return PluginLoader.readPluginInfoFrom(pluginClass);
    }

    static PluginInfo readPluginInfoFrom(Class<?> pluginClass) {
        PluginInfo pluginInfo = PluginLoader.readPluginInfoFromAnnotation(pluginClass.getAnnotation(PluginConfiguration.class));
        PluginLoader.addDependency(pluginInfo, pluginClass.getAnnotation(PluginDependency.class));
        PluginDependencies pluginDependenciesAnnotation = pluginClass.getAnnotation(PluginDependencies.class);
        if (pluginDependenciesAnnotation != null) {
            for (PluginDependency pluginDependency : pluginDependenciesAnnotation.value()) {
                PluginLoader.addDependency(pluginInfo, pluginDependency);
            }
        }
        return pluginInfo;
    }

    private static void addDependency(PluginInfo pluginInfo, PluginDependency dependencyAnnotation) {
        if (dependencyAnnotation != null) {
            PluginId id = new PluginId(dependencyAnnotation.groupId(), dependencyAnnotation.name());
            pluginInfo.addDependency(new PluginInfo(id, Version.fromString(dependencyAnnotation.minimumVersion()), "", ""));
        }
    }

    static PluginInfo readPluginInfoFromAnnotation(PluginConfiguration annotation) {
        PluginId id = new PluginId(annotation.groupId(), annotation.name());
        Version version = Version.fromString(annotation.version());
        String infoUrl = annotation.infoUrl();
        return new PluginInfo(id, version, annotation.description(), infoUrl);
    }

    private class ReflectionsAndClassLoader {
        Reflections reflections;
        JarClassLoader jarClassLoader;

        private ReflectionsAndClassLoader(Reflections reflections, JarClassLoader jarClassLoader) {
            this.reflections = reflections;
            this.jarClassLoader = jarClassLoader;
        }
    }

    private class EmptyPlugin
    implements Plugin {
        private PluginInfo pluginInfo;

        private EmptyPlugin(PluginConfiguration annotation) {
            this.pluginInfo = PluginLoader.readPluginInfoFromAnnotation(annotation);
        }

        @Override
        public PluginInfo getInfo() {
            return this.pluginInfo;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void initialize() {
        }

        @Override
        public List<Class<? extends SoapUIListener>> getListeners() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends SoapUIAction> getActions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<? extends ApiImporter> getApiImporters() {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends SoapUIFactory> getFactories() {
            return Collections.emptySet();
        }

        @Override
        public boolean hasSameIdAs(Plugin otherPlugin) {
            return this.pluginInfo.getId().equals(otherPlugin.getInfo().getId());
        }
    }

    private class LoadedPlugin
    implements Plugin {
        private final Plugin plugin;
        private final Collection<SoapUIFactory> factories;
        private final List<SoapUIAction> actions;
        private final List<Class<? extends SoapUIListener>> listeners;

        public LoadedPlugin(Plugin plugin, Collection<SoapUIFactory> factories, List<SoapUIAction> actions, List<Class<? extends SoapUIListener>> listeners) {
            this.plugin = plugin;
            this.factories = factories;
            this.actions = actions;
            this.listeners = listeners;
        }

        @Override
        public PluginInfo getInfo() {
            return this.plugin.getInfo();
        }

        @Override
        public boolean isActive() {
            return this.plugin.isActive();
        }

        @Override
        public void initialize() {
            throw new IllegalStateException("Plugin has already been initialized");
        }

        @Override
        public List<Class<? extends SoapUIListener>> getListeners() {
            return this.listeners;
        }

        @Override
        public List<? extends SoapUIAction> getActions() {
            return this.actions;
        }

        @Override
        public Collection<? extends ApiImporter> getApiImporters() {
            return Collections.emptySet();
        }

        @Override
        public Collection<? extends SoapUIFactory> getFactories() {
            return this.factories;
        }

        @Override
        public boolean hasSameIdAs(Plugin otherPlugin) {
            return this.plugin.hasSameIdAs(otherPlugin);
        }

        public String toString() {
            return this.plugin.toString();
        }
    }

    private static class TypeAnnotationsScanner
    extends org.reflections.scanners.TypeAnnotationsScanner {
        private TypeAnnotationsScanner() {
        }

        public boolean acceptsInput(String file) {
            if (file.endsWith(".groovy")) {
                return true;
            }
            return super.acceptsInput(file);
        }
    }
}

