/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import com.eviware.soapui.plugins.PluginClassLoader;
import com.eviware.soapui.support.Tools;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class JarClassLoader
extends URLClassLoader
implements PluginClassLoader {
    private static final Logger log = Logger.getLogger(JarClassLoader.class);
    public static final String LIB_PREFIX = "lib/";
    private final ClassLoader parent;
    private Collection<JarClassLoader> dependencyClassLoaders;
    private GroovyClassLoader scriptClassLoader;

    public JarClassLoader(File jarFile, ClassLoader parent, Collection<JarClassLoader> dependencyClassLoaders) throws IOException {
        super(new URL[]{jarFile.toURI().toURL()}, (ClassLoader)null);
        this.parent = parent;
        this.dependencyClassLoaders = dependencyClassLoaders;
        JarFile file = new JarFile(jarFile);
        this.addLibrariesIn(file);
        this.addScriptsIn(file);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            for (JarClassLoader dependencyClassLoader : this.dependencyClassLoaders) {
                try {
                    return dependencyClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
            }
            return this.parent.loadClass(name);
        }
        catch (NoClassDefFoundError e) {
            for (JarClassLoader dependencyClassLoader : this.dependencyClassLoaders) {
                try {
                    return dependencyClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
            }
            return this.parent.loadClass(name);
        }
    }

    private void addLibrariesIn(JarFile jarFile) throws IOException {
        if (this.containsLibraries(jarFile)) {
            File libDirectory = Tools.createTemporaryDirectory();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!this.isLibrary(jarEntry)) continue;
                String fileName = jarEntry.getName().substring(LIB_PREFIX.length());
                File outputFile = new File(libDirectory, fileName);
                FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(jarEntry), (File)outputFile);
                this.addURL(outputFile.toURI().toURL());
            }
        }
    }

    private void addScriptsIn(JarFile jarFile) throws IOException {
        boolean hasScripts = false;
        if (this.containsScripts(jarFile)) {
            File scriptsDirectory = Tools.createTemporaryDirectory();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!this.isScript(jarEntry)) continue;
                String pathToScript = jarEntry.getName();
                File outputFile = null;
                int lastSlashIndex = pathToScript.lastIndexOf(47);
                if (lastSlashIndex >= 0) {
                    File packageDirectory = new File(scriptsDirectory, pathToScript.substring(0, lastSlashIndex));
                    if (!(packageDirectory.exists() && packageDirectory.isDirectory() || packageDirectory.mkdirs())) {
                        log.error((Object)("Failed to create directory for [" + pathToScript + "]"));
                        packageDirectory = null;
                    }
                    if (packageDirectory != null) {
                        outputFile = new File(packageDirectory, pathToScript.substring(lastSlashIndex + 1));
                    }
                }
                if (outputFile == null) continue;
                FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(jarEntry), outputFile);
                hasScripts = true;
            }
        }
    }

    private boolean containsLibraries(JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!this.isLibrary(jarEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean containsScripts(JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!this.isScript(jarEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean isLibrary(JarEntry jarEntry) {
        return jarEntry.getName().startsWith(LIB_PREFIX) && jarEntry.getName().endsWith(".jar");
    }

    private boolean isScript(JarEntry jarEntry) {
        return jarEntry.getName().endsWith(".groovy");
    }

    public boolean hasScripts() {
        return this.scriptClassLoader != null;
    }

    public Class loadScriptClass(String path) throws ClassNotFoundException {
        path = path.substring(0, path.length() - ".groovy".length());
        return this.scriptClassLoader.loadClass(path, true, true, true);
    }

    public GroovyClassLoader getScriptClassLoader() {
        return this.scriptClassLoader;
    }
}

