/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractModelItemTreeNode<T extends ModelItem>
implements SoapUITreeNode,
PropertyChangeListener {
    private final T modelItem;
    private final ModelItem parentItem;
    private final SoapUITreeModel treeModel;
    private List<? extends SoapUITreeNode> orderItems;
    private String orderSetting;
    private InternalSettingsListener internalSettingsListener;

    protected AbstractModelItemTreeNode(T modelItem, ModelItem parentItem, SoapUITreeModel treeModel) {
        this.modelItem = modelItem;
        this.parentItem = parentItem;
        this.treeModel = treeModel;
        modelItem.addPropertyChangeListener(this);
    }

    public SoapUITreeModel getTreeModel() {
        return this.treeModel;
    }

    public T getModelItem() {
        return this.modelItem;
    }

    @Override
    public boolean valueChanged(Object newValue) {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public int getChildCount() {
        return this.orderItems == null ? 0 : this.orderItems.size();
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        return this.orderItems == null ? null : this.orderItems.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.orderItems == null ? -1 : this.orderItems.indexOf(child);
    }

    public String toString() {
        if (this.modelItem instanceof TestStep) {
            return ((TestStep)this.modelItem).getLabel();
        }
        if (this.modelItem instanceof TestCase) {
            return ((TestCase)this.modelItem).getLabel();
        }
        return this.modelItem.getName();
    }

    @Override
    public JPopupMenu getPopup() {
        return ActionSupport.buildPopup(this.getActions());
    }

    @Override
    public ActionList getActions() {
        return ActionListBuilder.buildActions(this.modelItem);
    }

    @Override
    public SoapUITreeNode getParentTreeNode() {
        return this.treeModel.getTreeNode(this.parentItem);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TreePath nodePath;
        JTree mainTree;
        Rectangle rowBounds;
        String propertyName = evt.getPropertyName();
        if (propertyName.equals(ModelItem.NAME_PROPERTY) || propertyName.equals(ModelItem.LABEL_PROPERTY)) {
            this.getTreeModel().notifyNodeChanged(this);
        } else if (propertyName.equals(ModelItem.ICON_PROPERTY) && (rowBounds = (mainTree = SoapUI.getNavigator().getMainTree()).getPathBounds(nodePath = this.getTreeModel().getPath(this))) != null) {
            mainTree.repaint(rowBounds);
        }
    }

    @Override
    public void release() {
        this.modelItem.removePropertyChangeListener(this);
        if (this.internalSettingsListener != null) {
            SoapUI.getSettings().removeSettingsListener(this.internalSettingsListener);
        }
        this.getTreeModel().unmapModelItem((ModelItem)this.modelItem);
    }

    public <T2 extends SoapUITreeNode> void initOrdering(List<T2> items, String setting) {
        this.orderItems = items;
        this.orderSetting = setting;
        this.internalSettingsListener = new InternalSettingsListener(this, setting);
        SoapUI.getSettings().addSettingsListener(this.internalSettingsListener);
        this.sortModelItems(items, setting);
    }

    @Override
    public void reorder(boolean notify) {
        if (this.orderItems != null) {
            this.sortModelItems(this.orderItems, this.orderSetting);
            if (notify) {
                this.getTreeModel().notifyStructureChanged(new TreeModelEvent((Object)this, this.getTreeModel().getPath(this)));
            }
        }
    }

    public <T2 extends SoapUITreeNode> void sortModelItems(List<T2> modelItems, final String setting) {
        Collections.sort(modelItems, new Comparator<T2>(){

            @Override
            public int compare(T2 o1, T2 o2) {
                String name1 = o1.getModelItem().getName();
                String name2 = o2.getModelItem().getName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                if (setting != null && SoapUI.getSettings().getBoolean(setting)) {
                    return name1.compareToIgnoreCase(name2);
                }
                return name1.compareTo(name2);
            }
        });
    }

    public Enumeration<?> children() {
        Vector<TreeNode> children = new Vector<TreeNode>();
        for (int c = 0; c < this.getChildCount(); ++c) {
            children.add(this.getChildAt(c));
        }
        return children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getChildNode(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getIndexOfChild(node);
    }

    @Override
    public TreeNode getParent() {
        return this.getParentTreeNode();
    }

    public class ReorderPropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            AbstractModelItemTreeNode.this.reorder(true);
            SoapUI.getNavigator().selectModelItem((ModelItem)arg0.getSource());
        }
    }

    private final class InternalSettingsListener
    implements SettingsListener {
        private final AbstractModelItemTreeNode<?> node;
        private final String setting;

        public InternalSettingsListener(AbstractModelItemTreeNode<?> node, String setting) {
            this.node = node;
            this.setting = setting;
        }

        @Override
        public void settingChanged(String name, String newValue, String oldValue) {
            if (name.equals(this.setting)) {
                if (oldValue == null) {
                    oldValue = "false";
                }
                if (newValue == null) {
                    newValue = "false";
                }
                if (!oldValue.equals(newValue)) {
                    TreePath path = AbstractModelItemTreeNode.this.getTreeModel().getPath(AbstractModelItemTreeNode.this);
                    this.node.reorder(SoapUI.getNavigator().isVisible(path) && SoapUI.getNavigator().isExpanded(path));
                }
            }
        }

        @Override
        public void settingsReloaded() {
        }
    }
}

