/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.testsuite.TestProperty;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class TestPropertyUtils {
    private static boolean ascending;

    public static int saveTo(TestPropertyHolder propertyHolder, String fileName) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(fileName));
        for (TestProperty prop : propertyHolder.getPropertyList()) {
            writer.print(prop.getName());
            writer.print('=');
            String value = prop.getValue();
            if (value == null) {
                value = "";
            }
            String[] lines = value.split("\n");
            for (int c = 0; c < lines.length; ++c) {
                if (c > 0) {
                    writer.println("\\");
                }
                writer.print(TestPropertyUtils.addEndingSlashes(lines[c]));
            }
            writer.println();
        }
        writer.close();
        return propertyHolder.getPropertyCount();
    }

    private static String addEndingSlashes(String value) {
        int endingSlashesCount = TestPropertyUtils.countEndingSlashes(value);
        if (endingSlashesCount == 0) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value);
        for (int i = 0; i < endingSlashesCount; ++i) {
            buf.append('\\');
        }
        return buf.toString();
    }

    public static int countEndingSlashes(String value) {
        int count = 0;
        for (int i = value.length() - 1; i >= 0 && value.charAt(i) == '\\'; --i) {
            ++count;
        }
        return count;
    }

    public static synchronized void sortProperties(MutableTestPropertyHolder holder) {
        ascending = false;
        Object[] names = holder.getPropertyNames();
        TestPropertyUtils.quicksort(holder, 0, holder.getPropertyCount() - 1);
        if (Arrays.equals(names, holder.getPropertyNames())) {
            ascending = true;
            TestPropertyUtils.quicksort(holder, 0, holder.getPropertyCount() - 1);
        }
    }

    private static void quicksort(MutableTestPropertyHolder array, int lo, int hi) {
        if (hi > lo) {
            int partitionPivotIndex = (int)(Math.random() * (double)(hi - lo) + (double)lo);
            int newPivotIndex = TestPropertyUtils.partition(array, lo, hi, partitionPivotIndex);
            TestPropertyUtils.quicksort(array, lo, newPivotIndex - 1);
            TestPropertyUtils.quicksort(array, newPivotIndex + 1, hi);
        }
    }

    private static int partition(MutableTestPropertyHolder array, int lo, int hi, int pivotIndex) {
        TestProperty pivotValue = array.getPropertyAt(pivotIndex);
        TestPropertyUtils.swap(array, pivotIndex, hi);
        int index = lo;
        for (int i = lo; i < hi; ++i) {
            if (ascending) {
                if (array.getPropertyAt(i).getName().toUpperCase().compareTo(pivotValue.getName().toUpperCase()) < 0) continue;
                TestPropertyUtils.swap(array, i, index);
                ++index;
                continue;
            }
            if (array.getPropertyAt(i).getName().toUpperCase().compareTo(pivotValue.getName().toUpperCase()) > 0) continue;
            TestPropertyUtils.swap(array, i, index);
            ++index;
        }
        TestPropertyUtils.swap(array, hi, index);
        return index;
    }

    private static void swap(MutableTestPropertyHolder array, int i, int j) {
        String prop1 = array.getPropertyAt(i).getName();
        String prop2 = array.getPropertyAt(j).getName();
        array.moveProperty(prop1, j);
        array.moveProperty(prop2, i);
    }
}

