/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.security;

import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.security.SensitiveInformationPropertyHolder;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class SensitiveInformationTableModel
extends DefaultTableModel {
    private String[] columnNames = new String[]{"Token", "Description"};
    private MutableTestPropertyHolder holder;

    public MutableTestPropertyHolder getHolder() {
        return this.holder;
    }

    public SensitiveInformationTableModel(MutableTestPropertyHolder holder) {
        this.holder = holder;
    }

    public SensitiveInformationTableModel(MutableTestPropertyHolder holder, String tokenHeader) {
        this(holder);
        this.columnNames[0] = tokenHeader;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Object getValueAt(int row, int column) {
        TestProperty param = this.holder.getPropertyList().get(row);
        switch (column) {
            case 0: {
                return param.getName();
            }
            case 1: {
                return param.getValue();
            }
        }
        return super.getValueAt(row, column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.holder.getPropertyList().isEmpty()) {
            return;
        }
        SensitiveInformationPropertyHolder.SensitiveTokenProperty param = (SensitiveInformationPropertyHolder.SensitiveTokenProperty)this.holder.getPropertyList().get(row);
        switch (column) {
            case 0: {
                param.setName((String)aValue);
                break;
            }
            case 1: {
                param.setValue((String)aValue);
            }
        }
    }

    public void addToken(String token, String description) {
        this.holder.setPropertyValue(token, description);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.holder == null ? 0 : (this.holder.getPropertyList() == null ? 0 : this.holder.getPropertyList().size());
    }

    public void removeRows(int[] selectedRows) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (int index : selectedRows) {
            String name = (String)this.getValueAt(index, 0);
            toRemove.add(name);
        }
        Object object = toRemove.iterator();
        while (object.hasNext()) {
            String name = (String)object.next();
            this.holder.removeProperty(name);
        }
        this.fireTableDataChanged();
    }
}

