/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.security;

import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.security.support.SecurityCheckedParameterHolder;
import com.eviware.soapui.security.support.SecurityCheckedParameterImpl;
import javax.swing.table.DefaultTableModel;

public class SecurityParametersTableModel
extends DefaultTableModel {
    private String[] columnNames = new String[]{"Label", "Name", "XPath", "Enabled"};
    private SecurityCheckedParameterHolder holder;

    public SecurityParametersTableModel(SecurityCheckedParameterHolder holder) {
        this.holder = holder;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        SecurityCheckedParameter param = this.holder.getParameterList().get(row);
        switch (column) {
            case 0: {
                return param.getLabel();
            }
            case 1: {
                return param.getName();
            }
            case 2: {
                return param.getXpath();
            }
            case 3: {
                return param.isChecked();
            }
        }
        return super.getValueAt(row, column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 3 ? Boolean.class : (columnIndex == 2 ? String.class : Object.class);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.holder.getParameterList().isEmpty()) {
            return;
        }
        SecurityCheckedParameterImpl param = (SecurityCheckedParameterImpl)this.holder.getParameterList().get(row);
        switch (column) {
            case 0: {
                param.setLabel((String)aValue);
                break;
            }
            case 1: {
                param.setName((String)aValue);
                break;
            }
            case 2: {
                param.setXpath((String)aValue);
                break;
            }
            case 3: {
                param.setChecked((Boolean)aValue);
            }
        }
    }

    public boolean addParameter(String label, String name, String xpath) {
        if (this.holder.addParameter(label, name, xpath, true)) {
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        return this.holder == null ? 0 : this.holder.getParameterList().size();
    }

    public void removeRows(int[] selectedRows) {
        this.holder.removeParameters(selectedRows);
    }
}

