/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.propertyexpansion;

import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.StringUtils;

public class PropertyExpansionImpl
implements PropertyExpansion {
    private String xpath;
    private TestProperty property;
    private String containerInfo;

    public PropertyExpansionImpl(TestProperty property, String xpath) {
        this.property = property;
        this.xpath = xpath;
        this.containerInfo = property.getName();
        if (property.getModelItem() != null) {
            this.containerInfo = this.containerInfo + " in " + property.getModelItem().getName();
        }
    }

    @Override
    public TestProperty getProperty() {
        return this.property;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("${");
        ModelItem modelItem = this.property.getModelItem();
        if (modelItem instanceof Project) {
            result.append("#Project#");
        } else if (modelItem instanceof TestSuite) {
            result.append("#TestSuite#");
        } else if (modelItem instanceof TestCase) {
            result.append("#TestCase#");
        } else if (modelItem instanceof SecurityTest) {
            result.append("#SecurityTest#");
        } else if (modelItem instanceof MockService) {
            result.append("#MockService#");
        } else if (modelItem instanceof MockResponse) {
            result.append("#MockResponse#");
        } else if (modelItem instanceof TestStep) {
            result.append(modelItem.getName()).append('#');
        } else if (modelItem instanceof TestRequest) {
            result.append(((TestRequest)modelItem).getTestStep().getName()).append('#');
        }
        result.append(this.property.getName());
        if (StringUtils.hasContent(this.xpath)) {
            result.append('#').append(this.xpath);
        }
        result.append('}');
        return result.toString();
    }

    @Override
    public String getXPath() {
        return this.xpath;
    }

    @Override
    public String getContainerInfo() {
        return this.containerInfo;
    }

    public void setContainerInfo(String containerInfo) {
        this.containerInfo = containerInfo;
    }

    protected void setProperty(TestProperty property) {
        this.property = property;
    }

    protected void setXPath(String xpath) {
        this.xpath = xpath;
    }
}

