/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.soap;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.WsaAssertionConfiguration;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.support.wsa.WsaValidator;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class WSAResponseAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "WS-A Response Assertion";
    public static final String LABEL = "WS-Addressing Response";
    private WsaAssertionConfiguration wsaAssertionConfiguration;
    private boolean assertWsaAction;
    private boolean assertWsaTo;
    private boolean assertWsaRelatesTo;
    private boolean assertReplyToRefParams;
    private boolean assertFaultToRefParams;
    private XFormDialog dialog;
    private static final String ASSERT_ACTION = "wsa:Action";
    private static final String ASSERT_TO = "wsa:To";
    private static final String ASSERT_RELATES_TO = "wsa:RelatesTo";
    private static final String ASSERT_REPLY_TO_REF_PARAMS = "wsa:ReplyTo ReferenceParameters";
    private static final String ASSERT_FAULT_TO_REF_PARAMS = "wsa:FaultTo ReferenceParameters";
    public static final String DESCRIPTION = "Validates that the last received response contains valid WS-Addressing Headers. Applicable to SOAP TestRequest Steps only.";

    public WSAResponseAssertion(TestAssertionConfig assertionConfig, Assertable modelItem) {
        super(assertionConfig, modelItem, false, true, false, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.assertWsaAction = reader.readBoolean("asertWsaAction", true);
        this.assertWsaTo = reader.readBoolean("asertWsaTo", false);
        this.assertWsaRelatesTo = reader.readBoolean("asertWsaRelatesTo", false);
        this.assertReplyToRefParams = reader.readBoolean("assertReplyToRefParams", false);
        this.assertFaultToRefParams = reader.readBoolean("assertFaultToRefParams", false);
        this.wsaAssertionConfiguration = new WsaAssertionConfiguration(this.assertWsaAction, this.assertWsaTo, false, false, this.assertWsaRelatesTo, this.assertReplyToRefParams, this.assertFaultToRefParams);
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        try {
            new WsaValidator((WsdlMessageExchange)messageExchange, this.wsaAssertionConfiguration).validateWsAddressingResponse();
        }
        catch (AssertionException e) {
            throw new AssertionException(new AssertionError(e.getMessage()));
        }
        catch (XmlException e) {
            SoapUI.logError(e);
            throw new AssertionException(new AssertionError("There has been some XmlException, WS-A couldn't be validated properly."));
        }
        return "Response WS-Addressing is valid";
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        StringToStringMap values = new StringToStringMap();
        values.put(ASSERT_ACTION, this.assertWsaAction);
        values.put(ASSERT_TO, this.assertWsaTo);
        values.put(ASSERT_RELATES_TO, this.assertWsaRelatesTo);
        values.put(ASSERT_REPLY_TO_REF_PARAMS, this.assertReplyToRefParams);
        values.put(ASSERT_FAULT_TO_REF_PARAMS, this.assertFaultToRefParams);
        values = this.dialog.show(values);
        if (this.dialog.getReturnValue() == 1) {
            this.assertWsaAction = values.getBoolean(ASSERT_ACTION);
            this.assertWsaTo = values.getBoolean(ASSERT_TO);
            this.assertWsaRelatesTo = values.getBoolean(ASSERT_RELATES_TO);
            this.assertReplyToRefParams = values.getBoolean(ASSERT_REPLY_TO_REF_PARAMS);
            this.assertFaultToRefParams = values.getBoolean(ASSERT_FAULT_TO_REF_PARAMS);
        }
        this.wsaAssertionConfiguration = new WsaAssertionConfiguration(this.assertWsaAction, this.assertWsaTo, false, false, this.assertWsaRelatesTo, this.assertReplyToRefParams, this.assertFaultToRefParams);
        this.setConfiguration(this.createConfiguration());
        return true;
    }

    private void buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("WS-A properties to assert");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addCheckBox(ASSERT_ACTION, "Check if 'wsa:Action' exists and has the right value");
        mainForm.addCheckBox(ASSERT_TO, "Check if 'wsa:To' exists");
        mainForm.addCheckBox(ASSERT_RELATES_TO, "Check if 'wsa:RelatesTo' exists and is equal to request MessageID");
        mainForm.addCheckBox(ASSERT_REPLY_TO_REF_PARAMS, "Check if 'wsa:ReplyTo' ReferenceParameters exist");
        mainForm.addCheckBox(ASSERT_FAULT_TO_REF_PARAMS, "Check if 'wsa:FaultTo' ReferenceParameters exist");
        this.dialog = builder.buildDialog(builder.buildOkCancelHelpActions("/functional-testing/validating-messages/getting-started-with-assertions.html"), "Specify options", UISupport.OPTIONS_ICON);
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("asertWsaAction", this.assertWsaAction);
        builder.add("asertWsaTo", this.assertWsaTo);
        builder.add("asertWsaRelatesTo", this.assertWsaRelatesTo);
        builder.add("assertReplyToRefParams", this.assertReplyToRefParams);
        builder.add("assertFaultToRefParams", this.assertFaultToRefParams);
        return builder.finish();
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(WSAResponseAssertion.ID, WSAResponseAssertion.LABEL, WSAResponseAssertion.class, WsdlRequest.class);
        }

        @Override
        public String getCategory() {
            return "Compliance, Status and Standards";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return WSAResponseAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry(WSAResponseAssertion.ID, WSAResponseAssertion.LABEL, WSAResponseAssertion.DESCRIPTION);
        }
    }
}

