/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.json;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.XPathContainsAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.json.JsonPathAssertionBase;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.JsonPathFacade;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import javax.swing.JTextArea;
import junit.framework.Assert;

public class JsonPathExistenceAssertion
extends JsonPathAssertionBase
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "JsonPath Existence Match";
    public static final String LABEL = "JsonPath Existence Match";
    public static final String DESCRIPTION = "Uses an JsonPath expression to select content from the target property and compares the result to an expected value. Applicable to any property containing JSON.";

    public JsonPathExistenceAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable);
    }

    @Override
    public String getHelpURL() {
        return "/functional-testing/validating-messages/validating-json-messages.html";
    }

    @Override
    protected XPathContainsAssertion getAssertion() {
        return this;
    }

    @Override
    public String getConfigurationDialogTitle() {
        return "JSONPath Existence Match Configuration";
    }

    @Override
    public void selectFromCurrent() {
        try {
            Object result;
            String assertableContent = this.getAssertable().getAssertableContent();
            if (StringUtils.isNullOrEmpty(assertableContent)) {
                UISupport.showErrorMessage("Missing content to select from");
                return;
            }
            String pathString = this.getPathString();
            PropertyExpansionContext context = this.getPropertyExpansionContext();
            String expandedPath = PropertyExpander.expandProperties(context, pathString.trim());
            JTextArea contentArea = this.getContentArea();
            if (contentArea != null && contentArea.isVisible()) {
                contentArea.setText("");
            }
            this.setExpectedValueFromSelectedNode(contentArea, Boolean.toString((result = new JsonPathFacade(assertableContent).readObjectValue(expandedPath)) != null));
        }
        catch (Throwable e) {
            UISupport.showErrorMessage("Invalid JsonPath expression.");
            SoapUI.logError(e);
        }
    }

    private void setExpectedValueFromSelectedNode(JTextArea contentArea, String stringValue) {
        if (contentArea != null && contentArea.isVisible()) {
            contentArea.setText(stringValue);
        } else {
            this.setExpectedContent(stringValue, false);
        }
    }

    @Override
    public String assertContent(String assertableContent, SubmitContext context, String type) throws AssertionException {
        String path = this.getPath();
        try {
            if (path == null) {
                return "Missing path for JsonPath assertion";
            }
            if (this.getExpectedContent() == null) {
                return "Missing content for JsonPath assertion";
            }
            String expandedPath = PropertyExpander.expandProperties(context, path);
            JsonPathFacade jsonPathFacade = new JsonPathFacade(assertableContent);
            Object result = jsonPathFacade.readObjectValue(expandedPath);
            String expandedExpectedValue = PropertyExpander.expandProperties(context, this.getExpectedContent());
            Assert.assertEquals((String)expandedExpectedValue, (String)Boolean.toString(result != null));
        }
        catch (Throwable exception) {
            this.throwAssertionException(path, exception);
        }
        return type + " matches content for [" + path + "]";
    }

    public static class Factory
    extends JsonPathAssertionBase.JsonAssertionFactory {
        public Factory() {
            super("JsonPath Existence Match", "JsonPath Existence Match", JsonPathExistenceAssertion.DESCRIPTION, JsonPathExistenceAssertion.class);
        }
    }
}

