/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathImpl;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.AbstractXmlContainsAssertion;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.XmlUtils;
import javax.swing.JTextArea;
import junit.framework.ComparisonFailure;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlQName;
import org.apache.xmlbeans.impl.values.XmlValueDisconnectedException;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathContainsAssertion
extends AbstractXmlContainsAssertion {
    public static final String ID = "XPath Match";
    public static final String LABEL = "XPath Match";
    public static final String DESCRIPTION = "Uses an XPath expression to select content from the target property and compares the result to an expected value. Applicable to any property containing XML.";

    public XPathContainsAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, true, true, true, true);
    }

    @Override
    public String assertContent(String response, SubmitContext context, String type) throws AssertionException {
        try {
            if (this.path == null) {
                return "Missing path for XPath assertion";
            }
            if (this.expectedContent == null) {
                return "Missing content for XPath assertion";
            }
            XmlOptions options = new XmlOptions();
            if (this.ignoreComments) {
                options.setLoadStripComments();
            }
            XmlObject xml = XmlUtils.createXmlObject(response, options);
            String expandedPath = PropertyExpander.expandProperties(context, this.path);
            XmlObject[] items = xml.selectPath(expandedPath);
            AssertedXPathsContainer assertedXPathsContainer = (AssertedXPathsContainer)context.getProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY);
            XmlObject contentObj = null;
            String expandedContent = PropertyExpander.expandProperties(context, this.expectedContent);
            if (!expandedPath.endsWith("text()")) {
                try {
                    contentObj = XmlUtils.createXmlObject(expandedContent, options);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (items.length == 0) {
                throw new Exception("Missing content for xpath [" + this.path + "] in " + type);
            }
            options.setSavePrettyPrint();
            options.setSaveOuter();
            for (int c = 0; c < items.length; ++c) {
                try {
                    String xpath;
                    AssertedXPathImpl assertedXPathImpl = null;
                    if (assertedXPathsContainer != null && (xpath = XmlUtils.createAbsoluteXPath(items[c].getDomNode())) != null) {
                        XmlObject xmlObj = items[c];
                        assertedXPathImpl = new AssertedXPathImpl(this, xpath, xmlObj);
                        assertedXPathsContainer.addAssertedXPath(assertedXPathImpl);
                    }
                    if (contentObj == null) {
                        String expandedValue;
                        if (items[c] instanceof XmlAnySimpleType && !(items[c] instanceof XmlQName)) {
                            String value = ((XmlAnySimpleType)items[c]).getStringValue();
                            expandedValue = PropertyExpander.expandProperties(context, value);
                            XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                        } else {
                            Node domNode = items[c].getDomNode();
                            switch (domNode.getNodeType()) {
                                case 1: {
                                    expandedValue = PropertyExpander.expandProperties(context, XmlUtils.getElementText((Element)domNode));
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                case 2: {
                                    expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                default: {
                                    expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                            }
                        }
                    } else {
                        this.compareValues(contentObj.xmlText(options), items[c].xmlText(options), items[c]);
                    }
                    break;
                }
                catch (Throwable e) {
                    if (c != items.length - 1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            String msg = "";
            if (e instanceof ComparisonFailure) {
                ComparisonFailure cf = (ComparisonFailure)e;
                String expected = cf.getExpected();
                String actual = cf.getActual();
                msg = "XPathContains comparison failed for path [" + this.path + "], expecting [" + expected + "], actual was [" + actual + "]";
            } else {
                msg = "XPathContains assertion failed for path [" + this.path + "] : " + e.getClass().getSimpleName() + ":" + e.getMessage();
            }
            throw new AssertionException(new AssertionError(msg));
        }
        return type + " matches content for [" + this.path + "]";
    }

    private void compareValues(String expandedContent, String expandedValue, XmlObject object) throws Exception {
        Diff diff = new Diff(expandedContent, expandedValue);
        AbstractXmlContainsAssertion.InternalDifferenceListener internalDifferenceListener = new AbstractXmlContainsAssertion.InternalDifferenceListener();
        diff.overrideDifferenceListener((DifferenceListener)internalDifferenceListener);
        if (!diff.identical()) {
            throw new Exception(diff.toString());
        }
        StringList nodesToRemove = internalDifferenceListener.getNodesToRemove();
        if (!nodesToRemove.isEmpty()) {
            for (String node : nodesToRemove) {
                XmlObject[] paths;
                if (node == null) continue;
                int ix = node.indexOf("\n/");
                if (ix != -1) {
                    node = node.substring(0, ix + 1) + "./" + node.substring(ix + 1);
                } else if (node.startsWith("/")) {
                    node = "/" + node;
                }
                if ((paths = object.selectPath(node)).length <= 0) continue;
                Node domNode = paths[0].getDomNode();
                if (domNode.getNodeType() == 2) {
                    ((Attr)domNode).getOwnerElement().removeAttributeNode((Attr)domNode);
                } else {
                    domNode.getParentNode().removeChild(domNode);
                }
                try {
                    object.set(object.copy());
                }
                catch (XmlValueDisconnectedException e) {
                    return;
                }
            }
        }
    }

    public String getHelpURL() {
        return "/functional-testing/validating-messages/validating-xml-messages.html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectFromCurrent() {
        XmlCursor cursor = null;
        try {
            String txt;
            String assertableContent = this.getAssertable().getAssertableContentAsXml();
            if (assertableContent == null || assertableContent.trim().length() == 0) {
                UISupport.showErrorMessage("Missing content to select from");
                return;
            }
            JTextArea pathArea = this.getPathArea();
            String string = txt = pathArea == null || !pathArea.isVisible() ? this.getPath() : pathArea.getSelectedText();
            if (txt == null) {
                txt = pathArea == null ? "" : pathArea.getText();
            }
            WsdlTestRunContext context = new WsdlTestRunContext(this.getAssertable().getTestStep());
            String expandedPath = PropertyExpander.expandProperties(context, txt.trim());
            JTextArea contentArea = this.getContentArea();
            if (contentArea != null && contentArea.isVisible()) {
                contentArea.setText("");
            }
            XmlObject xml = XmlUtils.createXmlObject(assertableContent);
            cursor = xml.newCursor();
            cursor.selectPath(expandedPath);
            if (!cursor.toNextSelection()) {
                UISupport.showErrorMessage("No match in current response");
            } else if (cursor.hasNextSelection()) {
                UISupport.showErrorMessage("More than one match in current response");
            } else {
                String stringValue = XmlUtils.getValueForMatch(cursor);
                if (contentArea != null && contentArea.isVisible()) {
                    contentArea.setText(stringValue);
                } else {
                    this.setExpectedContent(stringValue, false);
                }
            }
        }
        catch (Throwable e) {
            UISupport.showErrorMessage("Invalid XPath expression.");
            SoapUI.logError(e);
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    @Override
    protected String getQueryType() {
        return "XPath";
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("XPath Match", "XPath Match", XPathContainsAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Property Content";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return XPathContainsAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("XPath Match", "XPath Match", XPathContainsAssertion.DESCRIPTION);
        }

        @Override
        public boolean canAssert(TestPropertyHolder modelItem, String property) {
            if (!modelItem.getProperty(property).getSchemaType().isPrimitiveType()) {
                return true;
            }
            String content = modelItem.getPropertyValue(property);
            return XmlUtils.seemsToBeXml(content);
        }
    }
}

