/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.AbstractXmlContainsAssertion;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class AssertionConfigurationDialog {
    private static final Logger log = Logger.getLogger(AssertionConfigurationDialog.class);
    protected JDialog configurationDialog;
    private JCheckBox allowWildcardsCheckBox;
    private JCheckBox ignoreNamespaceDifferencesCheckBox;
    private JCheckBox ignoreCommentsCheckBox;
    protected JTextArea pathArea;
    protected JTextArea contentArea;
    protected AbstractXmlContainsAssertion assertion;
    protected boolean configureResult;

    public AssertionConfigurationDialog(AbstractXmlContainsAssertion assertion) {
        this.assertion = assertion;
    }

    public boolean configure() {
        if (this.configurationDialog == null) {
            this.buildConfigurationDialog();
        }
        this.initializeFieldsWithValuesFromAssertion();
        UISupport.showDialog(this.configurationDialog);
        return this.configureResult;
    }

    protected void initializeFieldsWithValuesFromAssertion() {
        this.pathArea.setText(this.assertion.getPath());
        this.contentArea.setText(this.assertion.getExpectedContent());
        this.allowWildcardsCheckBox.setSelected(this.assertion.isAllowWildcards());
        this.ignoreNamespaceDifferencesCheckBox.setSelected(this.assertion.isIgnoreNamespaceDifferences());
        this.ignoreCommentsCheckBox.setSelected(this.assertion.isIgnoreComments());
    }

    public String getHelpURL() {
        return "/functional-testing/validating-messages/validating-json-messages.html";
    }

    protected void buildConfigurationDialog() {
        this.configurationDialog = new JDialog(UISupport.getMainFrame());
        this.configurationDialog.setTitle(this.assertion.getConfigurationDialogTitle());
        this.configurationDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)UISupport.buildDescription(this.assertion.getPathAreaTitle(), this.assertion.getPathAreaDescription(), null), "North");
        JSplitPane splitPane = UISupport.createVerticalSplit();
        JPanel pathPanel = this.getPathAreaPanel();
        splitPane.setTopComponent(UISupport.addTitledBorder(pathPanel, this.assertion.getPathAreaBorderTitle()));
        this.contentArea = new JUndoableTextArea();
        this.contentArea.setToolTipText(this.assertion.getContentAreaToolTipText());
        JPanel matchPanel = new JPanel(new BorderLayout());
        JXToolBar contentToolbar = UISupport.createToolbar();
        this.assertion.addMatchEditorActions(contentToolbar);
        matchPanel.add((Component)contentToolbar, "North");
        matchPanel.add((Component)new JScrollPane(this.contentArea), "Center");
        splitPane.setBottomComponent(UISupport.addTitledBorder(matchPanel, this.assertion.getContentAreaBorderTitle()));
        splitPane.setDividerLocation(200);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        contentPanel.add((Component)splitPane, "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        ShowOnlineHelpAction showOnlineHelpAction = new ShowOnlineHelpAction(this.getHelpURL());
        builder.addFixed((JComponent)UISupport.createToolbarButton(showOnlineHelpAction));
        builder.addGlue();
        JButton okButton = new JButton(this.createOkAction());
        builder.addFixed((JComponent)okButton);
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new CancelAction()));
        builder.setBorder(BorderFactory.createEmptyBorder(1, 5, 5, 5));
        contentPanel.add((Component)builder.getPanel(), "South");
        this.configurationDialog.setContentPane(contentPanel);
        this.configurationDialog.setSize(800, 600);
        this.configurationDialog.setModal(true);
        UISupport.initDialogActions(this.configurationDialog, showOnlineHelpAction, okButton);
    }

    protected AbstractAction createOkAction() {
        return new OkAction();
    }

    protected JPanel getPathAreaPanel() {
        this.pathArea = new JUndoableTextArea();
        this.pathArea.setToolTipText(this.assertion.getPathAreaToolTipText());
        JPanel pathPanel = new JPanel(new BorderLayout());
        JXToolBar pathToolbar = UISupport.createToolbar();
        this.assertion.addPathEditorActions(pathToolbar);
        pathPanel.add((Component)pathToolbar, "North");
        pathPanel.add((Component)new JScrollPane(this.pathArea), "Center");
        return pathPanel;
    }

    void addDeclareNamespaceButton(JXToolBar toolbar) {
        if (this.assertion.canAssertXmlContent()) {
            toolbar.addFixed(new JButton(new DeclareNamespacesFromCurrentAction()));
        }
    }

    public JTextArea getPathArea() {
        return this.pathArea;
    }

    protected void addMatchEditorActions(JXToolBar toolbar) {
        toolbar.addFixed(new JButton(this.createSelectFromCurrentAction()));
        toolbar.addRelatedGap();
        toolbar.addFixed(new JButton(this.createTestPathAction()));
        this.allowWildcardsCheckBox = new JCheckBox("Allow Wildcards");
        Dimension dim = new Dimension(120, 20);
        this.allowWildcardsCheckBox.setSize(dim);
        this.allowWildcardsCheckBox.setPreferredSize(dim);
        this.allowWildcardsCheckBox.setOpaque(false);
        Dimension largerDim = new Dimension(170, 20);
        this.ignoreNamespaceDifferencesCheckBox = new JCheckBox("Ignore namespace prefixes");
        this.ignoreNamespaceDifferencesCheckBox.setSize(largerDim);
        this.ignoreNamespaceDifferencesCheckBox.setPreferredSize(largerDim);
        this.ignoreNamespaceDifferencesCheckBox.setOpaque(false);
        this.ignoreCommentsCheckBox = new JCheckBox("Ignore XML Comments");
        this.ignoreCommentsCheckBox.setSize(largerDim);
        this.ignoreCommentsCheckBox.setPreferredSize(largerDim);
        this.ignoreCommentsCheckBox.setOpaque(false);
        if (this.assertion.canAssertXmlContent()) {
            toolbar.addRelatedGap();
            toolbar.addFixed(this.allowWildcardsCheckBox);
            toolbar.addRelatedGap();
            toolbar.addFixed(this.ignoreNamespaceDifferencesCheckBox);
            toolbar.addRelatedGap();
            toolbar.addFixed(this.ignoreCommentsCheckBox);
        }
    }

    protected SelectFromCurrentAction createSelectFromCurrentAction() {
        return new SelectFromCurrentAction();
    }

    protected TestPathAction createTestPathAction() {
        return new TestPathAction();
    }

    public JTextArea getContentArea() {
        return this.contentArea;
    }

    public class SelectFromCurrentAction
    extends AbstractAction {
        public SelectFromCurrentAction() {
            super("Select from current");
            this.putValue("ShortDescription", "Selects the " + AssertionConfigurationDialog.this.assertion.getQueryType() + " expression from the current message into the Expected Content field");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AssertionConfigurationDialog.this.assertion.selectFromCurrent();
        }
    }

    public class TestPathAction
    extends AbstractAction {
        public TestPathAction() {
            super("Test");
            this.putValue("ShortDescription", "Tests the " + AssertionConfigurationDialog.this.assertion.getQueryType() + " expression for the current message against the Expected Content field");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String oldPath = AssertionConfigurationDialog.this.assertion.getPath();
            String oldContent = AssertionConfigurationDialog.this.assertion.getExpectedContent();
            boolean oldAllowWildcards = AssertionConfigurationDialog.this.assertion.isAllowWildcards();
            this.setAssertionParameters(AssertionConfigurationDialog.this.pathArea.getText().trim(), AssertionConfigurationDialog.this.contentArea.getText(), AssertionConfigurationDialog.this.allowWildcardsCheckBox.isSelected());
            AssertionConfigurationDialog.this.assertion.setIgnoreNamespaceDifferences(AssertionConfigurationDialog.this.ignoreNamespaceDifferencesCheckBox.isSelected());
            AssertionConfigurationDialog.this.assertion.setIgnoreComments(AssertionConfigurationDialog.this.ignoreCommentsCheckBox.isSelected());
            try {
                String assertableContent = AssertionConfigurationDialog.this.assertion.getAssertable().getAssertableContent();
                if ("XPath Match".equals(AssertionConfigurationDialog.this.assertion.getConfig().getType()) || !JsonUtil.seemsToBeJson(assertableContent)) {
                    assertableContent = AssertionConfigurationDialog.this.assertion.getAssertable().getAssertableContentAsXml();
                }
                if (assertableContent == null) {
                    UISupport.showErrorMessage("Missing content!!");
                    this.setAssertionParameters(oldPath, oldContent, oldAllowWildcards);
                    return;
                }
                String msg = AssertionConfigurationDialog.this.assertion.assertContent(assertableContent, new WsdlTestRunContext(AssertionConfigurationDialog.this.assertion.getAssertable().getTestStep()), "Response");
                UISupport.showInfoMessage(msg, "Success");
            }
            catch (AssertionException e) {
                UISupport.showErrorMessage(e.getMessage());
            }
            this.setAssertionParameters(oldPath, oldContent, oldAllowWildcards);
        }

        private void setAssertionParameters(String path, String content, boolean allowWildCards) {
            AssertionConfigurationDialog.this.assertion.setPath(path);
            AssertionConfigurationDialog.this.assertion.setExpectedContent(content);
            AssertionConfigurationDialog.this.assertion.setAllowWildcards(allowWildCards);
        }
    }

    public class DeclareNamespacesFromCurrentAction
    extends AbstractAction {
        public DeclareNamespacesFromCurrentAction() {
            super("Declare");
            this.putValue("ShortDescription", "Add namespace declaration from current message to " + AssertionConfigurationDialog.this.assertion.getQueryType() + " expression");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                String content = AssertionConfigurationDialog.this.assertion.getAssertable().getAssertableContentAsXml();
                if (content != null && content.trim().length() > 0) {
                    AssertionConfigurationDialog.this.pathArea.setText(XmlUtils.declareXPathNamespaces(content) + AssertionConfigurationDialog.this.pathArea.getText());
                } else if (UISupport.confirm("Declare namespaces from schema instead?", "Missing Response")) {
                    AssertionConfigurationDialog.this.pathArea.setText(XmlUtils.declareXPathNamespaces((WsdlInterface)AssertionConfigurationDialog.this.assertion.getAssertable().getInterface()) + AssertionConfigurationDialog.this.pathArea.getText());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AssertionConfigurationDialog.this.configureResult = false;
            AssertionConfigurationDialog.this.configurationDialog.setVisible(false);
        }
    }

    public class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AssertionConfigurationDialog.this.assertion.setPath(AssertionConfigurationDialog.this.pathArea.getText().trim());
            AssertionConfigurationDialog.this.assertion.setExpectedContent(AssertionConfigurationDialog.this.contentArea.getText());
            AssertionConfigurationDialog.this.assertion.setAllowWildcards(AssertionConfigurationDialog.this.allowWildcardsCheckBox.isSelected());
            AssertionConfigurationDialog.this.assertion.setIgnoreNamespaceDifferences(AssertionConfigurationDialog.this.ignoreNamespaceDifferencesCheckBox.isSelected());
            AssertionConfigurationDialog.this.assertion.setIgnoreComments(AssertionConfigurationDialog.this.ignoreCommentsCheckBox.isSelected());
            AssertionConfigurationDialog.this.assertion.setConfiguration(AssertionConfigurationDialog.this.assertion.createConfiguration());
            AssertionConfigurationDialog.this.configureResult = true;
            AssertionConfigurationDialog.this.configurationDialog.setVisible(false);
        }
    }
}

