/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.AssertionEntryConfig;
import com.eviware.soapui.config.GroupAssertionListConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.xmlbeans.XmlObject;

public abstract class WsdlMessageAssertion
extends AbstractModelItem
implements PropertyExpansionContainer,
TestAssertion {
    private TestAssertionConfig assertionConfig;
    private Assertable assertable;
    protected Assertable.AssertionStatus assertionStatus = Assertable.AssertionStatus.UNKNOWN;
    protected AssertionError[] assertionErrors;
    private ImageIcon validIcon;
    private ImageIcon failedIcon;
    private ImageIcon unknownIcon;
    private final boolean cloneable;
    private final boolean configurable;
    private final boolean allowMultiple;
    private final boolean requiresResponseContent;

    protected WsdlMessageAssertion(TestAssertionConfig assertionConfig, Assertable modelItem, boolean cloneable, boolean configurable, boolean multiple, boolean requiresResponseContent) {
        this.assertionConfig = assertionConfig;
        if (assertionConfig != null && !assertionConfig.isSetId()) {
            assertionConfig.setId(ModelSupport.generateModelItemID());
        }
        this.assertable = modelItem;
        this.cloneable = cloneable;
        this.configurable = configurable;
        this.allowMultiple = multiple;
        this.requiresResponseContent = requiresResponseContent;
        this.validIcon = UISupport.createImageIcon("/valid_assertion.gif");
        this.failedIcon = UISupport.createImageIcon("/failed_assertion.gif");
        this.unknownIcon = UISupport.createImageIcon("/unknown_assertion.png");
    }

    public XmlObject getConfiguration() {
        if (null == this.assertionConfig.getConfiguration()) {
            this.assertionConfig.addNewConfiguration();
        }
        return this.assertionConfig.getConfiguration();
    }

    public void setConfiguration(XmlObject configuration) {
        XmlObject oldConfig = this.assertionConfig.getConfiguration();
        this.assertionConfig.setConfiguration(configuration);
        this.notifyPropertyChanged(TestAssertion.CONFIGURATION_PROPERTY, oldConfig, configuration);
    }

    @Override
    public String getName() {
        return this.assertionConfig.isSetName() ? this.assertionConfig.getName() : TestAssertionRegistry.getInstance().getAssertionNameForType(this.assertionConfig.getType());
    }

    @Override
    public Assertable.AssertionStatus getStatus() {
        return this.isDisabled() ? Assertable.AssertionStatus.UNKNOWN : this.assertionStatus;
    }

    @Override
    public AssertionError[] getErrors() {
        return this.isDisabled() ? null : this.assertionErrors;
    }

    @Override
    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public Assertable.AssertionStatus assertResponse(MessageExchange messageExchange, SubmitContext context) {
        Assertable.AssertionStatus oldStatus = this.assertionStatus;
        AssertionError[] oldErrors = this.getErrors();
        ImageIcon oldIcon = this.getIcon();
        if (this.isDisabled()) {
            this.assertionStatus = Assertable.AssertionStatus.UNKNOWN;
            this.assertionErrors = null;
        } else if (messageExchange != null && !messageExchange.hasResponse() && this.requiresResponseContent) {
            this.assertionStatus = Assertable.AssertionStatus.FAILED;
            this.assertionErrors = new AssertionError[]{new AssertionError("null/empty response")};
        } else {
            try {
                this.internalAssertResponse(messageExchange, context);
                this.assertionStatus = Assertable.AssertionStatus.VALID;
                this.assertionErrors = null;
            }
            catch (AssertionException e) {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = e.getErrors();
            }
            catch (Throwable e) {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = new AssertionError[]{new AssertionError(e.getMessage())};
            }
        }
        this.notifyPropertyChanged(STATUS_PROPERTY, (Object)oldStatus, (Object)this.assertionStatus);
        this.notifyPropertyChanged(ERRORS_PROPERTY, oldErrors, this.assertionErrors);
        this.notifyPropertyChanged(ICON_PROPERTY, oldIcon, this.getIcon());
        return this.assertionStatus;
    }

    protected abstract String internalAssertResponse(MessageExchange var1, SubmitContext var2) throws AssertionException;

    public Assertable.AssertionStatus assertRequest(MessageExchange messageExchange, SubmitContext context) {
        Assertable.AssertionStatus oldStatus = this.assertionStatus;
        ImageIcon oldIcon = this.getIcon();
        if (!messageExchange.hasRequest(true)) {
            this.assertionStatus = Assertable.AssertionStatus.FAILED;
            this.assertionErrors = new AssertionError[]{new AssertionError("null/empty request")};
        } else {
            try {
                this.internalAssertRequest(messageExchange, context);
                this.assertionStatus = Assertable.AssertionStatus.VALID;
                this.assertionErrors = null;
            }
            catch (AssertionException e) {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = e.getErrors();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = new AssertionError[]{new AssertionError(e.getMessage())};
            }
        }
        this.notifyPropertyChanged(STATUS_PROPERTY, (Object)oldStatus, (Object)this.assertionStatus);
        this.notifyPropertyChanged(ICON_PROPERTY, oldIcon, this.getIcon());
        return this.assertionStatus;
    }

    public Assertable.AssertionStatus assertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) {
        Assertable.AssertionStatus oldStatus = this.assertionStatus;
        ImageIcon oldIcon = this.getIcon();
        if (!propertyName.equals("Group") && !source.hasProperty(propertyName)) {
            this.assertionStatus = Assertable.AssertionStatus.FAILED;
            this.assertionErrors = new AssertionError[]{new AssertionError("property: '" + propertyName + "' does not exist")};
        } else {
            try {
                this.internalAssertProperty(source, propertyName, messageExchange, context);
                this.assertionStatus = Assertable.AssertionStatus.VALID;
                this.assertionErrors = null;
            }
            catch (AssertionException e) {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = e.getErrors();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = new AssertionError[]{new AssertionError(e.getMessage())};
            }
        }
        this.notifyPropertyChanged(STATUS_PROPERTY, (Object)oldStatus, (Object)this.assertionStatus);
        this.notifyPropertyChanged(ICON_PROPERTY, oldIcon, this.getIcon());
        return this.assertionStatus;
    }

    protected abstract String internalAssertRequest(MessageExchange var1, SubmitContext var2) throws AssertionException;

    protected abstract String internalAssertProperty(TestPropertyHolder var1, String var2, MessageExchange var3, SubmitContext var4) throws AssertionException;

    @Override
    public boolean isConfigurable() {
        return this.configurable;
    }

    @Override
    public boolean isClonable() {
        return this.cloneable;
    }

    @Override
    public boolean configure() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.getConfig().getDescription();
    }

    @Override
    public ImageIcon getIcon() {
        switch (this.getStatus()) {
            case FAILED: {
                return this.failedIcon;
            }
            case UNKNOWN: {
                return this.unknownIcon;
            }
            case VALID: {
                return this.validIcon;
            }
        }
        return null;
    }

    public void updateConfig(TestAssertionConfig config) {
        this.assertionConfig = config;
    }

    public TestAssertionConfig getConfig() {
        return this.assertionConfig;
    }

    @Override
    public Settings getSettings() {
        return this.assertable.getModelItem().getSettings();
    }

    public void release() {
    }

    @Override
    public Assertable getAssertable() {
        return this.assertable;
    }

    public void setAssertable(Assertable assertable) {
        this.assertable = assertable;
    }

    @Override
    public String getId() {
        if (!this.assertionConfig.isSetId()) {
            this.assertionConfig.setId(ModelSupport.generateModelItemID());
        }
        return this.assertionConfig.getId();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        return null;
    }

    public void setName(String name) {
        String oldLabel = this.getLabel();
        String old = this.getName();
        this.assertionConfig.setName(name);
        this.notifyPropertyChanged(NAME_PROPERTY, old, name);
        String label = this.getLabel();
        if (!oldLabel.equals(label)) {
            this.notifyPropertyChanged(LABEL_PROPERTY, oldLabel, label);
        }
    }

    @Override
    public String getLabel() {
        String name = this.getName();
        if (this.isDisabled()) {
            return name + " (disabled)";
        }
        return name;
    }

    @Override
    public boolean isDisabled() {
        return this.getConfig().getDisabled();
    }

    public void setDisabled(boolean disabled) {
        String oldLabel = this.getLabel();
        boolean oldDisabled = this.isDisabled();
        if (oldDisabled == disabled) {
            return;
        }
        if (disabled) {
            this.getConfig().setDisabled(disabled);
        } else if (this.getConfig().isSetDisabled()) {
            this.getConfig().unsetDisabled();
        }
        String label = this.getLabel();
        if (!oldLabel.equals(label)) {
            this.notifyPropertyChanged(LABEL_PROPERTY, oldLabel, label);
        }
        this.notifyPropertyChanged(DISABLED_PROPERTY, oldDisabled, disabled);
    }

    @Override
    public ModelItem getParent() {
        return this.assertable.getModelItem();
    }

    public boolean isValid() {
        return this.getStatus() == Assertable.AssertionStatus.VALID;
    }

    public boolean isFailed() {
        return this.getStatus() == Assertable.AssertionStatus.FAILED;
    }

    @Override
    public void prepare(TestCaseRunner testRunner, TestCaseRunContext testRunContext) throws Exception {
        this.assertionStatus = Assertable.AssertionStatus.UNKNOWN;
    }

    @Override
    public int getIndexOfAssertion(TestAssertion assertion) {
        if (this.getConfig() instanceof GroupAssertionListConfig) {
            List<AssertionEntryConfig> assertionEntryConfigList = ((GroupAssertionListConfig)((Object)this.getConfig())).getAssertionsList();
            return assertionEntryConfigList.indexOf(((WsdlMessageAssertion)assertion).getConfig());
        }
        return -1;
    }

    public void resolve(ResolveContext<?> context) {
    }
}

