/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.support.JsonUtil;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;

public enum PathLanguage {
    XPATH("XPath"),
    XQUERY("XQuery"),
    JSONPATH("JSONPath");

    private String displayName;

    public static PathLanguage forContent(String content) {
        if (content != null) {
            if (JsonUtil.seemsToBeJson(content)) {
                return JSONPATH;
            }
            if (XmlUtils.seemsToBeXml(content)) {
                return XPATH;
            }
        }
        return null;
    }

    public static PathLanguage fromDisplayName(String displayName) {
        if (!StringUtils.hasContent(displayName)) {
            return null;
        }
        for (PathLanguage pathLanguage : PathLanguage.values()) {
            if (!pathLanguage.displayName.toLowerCase().equals(displayName.toLowerCase())) continue;
            return pathLanguage;
        }
        return null;
    }

    private PathLanguage(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return this.displayName;
    }
}

