/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.swing.SwingWorker;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class UrlWsdlLoader
extends WsdlLoader {
    private HttpContext state;
    protected HttpGet getMethod;
    private boolean aborted;
    protected Map<String, byte[]> urlCache = new HashMap<String, byte[]>();
    protected boolean finished;
    private boolean useWorker;
    private ModelItem contextModelItem;
    private HttpResponse httpResponse;
    private static Map<AuthScope, Credentials> cache = new HashMap<AuthScope, Credentials>();

    public UrlWsdlLoader(String url) {
        this(url, null);
    }

    public UrlWsdlLoader(String url, ModelItem contextModelItem) {
        super(url);
        this.contextModelItem = contextModelItem;
        this.state = new BasicHttpContext();
    }

    public boolean isUseWorker() {
        return this.useWorker;
    }

    public void setUseWorker(boolean useWorker) {
        this.useWorker = useWorker;
    }

    public InputStream load() throws Exception {
        return this.load(this.getBaseURI());
    }

    @Override
    public synchronized InputStream load(String url) throws Exception {
        if (!PathUtils.isHttpPath(url)) {
            try {
                File file = new File(url.replace('/', File.separatorChar));
                if (file.exists()) {
                    url = file.toURI().toURL().toString();
                }
            }
            catch (Exception file) {
                // empty catch block
            }
        }
        if (this.urlCache.containsKey(url)) {
            this.setNewBaseURI(url);
            return new ByteArrayInputStream(this.urlCache.get(url));
        }
        if (url.startsWith("file:")) {
            return this.handleFile(url);
        }
        log.debug((Object)("Getting wsdl component from [" + url + "]"));
        this.createGetMethod(url);
        if (this.aborted) {
            return null;
        }
        LoaderWorker worker = new LoaderWorker();
        if (this.useWorker) {
            worker.start();
        } else {
            worker.construct();
        }
        while (!this.aborted && !this.finished) {
            Thread.sleep(200L);
        }
        int counter = 0;
        byte[] content = null;
        if (this.httpResponse != null && this.httpResponse.getEntity() != null) {
            content = EntityUtils.toByteArray((HttpEntity)new BufferedHttpEntity(this.httpResponse.getEntity()));
        }
        while (!this.aborted && content == null && counter < 10) {
            Thread.sleep(200L);
            ++counter;
        }
        if (this.aborted) {
            throw new Exception("Load of url [" + url + "] was aborted");
        }
        if (content != null) {
            String compressionAlg = HttpClientSupport.getResponseCompressionType(this.httpResponse);
            if (compressionAlg != null) {
                content = CompressionSupport.decompress(compressionAlg, content);
            }
            this.urlCache.put(url, content);
            String newUrl = this.getMethod.getURI().toString();
            if (!url.equals(newUrl)) {
                log.info((Object)("BaseURI was redirected to [" + newUrl + "]"));
            }
            this.setNewBaseURI(newUrl);
            this.urlCache.put(newUrl, content);
            return new ByteArrayInputStream(content);
        }
        throw new Exception("Failed to load url; " + url + ", " + (this.httpResponse != null ? this.httpResponse.getStatusLine().getStatusCode() : 0) + " - " + (this.httpResponse != null ? this.httpResponse.getStatusLine().getReasonPhrase() : ""));
    }

    protected InputStream handleFile(String url) throws Exception {
        this.setNewBaseURI(url);
        return new URL(url).openStream();
    }

    protected void createGetMethod(String url) {
        int userInfoIndex;
        URI uri = URI.create(url);
        String authority = uri.getAuthority();
        if (uri.getUserInfo() == null && authority != null && (userInfoIndex = authority.lastIndexOf("@")) != -1) {
            String userInfo = authority.substring(0, userInfoIndex);
            String encodedUserInfo = HttpUtils.urlEncodeWithUtf8(this.getUsername()) + ":" + HttpUtils.urlEncodeWithUtf8(this.getPassword());
            uri = URI.create(url.replace(userInfo, encodedUserInfo));
        }
        this.getMethod = new HttpGet(uri);
        this.getMethod.getParams().setParameter("http.protocol.handle-redirects", (Object)true);
        this.state.setAttribute("http.auth.credentials-provider", (Object)new WsdlCredentialsProvider());
        if (SoapUI.getSettings().getBoolean(HttpSettings.AUTHENTICATE_PREEMPTIVELY) && !StringUtils.isNullOrEmpty(this.getUsername()) && !StringUtils.isNullOrEmpty(this.getPassword())) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.getUsername(), this.getPassword());
            this.getMethod.addHeader(BasicScheme.authenticate((Credentials)creds, (String)"utf-8", (boolean)false));
        }
    }

    @Override
    public boolean abort() {
        if (this.getMethod != null) {
            this.getMethod.abort();
        }
        this.aborted = true;
        return true;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    public void close() {
    }

    public final class WsdlCredentialsProvider
    implements CredentialsProvider {
        private XFormDialog basicDialog;
        private XFormDialog ntDialog;

        public Credentials getCredentials(AuthScope authScope) {
            if (authScope == null) {
                throw new IllegalArgumentException("Authentication scope may not be null");
            }
            String pw = UrlWsdlLoader.this.getPassword();
            if (pw == null) {
                pw = "";
            }
            if ("NTLM".equalsIgnoreCase(authScope.getScheme()) || "negotiate".equalsIgnoreCase(authScope.getScheme())) {
                String workstation = "";
                try {
                    workstation = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                if (UrlWsdlLoader.this.hasCredentials()) {
                    WsdlLoader.log.info((Object)"Returning url credentials");
                    return new NTCredentials(UrlWsdlLoader.this.getUsername(), pw, workstation, null);
                }
                WsdlLoader.log.info((Object)(authScope.getHost() + ":" + authScope.getPort() + " requires Windows authentication"));
                if (this.ntDialog == null) {
                    this.buildNtDialog();
                }
                StringToStringMap values = new StringToStringMap();
                values.put("Info", "Authentication required for [" + authScope.getHost() + ":" + authScope.getPort() + "]");
                this.ntDialog.setValues(values);
                if (this.ntDialog.show()) {
                    values = this.ntDialog.getValues();
                    NTCredentials credentials = new NTCredentials((String)values.get("Username"), (String)values.get("Password"), workstation, (String)values.get("Domain"));
                    cache.put(authScope, credentials);
                    return credentials;
                }
            } else if ("Basic".equalsIgnoreCase(authScope.getScheme()) || "Digest".equalsIgnoreCase(authScope.getScheme())) {
                if (UrlWsdlLoader.this.hasCredentials()) {
                    WsdlLoader.log.info((Object)"Returning url credentials");
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(UrlWsdlLoader.this.getUsername(), pw);
                    cache.put(authScope, credentials);
                    return credentials;
                }
                WsdlLoader.log.info((Object)(authScope.getHost() + ":" + authScope.getPort() + " requires authentication with the realm '" + authScope.getRealm() + "'"));
                ShowDialog showDialog = new ShowDialog();
                showDialog.values.put("Info", "Authentication required for [" + authScope.getHost() + ":" + authScope.getPort() + "]");
                UISupport.getUIUtils().runInUIThreadIfSWT(showDialog);
                if (showDialog.result) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials((String)showDialog.values.get("Username"), (String)showDialog.values.get("Password"));
                    cache.put(authScope, credentials);
                    return credentials;
                }
            }
            return null;
        }

        private void buildBasicDialog() {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Basic Authentication");
            XForm mainForm = builder.createForm("Basic");
            mainForm.addLabel("Info", "");
            mainForm.addTextField("Username", "Username for authentication", XForm.FieldType.TEXT);
            mainForm.addTextField("Password", "Password for authentication", XForm.FieldType.PASSWORD);
            this.basicDialog = builder.buildDialog(builder.buildOkCancelActions(), "Specify Basic Authentication Credentials", UISupport.OPTIONS_ICON);
        }

        private void buildNtDialog() {
            XFormDialogBuilder builder = XFormFactory.createDialogBuilder("NT Authentication");
            XForm mainForm = builder.createForm("Basic");
            mainForm.addLabel("Info", "");
            mainForm.addTextField("Username", "Username for authentication", XForm.FieldType.TEXT);
            mainForm.addTextField("Password", "Password for authentication", XForm.FieldType.PASSWORD);
            mainForm.addTextField("Domain", "NT Domain for authentication", XForm.FieldType.TEXT);
            this.ntDialog = builder.buildDialog(builder.buildOkCancelActions(), "Specify NT Authentication Credentials", UISupport.OPTIONS_ICON);
        }

        public void clear() {
            cache.clear();
        }

        public void setCredentials(AuthScope arg0, Credentials arg1) {
        }

        private class ShowDialog
        implements Runnable {
            StringToStringMap values = new StringToStringMap();
            boolean result;

            private ShowDialog() {
            }

            @Override
            public void run() {
                if (WsdlCredentialsProvider.this.basicDialog == null) {
                    WsdlCredentialsProvider.this.buildBasicDialog();
                }
                WsdlCredentialsProvider.this.basicDialog.setValues(this.values);
                this.result = WsdlCredentialsProvider.this.basicDialog.show();
                if (this.result) {
                    this.values = WsdlCredentialsProvider.this.basicDialog.getValues();
                }
            }
        }
    }

    public final class LoaderWorker
    extends SwingWorker {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct() {
            HttpClientSupport.SoapUIHttpClient httpClient = HttpClientSupport.getHttpClient();
            try {
                Settings soapuiSettings = SoapUI.getSettings();
                HttpClientSupport.applyHttpSettings((HttpRequest)UrlWsdlLoader.this.getMethod, soapuiSettings);
                UrlWsdlLoader.this.httpResponse = httpClient.execute((HttpUriRequest)UrlWsdlLoader.this.getMethod, UrlWsdlLoader.this.state);
            }
            catch (Exception e) {
                Exception exception = e;
                return exception;
            }
            finally {
                UrlWsdlLoader.this.finished = true;
            }
            return null;
        }
    }
}

