/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.http.HttpCredentialsProvider;
import com.eviware.soapui.settings.ProxySettings;
import java.net.ProxySelector;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class OverridableProxySelectorRoutePlanner
extends ProxySelectorRoutePlanner {
    private static final String FORCE_DIRECT_CONNECTION = "FORCE_DIRECT_CONNECTION";

    static void setForceDirectConnection(HttpParams params) {
        params.setBooleanParameter(FORCE_DIRECT_CONNECTION, true);
    }

    public OverridableProxySelectorRoutePlanner(SchemeRegistry registry, ProxySelector proxySelector) {
        super(registry, proxySelector);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        boolean autoProxy;
        CredentialsProvider credentialsProvider;
        if (request.getParams().getBooleanParameter(FORCE_DIRECT_CONNECTION, false)) {
            return null;
        }
        HttpHost proxy = ConnRouteParams.getDefaultProxy((HttpParams)request.getParams());
        if (proxy == null) {
            proxy = super.determineProxy(target, request, context);
        }
        if (proxy != null && context != null && (credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider")) != null && credentialsProvider instanceof HttpCredentialsProvider && (autoProxy = SoapUI.getSettings().getBoolean(ProxySettings.AUTO_PROXY))) {
            HttpCredentialsProvider httpCredentialsProvider = (HttpCredentialsProvider)credentialsProvider;
            httpCredentialsProvider.setProxy(proxy.getHostName(), String.valueOf(proxy.getPort()));
        }
        return proxy;
    }
}

