/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.jms;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.RequestTransport;
import com.eviware.soapui.impl.wsdl.submit.RequestTransportRegistry;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestPublishReceiveTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestPublishSubscribeTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestPublishTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestReceiveTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestSendReceiveTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestSendSubscribeTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestSendTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.HermesJmsRequestSubscribeTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSConnectionHolder;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSEndpoint;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSHeader;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.HermesUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.JMSUtils;
import com.eviware.soapui.impl.wsdl.support.RequestFileAttachment;
import com.eviware.soapui.impl.wsdl.support.jms.header.JMSHeaderConfig;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequest;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import hermes.Hermes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.NotImplementedException;

public class HermesJmsRequestTransport
implements RequestTransport {
    public static final String IS_JMS_MESSAGE_RECEIVED = "JMS_MESSAGE_RECEIVE";
    public static final String JMS_MESSAGE_SEND = "JMS_MESSAGE_SEND";
    public static final String JMS_RESPONSE = "JMS_RESPONSE";
    public static final String JMS_ERROR = "JMS_ERROR";
    public static final String JMS_RECEIVE_TIMEOUT = "JMS_RECEIVE_TIMEOUT";
    protected String username;
    protected String password;
    protected JMSEndpoint jmsEndpoint;
    protected String durableSubscriptionName;
    protected String clientID;
    protected String messageSelector;
    protected boolean sendAsBytesMessage;
    protected boolean addSoapAction;
    protected Hermes hermes;
    protected static List<RequestFilter> filters = new ArrayList<RequestFilter>();

    @Override
    public Response sendRequest(SubmitContext submitContext, Request request) throws Exception {
        long timeStarted = Calendar.getInstance().getTimeInMillis();
        submitContext.setProperty(JMS_RECEIVE_TIMEOUT, this.getTimeout(submitContext, request));
        return this.resolveType(submitContext, request).execute(submitContext, request, timeStarted);
    }

    protected void init(SubmitContext submitContext, Request request) throws NamingException {
        this.jmsEndpoint = new JMSEndpoint(request, submitContext);
        this.hermes = this.getHermes(this.jmsEndpoint.getSessionName(), request);
        this.username = submitContext.expand(request.getUsername());
        this.password = submitContext.expand(request.getPassword());
        JMSHeaderConfig jmsConfig = ((AbstractHttpRequest)request).getJMSHeaderConfig();
        this.durableSubscriptionName = submitContext.expand(jmsConfig.getDurableSubscriptionName());
        this.clientID = submitContext.expand(jmsConfig.getClientID());
        this.messageSelector = jmsConfig.getMessageSelector();
        this.sendAsBytesMessage = jmsConfig.getSendAsBytesMessage();
        this.addSoapAction = jmsConfig.getSoapActionAdd();
        submitContext.setProperty(IS_JMS_MESSAGE_RECEIVED, false);
    }

    protected Response execute(SubmitContext submitContext, Request request, long timeStarted) throws Exception {
        throw new NotImplementedException();
    }

    private HermesJmsRequestTransport resolveType(SubmitContext submitContext, Request request) throws RequestTransportRegistry.CannotResolveJmsTypeException, RequestTransportRegistry.MissingTransportException {
        String endpoint = PropertyExpander.expandProperties(submitContext, request.getEndpoint());
        int ix = endpoint.indexOf("://");
        if (ix == -1) {
            throw new RequestTransportRegistry.MissingTransportException("Missing protocol in endpoint [" + endpoint + "]");
        }
        String[] params = JMSEndpoint.extractEndpointParameters(request, submitContext);
        if (params.length == 2) {
            String destinationName = PropertyExpander.expandProperties(submitContext, params[1]);
            if (destinationName.startsWith("queue_")) {
                return new HermesJmsRequestSendTransport();
            }
            if (destinationName.startsWith("topic_")) {
                return new HermesJmsRequestPublishTransport();
            }
            HermesJmsRequestTransport.cannotResolve();
        } else if (params.length == 3 && PropertyExpander.expandProperties(submitContext, params[1]).equals("-")) {
            String destinationName = PropertyExpander.expandProperties(submitContext, params[2]);
            if (destinationName.startsWith("queue_")) {
                return new HermesJmsRequestReceiveTransport();
            }
            if (destinationName.startsWith("topic_")) {
                return new HermesJmsRequestSubscribeTransport();
            }
            HermesJmsRequestTransport.cannotResolve();
        } else if (params.length == 3) {
            String destinationSendName = PropertyExpander.expandProperties(submitContext, params[1]);
            String destinationReceiveName = PropertyExpander.expandProperties(submitContext, params[2]);
            if (destinationSendName.startsWith("queue_") && destinationReceiveName.startsWith("queue_")) {
                return new HermesJmsRequestSendReceiveTransport();
            }
            if (destinationSendName.startsWith("queue_") && destinationReceiveName.startsWith("topic_")) {
                return new HermesJmsRequestSendSubscribeTransport();
            }
            if (destinationSendName.startsWith("topic_") && destinationReceiveName.startsWith("topic_")) {
                return new HermesJmsRequestPublishSubscribeTransport();
            }
            if (destinationSendName.startsWith("topic_") && destinationReceiveName.startsWith("queue_")) {
                return new HermesJmsRequestPublishReceiveTransport();
            }
            HermesJmsRequestTransport.cannotResolve();
        } else {
            HermesJmsRequestTransport.cannotResolve();
        }
        return null;
    }

    private static void cannotResolve() throws RequestTransportRegistry.CannotResolveJmsTypeException {
        throw new RequestTransportRegistry.CannotResolveJmsTypeException("\nBad jms alias! \nFor JMS please use this endpont pattern:\nfor sending 'jms://sessionName::queue_myqueuename' \nfor receive  'jms://sessionName::-::queue_myqueuename'\nfor send-receive 'jms://sessionName::queue_myqueuename1::queue_myqueuename2'");
    }

    protected Hermes getHermes(String sessionName, Request request) throws NamingException {
        WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(request);
        return HermesUtils.getHermes(project, sessionName);
    }

    protected long getTimeout(SubmitContext submitContext, Request request) {
        String timeout = PropertyExpander.expandProperties(submitContext, request.getTimeout());
        long to = 0L;
        try {
            to = Long.parseLong(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return to;
    }

    protected JMSHeader createJMSHeader(SubmitContext submitContext, Request request, Hermes hermes, Message message, Destination replyToDestination) {
        JMSHeader jmsHeader = new JMSHeader();
        jmsHeader.setMessageHeaders(message, request, hermes, submitContext);
        JMSHeader.setMessageProperties(message, request, hermes, submitContext);
        try {
            if (message.getJMSReplyTo() == null) {
                message.setJMSReplyTo(replyToDestination);
            }
            if (this.addSoapAction) {
                message.setStringProperty("SOAPJMS_soapAction", request.getOperation().getName());
                if (request.getOperation() instanceof WsdlOperation) {
                    message.setStringProperty("SOAPAction", ((WsdlOperation)request.getOperation()).getAction());
                } else {
                    message.setStringProperty("SOAPAction", request.getOperation().getName());
                }
            }
        }
        catch (JMSException e) {
            SoapUI.logError(e);
        }
        return jmsHeader;
    }

    protected void closeSessionAndConnection(Connection connection, Session session) throws JMSException {
        if (session != null) {
            session.close();
        }
        if (connection != null) {
            connection.close();
        }
    }

    protected Response errorResponse(SubmitContext submitContext, Request request, long timeStarted, JMSException jmse) {
        SoapUI.logError(jmse);
        submitContext.setProperty(JMS_ERROR, (Object)jmse);
        JMSResponse response = new JMSResponse("", null, null, request, timeStarted);
        submitContext.setProperty(JMS_RESPONSE, response);
        return response;
    }

    protected Message messageSend(SubmitContext submitContext, Request request, Session session, Hermes hermes, Queue queueSend, Destination replyToDestination) throws JMSException {
        MessageProducer messageProducer = session.createProducer((Destination)queueSend);
        Message messageSend = this.createMessage(submitContext, request, session);
        return this.send(submitContext, request, hermes, messageProducer, messageSend, replyToDestination);
    }

    protected Message messagePublish(SubmitContext submitContext, Request request, Session topicSession, Hermes hermes, Topic topicPublish, Destination replyToDestination) throws JMSException {
        MessageProducer topicPublisher = topicSession.createProducer((Destination)topicPublish);
        Message messagePublish = this.createMessage(submitContext, request, topicSession);
        return this.send(submitContext, request, hermes, topicPublisher, messagePublish, replyToDestination);
    }

    private Message send(SubmitContext submitContext, Request request, Hermes hermes, MessageProducer messageProducer, Message message, Destination replyToDestination) throws JMSException {
        JMSHeader jmsHeader = this.createJMSHeader(submitContext, request, hermes, message, replyToDestination);
        messageProducer.send(message, message.getJMSDeliveryMode(), message.getJMSPriority(), jmsHeader.getTimeTolive());
        submitContext.setProperty(JMS_MESSAGE_SEND, message);
        return message;
    }

    protected Response makeResponse(SubmitContext submitContext, Request request, long timeStarted, Message messageSend, MessageConsumer messageConsumer) throws JMSException {
        long timeout = this.getTimeout(submitContext, request);
        Message messageReceive = messageConsumer.receive(timeout);
        if (messageReceive != null) {
            JMSResponse response = this.resolveMessage(request, timeStarted, messageSend, messageReceive);
            submitContext.setProperty(IS_JMS_MESSAGE_RECEIVED, true);
            submitContext.setProperty(JMS_RESPONSE, response);
            return response;
        }
        return new JMSResponse("", null, null, request, timeStarted);
    }

    private JMSResponse resolveMessage(Request request, long timeStarted, Message messageSend, Message messageReceive) throws JMSException {
        if (messageReceive instanceof TextMessage) {
            TextMessage textMessageReceive = (TextMessage)messageReceive;
            return new JMSResponse(textMessageReceive.getText(), messageSend, (Message)textMessageReceive, request, timeStarted);
        }
        if (messageReceive instanceof MapMessage) {
            MapMessage mapMessageReceive = (MapMessage)messageReceive;
            return new JMSResponse(JMSUtils.extractMapMessagePayloadToXML(mapMessageReceive), messageSend, (Message)mapMessageReceive, request, timeStarted);
        }
        if (messageReceive instanceof BytesMessage) {
            BytesMessage bytesMessageReceive = (BytesMessage)messageReceive;
            String bytesMessageAsString = new String(JMSUtils.extractByteArrayFromMessage(bytesMessageReceive));
            if (XmlUtils.seemsToBeXml(bytesMessageAsString)) {
                return new JMSResponse(bytesMessageAsString, messageSend, (Message)bytesMessageReceive, request, timeStarted);
            }
            JMSResponse jmsResponse = new JMSResponse("", messageSend, (Message)bytesMessageReceive, request, timeStarted);
            this.addAttachment(request, bytesMessageReceive, jmsResponse);
            return jmsResponse;
        }
        return null;
    }

    protected Response makeEmptyResponse(SubmitContext submitContext, Request request, long timeStarted, Message messageSend) {
        JMSResponse response = new JMSResponse("", messageSend, null, request, timeStarted);
        submitContext.setProperty(JMS_RESPONSE, response);
        return response;
    }

    private Message createMessage(SubmitContext submitContext, Request request, Session session) throws JMSException {
        if (request instanceof WsdlRequest || request instanceof HttpTestRequest || request instanceof RestRequest) {
            if (this.hasAttachment(request)) {
                if (this.isTextAttachment(request) && !this.sendAsBytesMessage) {
                    return this.createTextMessageFromAttachment(submitContext, request, session);
                }
                return this.createBytesMessage(request, session);
            }
            String requestContent = this.applyFilters(submitContext, request);
            if (this.sendAsBytesMessage) {
                return this.createBytesMessageFromText(submitContext, requestContent, session);
            }
            return this.createTextMessage(submitContext, requestContent, session);
        }
        return null;
    }

    private String applyFilters(SubmitContext submitContext, Request request) {
        submitContext.setProperty("requestContent", request.getRequestContent());
        submitContext.setProperty("wsdlRequest", request);
        for (RequestFilter filter : filters) {
            filter.filterRequest(submitContext, request);
        }
        String requestContent = (String)submitContext.getProperty("requestContent");
        return requestContent;
    }

    private Message createBytesMessageFromText(SubmitContext submitContext, String requestContent, Session session) throws JMSException {
        BytesMessage bytesMessage = session.createBytesMessage();
        bytesMessage.writeBytes(requestContent.getBytes());
        return bytesMessage;
    }

    private Message createTextMessageFromAttachment(SubmitContext submitContext, Request request, Session session) {
        try {
            String content = this.convertStreamToString(request.getAttachments()[0].getInputStream());
            TextMessage textMessageSend = session.createTextMessage();
            String messageBody = PropertyExpander.expandProperties(submitContext, content);
            textMessageSend.setText(messageBody);
            return textMessageSend;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    private boolean hasAttachment(Request request) {
        return request.getAttachments().length > 0;
    }

    private Message createTextMessage(SubmitContext submitContext, String requestContent, Session session) throws JMSException {
        TextMessage textMessageSend = session.createTextMessage();
        textMessageSend.setText(requestContent);
        return textMessageSend;
    }

    private boolean isTextAttachment(Request request) {
        return request.getAttachments().length > 0 && (request.getAttachments()[0].getContentType().contains("/text") || request.getAttachments()[0].getContentType().contains("/xml") || request.getAttachments()[0].getContentType().contains("text/plain"));
    }

    private Message createBytesMessage(Request request, Session session) {
        try {
            InputStream in = request.getAttachments()[0].getInputStream();
            int buff = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((buff = in.read()) != -1) {
                baos.write(buff);
            }
            BytesMessage bytesMessage = session.createBytesMessage();
            bytesMessage.writeBytes(baos.toByteArray());
            return bytesMessage;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    private void addAttachment(Request request, BytesMessage bytesMessageReceive, JMSResponse jmsResponse) throws JMSException {
        try {
            byte[] buff = new byte[1];
            File temp = File.createTempFile("bytesmessage", ".tmp");
            FileOutputStream out = new FileOutputStream(temp);
            bytesMessageReceive.reset();
            while (bytesMessageReceive.readBytes(buff) != -1) {
                ((OutputStream)out).write(buff);
            }
            ((OutputStream)out).close();
            Attachment[] attachments = new Attachment[]{new RequestFileAttachment(temp, false, (AbstractHttpRequest)request)};
            jmsResponse.setAttachments(attachments);
        }
        catch (IOException e) {
            SoapUI.logError(e);
        }
    }

    protected TopicSubscriber createDurableSubscription(SubmitContext submitContext, Session topicSession, JMSConnectionHolder jmsConnectionHolder) throws JMSException, NamingException {
        Topic topicSubscribe = jmsConnectionHolder.getTopic(jmsConnectionHolder.getJmsEndpoint().getReceive());
        TopicSubscriber topicDurableSubsriber = topicSession.createDurableSubscriber(topicSubscribe, StringUtils.hasContent(this.durableSubscriptionName) ? this.durableSubscriptionName : "durableSubscription" + jmsConnectionHolder.getJmsEndpoint().getReceive(), submitContext.expand(this.messageSelector), false);
        return topicDurableSubsriber;
    }

    @Override
    public void abortRequest(SubmitContext submitContext) {
    }

    @Override
    public void addRequestFilter(RequestFilter filter) {
        filters.add(filter);
    }

    @Override
    public void removeRequestFilter(RequestFilter filter) {
        filters.remove(filter);
    }

    @Override
    public void insertRequestFilter(RequestFilter filter, RequestFilter refFilter) {
        int ix = filters.indexOf(refFilter);
        if (ix == -1) {
            filters.add(filter);
        } else {
            filters.add(ix, filter);
        }
    }

    public static class UnresolvedJMSEndpointException
    extends Exception {
        public UnresolvedJMSEndpointException(String msg) {
            super(msg);
        }
    }
}

