/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;

public class WsdlRequestMimeMessageRequestEntity
extends AbstractHttpEntity {
    private final MimeMessage message;
    private final boolean isXOP;
    private final WsdlRequest wsdlRequest;

    public WsdlRequestMimeMessageRequestEntity(MimeMessage message, boolean isXOP, WsdlRequest wsdlRequest) {
        this.message = message;
        this.isXOP = isXOP;
        this.wsdlRequest = wsdlRequest;
    }

    public long getContentLength() {
        try {
            DummyOutputStream out = new DummyOutputStream();
            this.writeTo(out);
            return out.getSize();
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return -1L;
        }
    }

    public Header getContentType() {
        try {
            SoapVersion soapVersion = this.wsdlRequest.getOperation().getInterface().getSoapVersion();
            if (this.isXOP) {
                String header = this.message.getHeader("Content-Type")[0];
                return new BasicHeader("Content-Type", AttachmentUtils.buildMTOMContentType(header, this.wsdlRequest.getAction(), soapVersion));
            }
            String header = this.message.getHeader("Content-Type")[0];
            int ix = header.indexOf("boundary");
            return new BasicHeader("Content-Type", "multipart/related; type=\"" + soapVersion.getContentType() + "\"; start=\"" + "<rootpart@soapui.org>" + "\"; " + header.substring(ix));
        }
        catch (MessagingException e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeTo(OutputStream arg0) throws IOException {
        try {
            arg0.write("\r\n".getBytes());
            ((MimeMultipart)this.message.getContent()).writeTo(arg0);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public InputStream getContent() throws IOException {
        try {
            return this.message.getInputStream();
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
    }

    public boolean isStreaming() {
        return false;
    }

    public static class DummyOutputStream
    extends OutputStream {
        private int intLength;
        private long size = 0L;

        public DummyOutputStream() {
            ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
            tempOut.write(1);
            this.intLength = tempOut.toByteArray().length;
        }

        @Override
        public void write(int b) throws IOException {
            this.size += (long)this.intLength;
        }

        public long getSize() {
            return this.size;
        }
    }
}

