/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;

public abstract class AbstractRequestFilter
implements RequestFilter {
    @Override
    public void filterRequest(SubmitContext context, Request request) {
        if (request instanceof AbstractHttpRequestInterface) {
            this.filterAbstractHttpRequest(context, (AbstractHttpRequest)request);
        }
    }

    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> request) {
        if (request instanceof WsdlRequest) {
            this.filterWsdlRequest(context, (WsdlRequest)request);
        } else if (request instanceof RestRequestInterface) {
            this.filterRestRequest(context, (RestRequestInterface)((Object)request));
        } else if (request instanceof HttpRequestInterface) {
            this.filterHttpRequest(context, (HttpRequestInterface)((Object)request));
        }
    }

    public void filterWsdlRequest(SubmitContext context, WsdlRequest request) {
    }

    public void filterRestRequest(SubmitContext context, RestRequestInterface request) {
    }

    public void filterHttpRequest(SubmitContext context, HttpRequestInterface<?> request) {
    }

    @Override
    public void afterRequest(SubmitContext context, Request request) {
        Response response = (Response)context.getProperty("httpResponse");
        if (response != null) {
            this.afterRequest(context, response);
        }
        if (request instanceof AbstractHttpRequestInterface) {
            this.afterAbstractHttpResponse(context, (AbstractHttpRequestInterface)request);
        }
    }

    public void afterAbstractHttpResponse(SubmitContext context, AbstractHttpRequestInterface<?> request) {
        if (request instanceof WsdlRequest) {
            this.afterWsdlRequest(context, (WsdlRequest)request);
        } else if (request instanceof RestRequestInterface) {
            this.afterRestRequest(context, (RestRequestInterface)request);
        } else if (request instanceof HttpRequestInterface) {
            this.afterHttpRequest(context, (HttpRequestInterface)request);
        }
    }

    public void afterWsdlRequest(SubmitContext context, WsdlRequest request) {
    }

    public void afterRestRequest(SubmitContext context, RestRequestInterface request) {
    }

    public void afterHttpRequest(SubmitContext context, HttpRequestInterface<?> request) {
    }

    @Override
    public void afterRequest(SubmitContext context, Response response) {
    }
}

