/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;

public abstract class AbstractMessageExchange<T extends ModelItem>
implements MessageExchange {
    protected StringToStringMap properties;
    private String[] messages;
    private T modelItem;
    protected boolean discardResponse;

    public AbstractMessageExchange(T modelItem) {
        this.modelItem = modelItem;
        this.discardResponse = modelItem.getSettings().getBoolean("discardResponse");
    }

    public T getModelItem() {
        return this.modelItem;
    }

    @Override
    public String getRequestContentAsXml() {
        if (this.hasRequest(true) && XmlUtils.seemsToBeXml(this.getRequestContent())) {
            return this.getRequestContent();
        }
        return "<not-xml/>";
    }

    @Override
    public String getResponseContentAsXml() {
        if (this.hasResponse() && XmlUtils.seemsToBeXml(this.getResponseContent())) {
            return this.getResponseContent();
        }
        return null;
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(name, value);
    }

    @Override
    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    @Override
    public StringToStringMap getProperties() {
        return this.properties;
    }

    @Override
    public String[] getMessages() {
        return this.messages;
    }

    public void setMessages(String[] messages) {
        this.messages = messages;
    }
}

