/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.support;

import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTableModel;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.environment.EnvironmentListener;
import com.eviware.soapui.model.environment.Property;
import com.eviware.soapui.model.support.TestPropertyUtils;
import com.eviware.soapui.model.testsuite.EvaluatedOnReadTestProperty;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.table.AbstractTableModel;

public class DefaultPropertyHolderTableModel<T extends TestPropertyHolder>
extends AbstractTableModel
implements PropertyHolderTableModel,
EnvironmentListener,
PropertyChangeListener {
    protected InternalTestPropertyListener testPropertyListener;
    protected StringList paramNameIndex = new StringList();
    protected T params;
    protected boolean isLastChangeParameterLevelChange = false;

    protected DefaultPropertyHolderTableModel() {
    }

    public DefaultPropertyHolderTableModel(T holder) {
        this.params = holder;
        this.buildParamNameIndex();
        this.testPropertyListener = new InternalTestPropertyListener();
        holder.addTestPropertyListener(this.testPropertyListener);
    }

    protected void buildParamNameIndex() {
        this.paramNameIndex = new StringList(this.getPropertyNames());
    }

    protected String[] getPropertyNames() {
        return this.params.getPropertyNames();
    }

    public void release() {
        this.params.removeTestPropertyListener(this.testPropertyListener);
    }

    @Override
    public int getRowCount() {
        return this.paramNameIndex.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.params instanceof MutableTestPropertyHolder;
        }
        return !this.getPropertyAtRow(rowIndex).isReadOnly();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        TestProperty property = this.getPropertyAtRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (!(this.params instanceof MutableTestPropertyHolder)) break;
                if (this.propertyExists(aValue, property)) {
                    return;
                }
                ((MutableTestPropertyHolder)this.params).renameProperty(property.getName(), aValue.toString());
                break;
            }
            case 1: {
                property.setValue(aValue.toString());
                if (this.params.getModelItem() instanceof RestRequest || !(property instanceof RestParamProperty)) break;
                ((RestParamProperty)property).setDefaultValue(aValue.toString());
            }
        }
    }

    protected boolean propertyExists(Object aValue, TestProperty property) {
        TestProperty prop = this.params.getProperty(aValue.toString());
        if (prop != null && prop != property) {
            UISupport.showErrorMessage("Property name exists!");
            return true;
        }
        return false;
    }

    @Override
    public TestProperty getPropertyAtRow(int rowIndex) {
        return this.params.getProperty((String)this.paramNameIndex.get(rowIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TestProperty property = this.getPropertyAtRow(rowIndex);
        if (property == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return property.getName();
            }
            case 1: {
                if (property instanceof EvaluatedOnReadTestProperty) {
                    return ((EvaluatedOnReadTestProperty)((Object)property)).getCurrentValue();
                }
                return property.getValue();
            }
        }
        return null;
    }

    @Override
    public void propertyValueChanged(Property property) {
        this.fireTableDataChanged();
    }

    public void propertyMoved() {
        this.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableDataChanged();
    }

    @Override
    public void moveProperty(String name, int oldIndex, int newIndex) {
        ((MutableTestPropertyHolder)this.params).moveProperty(name, newIndex);
        String valueAtNewindex = (String)this.paramNameIndex.get(newIndex);
        this.paramNameIndex.set(newIndex, name);
        this.paramNameIndex.set(oldIndex, valueAtNewindex);
        this.testPropertyListener.propertyMoved(name, oldIndex, newIndex);
    }

    public void sort() {
        Collections.sort(this.paramNameIndex);
        TestPropertyUtils.sortProperties((MutableTestPropertyHolder)this.params);
        this.fireTableDataChanged();
    }

    protected final class InternalTestPropertyListener
    implements TestPropertyListener {
        protected InternalTestPropertyListener() {
        }

        @Override
        public void propertyAdded(String name) {
            if (!DefaultPropertyHolderTableModel.this.paramNameIndex.contains(name)) {
                DefaultPropertyHolderTableModel.this.paramNameIndex.add(name);
            }
            DefaultPropertyHolderTableModel.this.fireTableDataChanged();
        }

        @Override
        public void propertyRemoved(String name) {
            if (!DefaultPropertyHolderTableModel.this.isLastChangeParameterLevelChange) {
                DefaultPropertyHolderTableModel.this.paramNameIndex.remove(name);
            }
            DefaultPropertyHolderTableModel.this.isLastChangeParameterLevelChange = false;
            DefaultPropertyHolderTableModel.this.fireTableDataChanged();
        }

        @Override
        public void propertyRenamed(String oldName, String newName) {
            int paramIndex = DefaultPropertyHolderTableModel.this.paramNameIndex.indexOf(oldName);
            if (paramIndex < 0) {
                return;
            }
            DefaultPropertyHolderTableModel.this.paramNameIndex.set(paramIndex, newName);
            DefaultPropertyHolderTableModel.this.fireTableDataChanged();
        }

        @Override
        public void propertyValueChanged(String name, String oldValue, String newValue) {
            DefaultPropertyHolderTableModel.this.fireTableDataChanged();
        }

        @Override
        public void propertyMoved(String name, int oldIndex, int newIndex) {
            DefaultPropertyHolderTableModel.this.fireTableDataChanged();
        }
    }
}

