/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.amf;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFCredentials;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.SoapUIAMFConnection;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import flex.messaging.io.amf.client.exceptions.ClientStatusException;
import flex.messaging.io.amf.client.exceptions.ServerStatusException;

public class AMFTestRunListener
implements TestRunListener {
    private AMFCredentials amfCredentials;

    @Override
    public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        if (this.amfCredentials != null && runContext.getProperty("AMF_CONNECTION") != null && runContext.getProperty("AMF_CONNECTION") instanceof SoapUIAMFConnection && this.amfCredentials.isLoggedIn()) {
            this.amfCredentials.logout();
        }
    }

    @Override
    public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        if (testRunner.getTestCase() instanceof WsdlTestCase) {
            try {
                WsdlTestCase wsdlTestCase = (WsdlTestCase)testRunner.getTestCase();
                if (((TestCaseConfig)wsdlTestCase.getConfig()).getAmfAuthorisation()) {
                    if (AMFTestRunListener.noAMFTestSteps(wsdlTestCase)) {
                        return;
                    }
                    String endpoint = runContext.expand(((TestCaseConfig)wsdlTestCase.getConfig()).getAmfEndpoint());
                    String username = runContext.expand(((TestCaseConfig)wsdlTestCase.getConfig()).getAmfLogin());
                    String password = runContext.expand(((TestCaseConfig)wsdlTestCase.getConfig()).getAmfPassword());
                    SoapUIAMFConnection amfConnection = null;
                    if (StringUtils.hasContent(endpoint)) {
                        if (StringUtils.hasContent(username)) {
                            this.amfCredentials = new AMFCredentials(endpoint, username, password, runContext);
                            amfConnection = this.amfCredentials.login();
                        } else {
                            amfConnection = new SoapUIAMFConnection();
                            amfConnection.connect(runContext.expand(endpoint));
                        }
                        runContext.setProperty("AMF_CONNECTION", amfConnection);
                    }
                }
            }
            catch (ClientStatusException e) {
                SoapUI.logError(e);
            }
            catch (ServerStatusException e) {
                SoapUI.logError(e);
            }
        }
    }

    private static boolean noAMFTestSteps(WsdlTestCase wsdlTestCase) {
        return wsdlTestCase.getTestStepsOfType(AMFRequestTestStep.class).isEmpty();
    }

    @Override
    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext) {
    }

    @Override
    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
    }

    @Override
    public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
    }
}

