/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.lang.StringUtils;

public class ContentTypes {
    private List<ContentType> contentTypes;

    private ContentTypes(List<ContentType> contentTypes) {
        this.contentTypes = contentTypes;
    }

    public static ContentTypes of(String contentTypes) {
        ArrayList<ContentType> contentTypeList = new ArrayList<ContentType>();
        for (String ct : contentTypes.split(",")) {
            try {
                contentTypeList.add(new ContentType(ct.trim()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new ContentTypes(contentTypeList);
    }

    public boolean matches(String value) {
        for (ContentType contentType : this.contentTypes) {
            try {
                ContentType respondedContentType = new ContentType(value);
                if (!this.contentTypeMatches(contentType, respondedContentType)) continue;
                return true;
            }
            catch (ParseException parseException) {
            }
        }
        return false;
    }

    public String toString() {
        return StringUtils.join(this.contentTypes, (String)", ");
    }

    private boolean contentTypeMatches(ContentType contentType, ContentType respondedContentType) {
        return contentType.match(respondedContentType) || (contentType.getPrimaryType().charAt(0) == '*' || respondedContentType.getPrimaryType().charAt(0) == '*') && (contentType.getSubType().charAt(0) == '*' || respondedContentType.getSubType().charAt(0) == '*' || contentType.getSubType().equalsIgnoreCase(respondedContentType.getSubType()));
    }
}

