/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.util.ArrayList;

public abstract class AbstractAddToTestCaseAction<T extends ModelItem>
extends AbstractSoapUIAction<T> {
    public AbstractAddToTestCaseAction(String name, String description) {
        super(name, description);
    }

    public static WsdlTestCase getTargetTestCase(WsdlProject project) {
        WsdlTestCase testCase;
        WsdlTestSuite testSuite;
        ArrayList<WsdlTestCase> testCases = new ArrayList<WsdlTestCase>();
        ArrayList<WsdlTestSuite> testSuites = new ArrayList<WsdlTestSuite>();
        ArrayList<String> testCaseNames = new ArrayList<String>();
        if (project.getTestSuiteCount() == 0) {
            return AbstractAddToTestCaseAction.addNewTestSuiteAndTestCase(project, "Missing TestSuite in project, enter name to create");
        }
        for (int c = 0; c < project.getTestSuiteCount(); ++c) {
            testSuite = project.getTestSuiteAt(c);
            for (int i = 0; i < testSuite.getTestCaseCount(); ++i) {
                testCase = testSuite.getTestCaseAt(i);
                testCases.add(testCase);
                testCaseNames.add(testCaseNames.size() + 1 + ": " + testSuite.getName() + " - " + testCase.getName());
                testSuites.add(testSuite);
            }
            testCases.add(null);
            testSuites.add(testSuite);
            testCaseNames.add(testCaseNames.size() + 1 + ": " + testSuite.getName() + " -> Create new TestCase");
        }
        if (testCases.size() == 0) {
            ArrayList<String> testSuiteNames = new ArrayList<String>();
            for (int c = 0; c < project.getTestSuiteCount(); ++c) {
                WsdlTestSuite testSuite2 = project.getTestSuiteAt(c);
                testSuiteNames.add(testSuiteNames.size() + 1 + ": " + testSuite2.getName());
            }
            String selection = (String)UISupport.prompt("Select TestSuite to create TestCase in", "Select TestSuite", testSuiteNames.toArray());
            if (selection == null) {
                return null;
            }
            WsdlTestSuite testSuite3 = project.getTestSuiteAt(testSuiteNames.indexOf(selection));
            String name = UISupport.prompt("Specify name of TestCase", "Create TestCase", "TestCase " + (testSuite3.getTestCaseCount() + 1));
            if (name == null) {
                return null;
            }
            return testSuite3.addNewTestCase(name);
        }
        testCases.add(null);
        testSuites.add(null);
        testCaseNames.add(testCaseNames.size() + 1 + ": -> Create new TestSuite");
        String selection = (String)UISupport.prompt("Select TestCase", "Select TestCase", testCaseNames.toArray());
        if (selection == null) {
            return null;
        }
        testCase = (WsdlTestCase)testCases.get(testCaseNames.indexOf(selection));
        while (testCase != null && (SoapUI.getTestMonitor().hasRunningLoadTest(testCase) || SoapUI.getTestMonitor().hasRunningSecurityTest(testCase))) {
            UISupport.showErrorMessage("Can not add to TestCase that is currently LoadTesting or SecurityTesting");
            selection = (String)UISupport.prompt("Select TestCase", "Select TestCase", testCaseNames.toArray());
            if (selection == null) {
                return null;
            }
            testCase = (WsdlTestCase)testCases.get(testCaseNames.indexOf(selection));
        }
        if (testCase == null) {
            testSuite = (WsdlTestSuite)testSuites.get(testCaseNames.indexOf(selection));
            if (testSuite == null) {
                return AbstractAddToTestCaseAction.addNewTestSuiteAndTestCase(project, "Specify name of TestSuite");
            }
            String name = UISupport.prompt("Specify name of TestCase", "Create TestCase", "TestCase " + (testSuite.getTestCaseCount() + 1));
            if (name == null) {
                return null;
            }
            return testSuite.addNewTestCase(name);
        }
        return testCase;
    }

    protected static WsdlTestCase addNewTestSuiteAndTestCase(WsdlProject project, String questionText) {
        String testSuiteName = UISupport.prompt(questionText, "Create TestSuite", "TestSuite " + (project.getTestSuiteCount() + 1));
        if (testSuiteName == null) {
            return null;
        }
        String testCaseName = UISupport.prompt("Specify name of TestCase", "Create TestCase", "TestCase 1");
        if (testCaseName == null) {
            return null;
        }
        WsdlTestSuite testSuite = project.addNewTestSuite(testSuiteName);
        return testSuite.addNewTestCase(testCaseName);
    }
}

