/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockservice;

import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CloneMockServiceAction
extends AbstractSoapUIAction<WsdlMockService> {
    public static final String SOAPUI_ACTION_ID = "CloneMockServiceAction";
    private XFormDialog dialog;

    public CloneMockServiceAction() {
        super("Clone MockService", "Clones this MockService");
    }

    @Override
    public void perform(WsdlMockService mockService, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
        }
        this.dialog.getFormField("Clone description").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                if (CloneMockServiceAction.this.dialog.getBooleanValue("Clone description")) {
                    CloneMockServiceAction.this.dialog.getFormField("Description").setEnabled(false);
                } else {
                    CloneMockServiceAction.this.dialog.getFormField("Description").setEnabled(true);
                }
            }
        });
        this.dialog.setValue("MockService Name", "Copy of " + mockService.getName());
        this.dialog.setBooleanValue("Clone description", true);
        this.dialog.getFormField("Description").setEnabled(false);
        this.dialog.setValue("Description", mockService.getDescription());
        WorkspaceImpl workspace = mockService.getProject().getWorkspace();
        this.dialog.setOptions("Target Project", ModelSupport.getNames(workspace.getOpenProjectList(), new String[]{"<Create New>"}));
        this.dialog.setValue("Target Project", mockService.getProject().getName());
        if (this.dialog.show()) {
            String targetProjectName = this.dialog.getValue("Target Project");
            String name = this.dialog.getValue("MockService Name");
            WsdlProject project = mockService.getProject();
            WsdlMockService clonedService = null;
            boolean cloneDescription = this.dialog.getBooleanValue("Clone description");
            String description = mockService.getDescription();
            if (!cloneDescription) {
                description = this.dialog.getValue("Description");
            }
            if ((clonedService = targetProjectName.equals(mockService.getProject().getName()) ? this.cloneMockServiceWithinProject(mockService, name, project, description) : this.cloneToAnotherProject(mockService, targetProjectName, name, description)) != null) {
                UISupport.select(clonedService);
            }
            if (this.dialog.getBooleanValue("Move instead")) {
                project.removeMockService(mockService);
            }
        }
    }

    public WsdlMockService cloneToAnotherProject(WsdlMockService mockService, String targetProjectName, String name, String description) {
        Set<WsdlInterface> requiredInterfaces;
        WorkspaceImpl workspace = mockService.getProject().getWorkspace();
        WsdlProject targetProject = (WsdlProject)workspace.getProjectByName(targetProjectName);
        if (targetProject == null) {
            targetProjectName = UISupport.prompt("Enter name for new Project", "Clone MockService", "");
            if (targetProjectName == null) {
                return null;
            }
            try {
                targetProject = workspace.createProject(targetProjectName, null);
            }
            catch (SoapUIException e) {
                UISupport.showErrorMessage(e);
            }
            if (targetProject == null) {
                return null;
            }
        }
        if ((requiredInterfaces = this.getRequiredInterfaces(mockService, targetProject)).size() > 0) {
            String msg = "Target project [" + targetProjectName + "] is missing required interfaces;\r\n\r\n";
            for (WsdlInterface iface : requiredInterfaces) {
                msg = msg + iface.getName() + " [" + iface.getTechnicalId() + "]\r\n";
            }
            if (!UISupport.confirm(msg = msg + "\r\nThese will be cloned to the targetProject as well", "Clone MockService")) {
                return null;
            }
            for (WsdlInterface iface : requiredInterfaces) {
                targetProject.importInterface(iface, false, true);
            }
        }
        mockService = targetProject.importMockService(mockService, name, true, description);
        UISupport.select(mockService);
        return mockService;
    }

    public WsdlMockService cloneMockServiceWithinProject(WsdlMockService mockService, String name, WsdlProject project, String description) {
        WsdlMockService newMockService = project.importMockService(mockService, name, true, description);
        UISupport.select(newMockService);
        return newMockService;
    }

    private Set<WsdlInterface> getRequiredInterfaces(WsdlMockService mockService, WsdlProject targetProject) {
        HashSet<WsdlInterface> requiredInterfaces = new HashSet<WsdlInterface>();
        for (int i = 0; i < mockService.getMockOperationCount(); ++i) {
            WsdlOperation operation = ((WsdlMockOperation)mockService.getMockOperationAt(i)).getOperation();
            if (operation == null) continue;
            requiredInterfaces.add(operation.getInterface());
        }
        if (requiredInterfaces.size() > 0 && targetProject.getInterfaceCount() > 0) {
            HashMap<String, WsdlInterface> bindings = new HashMap<String, WsdlInterface>();
            for (WsdlInterface wsdlInterface : requiredInterfaces) {
                bindings.put(wsdlInterface.getTechnicalId(), wsdlInterface);
            }
            for (Interface interface_ : targetProject.getInterfaceList()) {
                bindings.remove(interface_.getTechnicalId());
            }
            requiredInterfaces.retainAll(bindings.values());
        }
        return requiredInterfaces;
    }

    @AForm(description="Specify target Project and name of cloned MockService", name="Clone MockService", helpUrl="/Service-Mocking/mocking-soap-services.html", icon="/applications-system.png")
    public static interface Form {
        @AField(name="MockService Name", description="The name of the cloned MockService", type=AField.AFieldType.STRING)
        public static final String NAME = "MockService Name";
        @AField(name="Target Project", description="The target Project for the cloned MockService", type=AField.AFieldType.ENUMERATION)
        public static final String PROJECT = "Target Project";
        @AField(name="Move instead", description="Moves the selected MockService instead of copying", type=AField.AFieldType.BOOLEAN)
        public static final String MOVE = "Move instead";
        @AField(name="Clone description", description="Clones the description of selected TestCase", type=AField.AFieldType.BOOLEAN)
        public static final String CLONE_DESCRIPTION = "Clone description";
        @AField(name="Description", description="Descroption of new TestCase", type=AField.AFieldType.STRINGAREA)
        public static final String DESCRIPTION = "Description";
    }
}

