/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.soapui;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import org.apache.log4j.Logger;

@Deprecated
public class SecurityTestRunnerAction
extends AbstractToolsAction<WsdlProject> {
    private static final String SH = ".sh";
    private static final String BAT = ".bat";
    private static final String SECURITYTESTRUNNER = "securitytestrunner";
    private static final String ALL_VALUE = "<all>";
    private static final String TESTSUITE = "TestSuite";
    private static final String TESTCASE = "TestCase";
    private static final String TESTRUNNERPATH = "Security TestRunner Path";
    private static final String SECURITY_TEST_NAME = "SecurityTestName";
    private static final String SAVEPROJECT = "Save Project";
    private XForm mainForm;
    private static final Logger log = Logger.getLogger(SecurityTestRunnerAction.class);
    public static final String SOAPUI_ACTION_ID = "SecurityTestRunnerAction";
    private List<TestSuite> testSuites;

    public SecurityTestRunnerAction() {
        super("Launch SecurityTestRunner", "Launch command-line SecurityTestRunner for this project");
    }

    @Override
    protected XFormDialog buildDialog(WsdlProject modelItem) {
        if (modelItem == null) {
            return null;
        }
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Launch Security TestRunner");
        this.mainForm = builder.createForm("Basic");
        this.mainForm.addComboBox(TESTSUITE, new String[0], "The TestSuite to run").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                ArrayList<String> testCases = new ArrayList<String>();
                String tc = SecurityTestRunnerAction.this.mainForm.getComponentValue(SecurityTestRunnerAction.TESTCASE);
                if (newValue.equals(SecurityTestRunnerAction.ALL_VALUE)) {
                    for (TestSuite testSuite : SecurityTestRunnerAction.this.testSuites) {
                        for (TestCase testCase : testSuite.getTestCaseList()) {
                            if (testCases.contains(testCase.getName())) continue;
                            testCases.add(testCase.getName());
                        }
                    }
                } else {
                    WsdlTestSuite testSuite = ((WsdlProject)SecurityTestRunnerAction.this.getModelItem()).getTestSuiteByName(newValue);
                    if (testSuite != null) {
                        testCases.addAll(Arrays.asList(ModelSupport.getNames(testSuite.getTestCaseList())));
                    }
                }
                testCases.add(0, SecurityTestRunnerAction.ALL_VALUE);
                SecurityTestRunnerAction.this.mainForm.setOptions(SecurityTestRunnerAction.TESTCASE, testCases.toArray());
                if (testCases.contains(tc)) {
                    SecurityTestRunnerAction.this.mainForm.getFormField(SecurityTestRunnerAction.TESTCASE).setValue(tc);
                }
            }
        });
        this.mainForm.addComboBox(TESTCASE, new String[0], TESTCASE).addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                ArrayList<String> securityTests = new ArrayList<String>();
                String st = SecurityTestRunnerAction.this.mainForm.getComponentValue(SecurityTestRunnerAction.SECURITY_TEST_NAME);
                if (newValue.equals(SecurityTestRunnerAction.ALL_VALUE)) {
                    for (TestSuite testSuite : SecurityTestRunnerAction.this.testSuites) {
                        for (TestCase testCase : testSuite.getTestCaseList()) {
                            for (SecurityTest securityTest : testCase.getSecurityTestList()) {
                                if (securityTests.contains(securityTest.getName())) continue;
                                securityTests.add(securityTest.getName());
                            }
                        }
                    }
                } else {
                    TestCase testCase = null;
                    try {
                        testCase = ((WsdlProject)SecurityTestRunnerAction.this.getModelItem()).getTestSuiteByName(SecurityTestRunnerAction.this.mainForm.getComponentValue(SecurityTestRunnerAction.TESTSUITE)).getTestCaseByName(SecurityTestRunnerAction.this.mainForm.getComponentValue(SecurityTestRunnerAction.TESTCASE));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (testCase != null) {
                        securityTests.addAll(Arrays.asList(ModelSupport.getNames(testCase.getSecurityTestList())));
                    }
                }
                securityTests.add(0, SecurityTestRunnerAction.ALL_VALUE);
                SecurityTestRunnerAction.this.mainForm.setOptions(SecurityTestRunnerAction.SECURITY_TEST_NAME, securityTests.toArray());
                if (securityTests.contains(st)) {
                    SecurityTestRunnerAction.this.mainForm.getFormField(SecurityTestRunnerAction.SECURITY_TEST_NAME).setValue(st);
                }
            }
        });
        this.mainForm.addComboBox(SECURITY_TEST_NAME, new String[0], "The Security Test to run");
        this.mainForm.addCheckBox(SAVEPROJECT, "Saves project before running").setEnabled(!modelItem.isRemote());
        this.mainForm.addSeparator();
        this.mainForm.addTextField(TESTRUNNERPATH, "Folder containing SecurityTestRunner.bat to use", XForm.FieldType.FOLDER);
        this.setToolsSettingsAction(null);
        this.buildArgsForm(builder, false, "TestRunner");
        return builder.buildDialog(this.buildDefaultActions("/test-automation/running-from-soapui/security-tests.html", modelItem), "Specify arguments for launching SoapUI Security TestRunner", UISupport.TOOL_ICON);
    }

    @Override
    protected XForm buildArgsForm(XFormDialogBuilder builder, boolean addJavaArgs, String toolName) {
        return null;
    }

    @Override
    protected Action createRunOption(WsdlProject modelItem) {
        Action action = super.createRunOption(modelItem);
        action.putValue("Name", "Launch");
        return action;
    }

    @Override
    protected StringToStringMap initValues(WsdlProject modelItem, Object param) {
        if (modelItem != null && this.mainForm != null) {
            ArrayList<String> endpoints = new ArrayList<String>();
            for (Interface iface : modelItem.getInterfaceList()) {
                for (String endpoint : iface.getEndpoints()) {
                    if (endpoints.contains(endpoint)) continue;
                    endpoints.add(endpoint);
                }
            }
            endpoints.add(0, null);
            this.testSuites = modelItem.getTestSuiteList();
            for (int c = 0; c < this.testSuites.size(); ++c) {
                if (this.testSuites.get(c).getTestCaseCount() != 0) continue;
                this.testSuites.remove(c);
                --c;
            }
            this.mainForm.setOptions(TESTSUITE, ModelSupport.getNames(new String[]{ALL_VALUE}, this.testSuites));
            ArrayList<String> testCases = new ArrayList<String>();
            for (TestSuite testSuite : this.testSuites) {
                for (TestCase testCase : testSuite.getTestCaseList()) {
                    if (testCases.contains(testCase.getName())) continue;
                    testCases.add(testCase.getName());
                }
            }
            testCases.add(0, ALL_VALUE);
            this.mainForm.setOptions(TESTCASE, testCases.toArray());
            this.mainForm.getComponent(SAVEPROJECT).setEnabled(!modelItem.isRemote());
        }
        StringToStringMap values = super.initValues(modelItem, param);
        if (this.mainForm != null) {
            if (param instanceof WsdlTestCase) {
                this.mainForm.getFormField(TESTSUITE).setValue(((WsdlTestCase)param).getTestSuite().getName());
                this.mainForm.getFormField(TESTCASE).setValue(((WsdlTestCase)param).getName());
                values.put(TESTSUITE, ((WsdlTestCase)param).getTestSuite().getName());
                values.put(TESTCASE, ((WsdlTestCase)param).getName());
            } else if (param instanceof WsdlTestSuite) {
                this.mainForm.getFormField(TESTSUITE).setValue(((WsdlTestSuite)param).getName());
                values.put(TESTSUITE, ((WsdlTestSuite)param).getName());
            }
        }
        return values;
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost, WsdlProject modelItem) throws Exception {
        String testRunnerDir = this.mainForm.getComponentValue(TESTRUNNERPATH);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(modelItem);
        builder.command(args.getArgs());
        if (StringUtils.isNullOrEmpty(testRunnerDir)) {
            builder.directory(new File("."));
        } else {
            builder.directory(new File(testRunnerDir));
        }
        if (this.mainForm.getComponentValue(SAVEPROJECT).equals(Boolean.TRUE.toString())) {
            modelItem.save();
        } else if (StringUtils.isNullOrEmpty(modelItem.getPath())) {
            UISupport.showErrorMessage("Project [" + modelItem.getName() + "] has not been saved to file.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launching security testrunner in directory [" + builder.directory() + "] with arguments [" + args.toString() + "]"));
        }
        toolHost.run(new ProcessToolRunner(builder, "SoapUI Security TestRunner", (ModelItem)modelItem, args));
    }

    private ArgumentBuilder buildArgs(WsdlProject modelItem) throws IOException {
        XFormDialog dialog = this.getDialog();
        if (dialog == null) {
            ArgumentBuilder builder = new ArgumentBuilder(new StringToStringMap());
            builder.startScript(SECURITYTESTRUNNER, BAT, SH);
            return builder;
        }
        StringToStringMap values = dialog.getValues();
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript(SECURITYTESTRUNNER, BAT, SH);
        if (!((String)values.get(TESTSUITE)).equals(ALL_VALUE)) {
            builder.addString(TESTSUITE, "-s", "");
        }
        if (!((String)values.get(TESTCASE)).equals(ALL_VALUE)) {
            builder.addString(TESTCASE, "-c", "");
        }
        if (!((String)values.get(SECURITY_TEST_NAME)).equals(ALL_VALUE)) {
            builder.addString(SECURITY_TEST_NAME, "-n", "");
        }
        builder.addArgs(modelItem.getPath());
        this.addToolArgs(values, builder);
        return builder;
    }
}

