/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.iface.RemoveInterfaceAction;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.components.ModelItemListDesktopPanel;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class UpdateInterfaceAction
extends AbstractSoapUIAction<WsdlInterface> {
    public static final String SOAPUI_ACTION_ID = "UpdateInterfaceAction";
    private XFormDialog dialog = null;

    public UpdateInterfaceAction() {
        this("Update Definition", "Reloads the definition for this interface and its operations");
    }

    protected UpdateInterfaceAction(String name, String description) {
        super(name, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(WsdlInterface iface, Object param) {
        if (RemoveInterfaceAction.hasRunningDependingTests(iface)) {
            UISupport.showErrorMessage("Cannot update Interface due to running depending tests");
            return;
        }
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.setBooleanValue("Create New Requests", true);
            this.dialog.getFormField("Create Backups").setEnabled(false);
            this.dialog.getFormField("Recreate Optional").setEnabled(false);
            this.dialog.getFormField("Keep Existing").setEnabled(false);
            this.dialog.getFormField("Recreate Requests").addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    boolean enabled = UpdateInterfaceAction.this.dialog.getBooleanValue("Recreate Requests");
                    UpdateInterfaceAction.this.dialog.getFormField("Create Backups").setEnabled(enabled);
                    UpdateInterfaceAction.this.dialog.getFormField("Recreate Optional").setEnabled(enabled);
                    UpdateInterfaceAction.this.dialog.getFormField("Keep Existing").setEnabled(enabled);
                }
            });
        }
        this.dialog.setValue("Definition URL", iface.getDefinition());
        this.dialog.getFormField("Definition URL").setToolTip(PathUtils.expandPath(iface.getDefinition(), iface));
        if (!this.dialog.show()) {
            return;
        }
        String url = this.dialog.getValue("Definition URL");
        if (url == null || url.trim().length() == 0) {
            return;
        }
        String expUrl = PathUtils.expandPath(url, iface);
        if (expUrl.trim().length() == 0) {
            return;
        }
        try {
            File file = new File(expUrl);
            if (file.exists()) {
                expUrl = file.toURI().toURL().toString();
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        boolean createRequests = this.dialog.getBooleanValue("Create New Requests");
        try {
            UISupport.setHourglassCursor();
            if (iface.updateDefinition(expUrl, createRequests)) {
                this.afterUpdate(iface);
                if (!url.equals(expUrl)) {
                    iface.setDefinition(url, false);
                }
            } else {
                UISupport.showInfoMessage("Update of interface failed", "Update Definition");
            }
        }
        catch (Exception e1) {
            UISupport.showInfoMessage("Failed to update interface: [" + e1 + "]", "Update Definition");
            SoapUI.logError(e1);
        }
        finally {
            UISupport.resetCursor();
        }
    }

    protected void afterUpdate(WsdlInterface iface) throws Exception {
        if (this.dialog.getBooleanValue("Recreate Requests")) {
            boolean buildOptional = this.dialog.getBooleanValue("Recreate Optional");
            boolean createBackups = this.dialog.getBooleanValue("Create Backups");
            boolean keepExisting = this.dialog.getBooleanValue("Keep Existing");
            boolean keepHeaders = this.dialog.getBooleanValue("Keep SOAP Headers");
            ArrayList<ModelItem> updated = new ArrayList<ModelItem>();
            updated.addAll(UpdateInterfaceAction.recreateRequests(iface, buildOptional, createBackups, keepExisting, keepHeaders));
            if (this.dialog.getBooleanValue("Update TestRequests")) {
                updated.addAll(UpdateInterfaceAction.recreateTestRequests(iface, buildOptional, createBackups, keepExisting, keepHeaders));
            }
            UISupport.showInfoMessage("Update of interface successfull, [" + updated.size() + "] Requests/TestRequests have been updated.", "Update Definition");
            if (this.dialog.getBooleanValue("Open Request List")) {
                UISupport.showDesktopPanel(new ModelItemListDesktopPanel("Updated Requests/TestRequests", "The following Request/TestRequests where updated", updated.toArray(new ModelItem[updated.size()])));
            }
        } else {
            UISupport.showInfoMessage("Update of interface successful", "Update Definition");
        }
    }

    public static List<Request> recreateRequests(WsdlInterface iface, boolean buildOptional, boolean createBackups, boolean keepExisting, boolean keepHeaders) {
        int count = 0;
        ArrayList<Request> result = new ArrayList<Request>();
        for (int c = 0; c < iface.getOperationCount(); ++c) {
            WsdlOperation operation = iface.getOperationAt(c);
            String newRequest = operation.createRequest(buildOptional);
            List<Request> requests = operation.getRequestList();
            for (Request request : requests) {
                String req;
                String requestContent = request.getRequestContent();
                if (keepHeaders) {
                    newRequest = SoapUtils.transferSoapHeaders(requestContent, newRequest, iface.getSoapVersion());
                }
                if ((req = XmlUtils.transferValues(requestContent, newRequest)).equals(requestContent) || XmlUtils.prettyPrintXml(req).equals(XmlUtils.prettyPrintXml(requestContent))) continue;
                if (createBackups) {
                    WsdlRequest backupRequest = operation.addNewRequest("Backup of [" + request.getName() + "]");
                    ((WsdlRequest)request).copyTo(backupRequest, false, false);
                }
                ((WsdlRequest)request).setRequestContent(req);
                ++count;
                result.add(request);
            }
        }
        return result;
    }

    public static List<WsdlTestRequestStep> recreateTestRequests(WsdlInterface iface, boolean buildOptional, boolean createBackups, boolean keepExisting, boolean keepHeaders) {
        int count = 0;
        ArrayList<WsdlTestRequestStep> result = new ArrayList<WsdlTestRequestStep>();
        for (TestSuite testSuite : iface.getProject().getTestSuiteList()) {
            for (TestCase testCase : testSuite.getTestCaseList()) {
                int testStepCount = testCase.getTestStepCount();
                for (int c = 0; c < testStepCount; ++c) {
                    WsdlTestRequest testRequest;
                    WsdlTestStep testStep = (WsdlTestStep)testCase.getTestStepAt(c);
                    if (!(testStep instanceof WsdlTestRequestStep) || (testRequest = ((WsdlTestRequestStep)testStep).getTestRequest()) == null || testRequest.getOperation() == null || testRequest.getOperation().getInterface() != iface) continue;
                    String newRequest = testRequest.getOperation().createRequest(buildOptional);
                    if (keepHeaders) {
                        newRequest = SoapUtils.transferSoapHeaders(testRequest.getRequestContent(), newRequest, iface.getSoapVersion());
                    }
                    if (keepExisting) {
                        newRequest = XmlUtils.transferValues(testRequest.getRequestContent(), newRequest);
                    }
                    if (newRequest.equals(testRequest.getRequestContent())) continue;
                    if (createBackups) {
                        ((WsdlTestCase)testCase).importTestStep(testStep, "Backup of [" + testStep.getName() + "]", -1, true).setDisabled(true);
                    }
                    testRequest.setRequestContent(newRequest);
                    ++count;
                    result.add((WsdlTestRequestStep)testStep);
                }
            }
        }
        return result;
    }

    @AForm(description="Specify Update Definition options", name="Update Definition", helpUrl="/soap-and-wsdl/wsdl-refactoring.html", icon="/applications-system.png")
    protected static interface Form {
        @AField(name="Definition URL", description="The URL or file for the updated definition", type=AField.AFieldType.FILE)
        public static final String DEFINITION_URL = "Definition URL";
        @AField(name="Create New Requests", description="Create default requests for new methods", type=AField.AFieldType.BOOLEAN)
        public static final String CREATE_REQUESTS = "Create New Requests";
        @AField(name="Recreate Requests", description="Recreate existing request with the new schema", type=AField.AFieldType.BOOLEAN)
        public static final String RECREATE_REQUESTS = "Recreate Requests";
        @AField(name="Recreate Optional", description="Recreate optional content when updating requests", type=AField.AFieldType.BOOLEAN)
        public static final String RECREATE_OPTIONAL = "Recreate Optional";
        @AField(name="Keep Existing", description="Keeps existing values when recreating requests", type=AField.AFieldType.BOOLEAN)
        public static final String KEEP_EXISTING = "Keep Existing";
        @AField(name="Keep SOAP Headers", description="Keeps any SOAP Headers when recreating requests", type=AField.AFieldType.BOOLEAN)
        public static final String KEEP_HEADERS = "Keep SOAP Headers";
        @AField(name="Create Backups", description="Create backup copies of changed requests", type=AField.AFieldType.BOOLEAN)
        public static final String CREATE_BACKUPS = "Create Backups";
        @AField(name="Update TestRequests", description="Updates all TestRequests for operations in this Interface also", type=AField.AFieldType.BOOLEAN)
        public static final String UPDATE_TESTREQUESTS = "Update TestRequests";
        @AField(name="Open Request List", description="Opens a list of all requests that have been updated", type=AField.AFieldType.BOOLEAN)
        public static final String OPEN_LIST = "Open Request List";
    }
}

