/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

public class RemoveInterfaceAction
extends AbstractSoapUIAction<WsdlInterface> {
    public RemoveInterfaceAction() {
        super("Remove", "Removes this interface from the project");
    }

    @Override
    public void perform(WsdlInterface iface, Object param) {
        if (RemoveInterfaceAction.hasRunningDependingTests(iface)) {
            UISupport.showErrorMessage("Cannot remove Interface due to running depending tests");
            return;
        }
        if (UISupport.confirm("Remove interface [" + iface.getName() + "] from project [" + iface.getProject().getName() + "]?", "Remove Interface")) {
            if (RemoveInterfaceAction.hasDependingTests(iface) && !UISupport.confirm("Interface has depending TestSteps which will also be removed. Remove anyway?", "Remove Interface")) {
                return;
            }
            if (RemoveInterfaceAction.hasDependingMockOperations(iface) && !UISupport.confirm("Interface has depending MockOperations which will also be removed. Remove anyway?", "Remove Interface")) {
                return;
            }
            WsdlProject project = iface.getProject();
            project.removeInterface(iface);
        }
    }

    public static boolean hasRunningDependingTests(AbstractInterface<?> iface) {
        if (SoapUI.getTestMonitor() == null) {
            return false;
        }
        for (int c = 0; c < iface.getProject().getTestSuiteCount(); ++c) {
            WsdlTestSuite testSuite = iface.getProject().getTestSuiteAt(c);
            for (int i = 0; i < testSuite.getTestCaseCount(); ++i) {
                TestCase testCase = testSuite.getTestCaseAt(i);
                if (!SoapUI.getTestMonitor().hasRunningTest(testCase)) continue;
                for (int j = 0; j < testCase.getTestStepCount(); ++j) {
                    WsdlTestStep testStep = (WsdlTestStep)testCase.getTestStepAt(j);
                    if (!testStep.dependsOn(iface)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasDependingTests(AbstractInterface<?> iface) {
        for (int c = 0; c < iface.getProject().getTestSuiteCount(); ++c) {
            WsdlTestSuite testSuite = iface.getProject().getTestSuiteAt(c);
            for (int i = 0; i < testSuite.getTestCaseCount(); ++i) {
                TestCase testCase = testSuite.getTestCaseAt(i);
                for (int j = 0; j < testCase.getTestStepCount(); ++j) {
                    WsdlTestStep testStep = (WsdlTestStep)testCase.getTestStepAt(j);
                    if (!testStep.dependsOn(iface)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasDependingMockOperations(WsdlInterface iface) {
        for (int c = 0; c < iface.getProject().getMockServiceCount(); ++c) {
            WsdlMockService mockService = iface.getProject().getMockServiceAt(c);
            for (int i = 0; i < mockService.getMockOperationCount(); ++i) {
                MockOperation mockOperation = mockService.getMockOperationAt(i);
                if (mockOperation.getOperation().getInterface() != iface) continue;
                return true;
            }
        }
        return false;
    }
}

