/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.InterfaceConfig;
import com.eviware.soapui.config.MockServiceConfig;
import com.eviware.soapui.config.MockServiceDocumentConfig;
import com.eviware.soapui.config.ProjectConfig;
import com.eviware.soapui.config.RESTMockServiceConfig;
import com.eviware.soapui.config.SecurityTestConfig;
import com.eviware.soapui.config.SoapuiProjectDocumentConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.config.TestStepSecurityTestConfig;
import com.eviware.soapui.config.TestSuiteConfig;
import com.eviware.soapui.config.TestSuiteDocumentConfig;
import com.eviware.soapui.config.TestSuiteRunTypesConfig;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.rest.DefaultOAuth2ProfileContainer;
import com.eviware.soapui.impl.rest.OAuth1ProfileContainer;
import com.eviware.soapui.impl.rest.OAuth2ProfileContainer;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.impl.rest.support.RestRequestConverter;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.support.EndpointSupport;
import com.eviware.soapui.impl.wsdl.AbstractTestPropertyHolderWsdlModelItem;
import com.eviware.soapui.impl.wsdl.InterfaceFactoryRegistry;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.endpoint.DefaultEndpointStrategy;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.testcase.WsdlProjectRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.environment.DefaultEnvironment;
import com.eviware.soapui.model.environment.Environment;
import com.eviware.soapui.model.environment.EnvironmentListener;
import com.eviware.soapui.model.environment.Property;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.EndpointStrategy;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.project.ProjectListener;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.ProjectRunContext;
import com.eviware.soapui.model.testsuite.ProjectRunListener;
import com.eviware.soapui.model.testsuite.ProjectRunner;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunnable;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.resolver.ResolveDialog;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.apache.commons.ssl.OpenSSL;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class WsdlProject
extends AbstractTestPropertyHolderWsdlModelItem<ProjectConfig>
implements Project,
PropertyExpansionContainer,
PropertyChangeListener,
TestRunnable {
    public static final String AFTER_LOAD_SCRIPT_PROPERTY = WsdlProject.class.getName() + "@setupScript";
    public static final String BEFORE_SAVE_SCRIPT_PROPERTY = WsdlProject.class.getName() + "@tearDownScript";
    public static final String RESOURCE_ROOT_PROPERTY = WsdlProject.class.getName() + "@resourceRoot";
    public static final String ICON_NAME = "/project.png";
    protected static final Logger log = Logger.getLogger(WsdlProject.class);
    private static final String XML_FILE_TYPE = "XML Files (*.xml)";
    private static final String XML_EXTENSION = ".xml";
    protected String path;
    protected List<AbstractInterface<?>> interfaces = new ArrayList();
    protected List<WsdlTestSuite> testSuites = new ArrayList<WsdlTestSuite>();
    protected List<WsdlMockService> mockServices = new ArrayList<WsdlMockService>();
    protected List<RestMockService> restMockServices = new ArrayList<RestMockService>();
    protected Set<ProjectListener> projectListeners = new HashSet<ProjectListener>();
    protected SoapuiProjectDocumentConfig projectDocument;
    protected EndpointStrategy endpointStrategy = new DefaultEndpointStrategy();
    protected long lastModified;
    protected DefaultWssContainer wssContainer;
    protected OAuth2ProfileContainer oAuth2ProfileContainer;
    protected OAuth1ProfileContainer oAuth1ProfileContainer;
    protected Set<EnvironmentListener> environmentListeners = new HashSet<EnvironmentListener>();
    protected ProjectEncryptionStatus encryptionStatus = ProjectEncryptionStatus.NOT_ENCRYPTED;
    protected EndpointSupport endpointSupport;
    private WorkspaceImpl workspace;
    private ImageIcon disabledIcon;
    private ImageIcon closedIcon;
    private ImageIcon remoteIcon;
    private ImageIcon openEncyptedIcon;
    private boolean remote;
    private boolean open = true;
    private boolean disabled;
    private SoapUIScriptEngine afterLoadScriptEngine;
    private SoapUIScriptEngine beforeSaveScriptEngine;
    private PropertyExpansionContext context = new DefaultPropertyExpansionContext(this);
    private String projectPassword = null;
    private String hermesConfig;
    private boolean wrongPasswordSupplied;
    private ImageIcon closedEncyptedIcon;
    private SoapUIScriptEngine afterRunScriptEngine;
    private SoapUIScriptEngine beforeRunScriptEngine;
    private Set<ProjectRunListener> runListeners = new HashSet<ProjectRunListener>();
    private Environment environment;

    public WsdlProject() throws XmlException, IOException, SoapUIException {
        this((WorkspaceImpl)null);
    }

    public WsdlProject(String path) throws XmlException, IOException, SoapUIException {
        this(path, (WorkspaceImpl)null);
    }

    public WsdlProject(String projectFile, String projectPassword) {
        this(projectFile, null, true, null, projectPassword);
    }

    public WsdlProject(WorkspaceImpl workspace) {
        this((String)null, workspace);
    }

    public WsdlProject(String path, WorkspaceImpl workspace) {
        this(path, workspace, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsdlProject(String path, WorkspaceImpl workspace, boolean open, String tempName, String projectPassword) {
        super(null, workspace, ICON_NAME);
        this.workspace = workspace;
        this.path = path;
        this.projectPassword = projectPassword;
        this.endpointSupport = new EndpointSupport();
        this.addProjectListeners();
        try {
            if (path != null && open) {
                File file = new File(path.trim());
                if (file.exists()) {
                    try {
                        this.loadProject(file.toURI().toURL());
                        this.lastModified = file.lastModified();
                    }
                    catch (MalformedURLException e) {
                        SoapUI.logError(e);
                        this.disabled = true;
                    }
                } else {
                    try {
                        if (!PathUtils.isHttpPath(path)) {
                            SoapUI.log.info((Object)("File [" + file.getAbsolutePath() + "] does not exist, trying URL instead"));
                        }
                        this.remote = true;
                        this.loadProject(new URL(path));
                    }
                    catch (MalformedURLException e) {
                        SoapUI.logError(e);
                        this.disabled = true;
                    }
                }
            }
        }
        catch (SoapUIException e) {
            SoapUI.logError(e);
            this.disabled = true;
        }
        finally {
            this.initProjectIcons();
            if (this.projectDocument == null) {
                this.createEmptyProjectConfiguration(path, tempName);
            }
            if (this.getSettings() != null) {
                this.setProjectRoot(path);
            }
            this.finalizeProjectLoading(open);
        }
    }

    public WsdlProject(InputStream inputStream, WorkspaceImpl workspace) {
        super(null, workspace, ICON_NAME);
        this.workspace = workspace;
        this.open = true;
        this.endpointSupport = new EndpointSupport();
        this.projectPassword = null;
        this.addProjectListeners();
        this.loadProject(inputStream);
        if (this.projectDocument == null) {
            this.createEmptyProjectConfiguration(null, null);
        }
        this.lastModified = System.currentTimeMillis();
        this.initProjectIcons();
        this.finalizeProjectLoading(this.open);
    }

    private static void normalizeLineBreak(File target, File tmpFile) throws IOException {
        String line;
        FileReader fr = new FileReader(tmpFile);
        BufferedReader in = new BufferedReader(fr);
        FileWriter fw = new FileWriter(target);
        BufferedWriter out = new BufferedWriter(fw);
        while ((line = in.readLine()) != null) {
            out.write(line);
            out.newLine();
            out.flush();
        }
        out.close();
        fw.close();
        in.close();
        fr.close();
    }

    public boolean isRemote() {
        return this.remote;
    }

    public EndpointSupport getEndpointSupport() {
        return this.endpointSupport;
    }

    public void loadProject(URL file) throws SoapUIException {
        try {
            UISupport.setHourglassCursor();
            UrlWsdlLoader loader = new UrlWsdlLoader(file.toString(), this);
            loader.setUseWorker(false);
            InputStream inputStream = loader.load();
            this.loadProjectFromInputStream(inputStream);
            log.info((Object)("Loaded project from [" + file.toString() + "]"));
        }
        catch (Exception e) {
            XmlException xe;
            XmlError error;
            if (e instanceof XmlException && (error = (xe = (XmlException)((Object)e)).getError()) != null) {
                System.err.println("Error at line " + error.getLine() + ", column " + error.getColumn());
            }
            if (e instanceof RestRequestConverter.RestConversionException) {
                log.error((Object)"Project file needs to be updated manually, please reload the project.");
                throw new SoapUIException("Failed to load project from file [" + file.toString() + "]", e);
            }
            e.printStackTrace();
            throw new SoapUIException("Failed to load project from file [" + file.toString() + "]", e);
        }
        finally {
            UISupport.resetCursor();
        }
    }

    public void loadProject(InputStream inputStream) {
        UISupport.setHourglassCursor();
        try {
            this.loadProjectFromInputStream(inputStream);
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        finally {
            UISupport.resetCursor();
        }
    }

    public SoapuiProjectDocumentConfig loadProjectFromInputStream(InputStream inputStream) throws XmlException, IOException, GeneralSecurityException {
        this.projectDocument = SoapuiProjectDocumentConfig.Factory.parse(inputStream);
        inputStream.close();
        this.encryptionStatus = this.checkForEncodedData(this.projectDocument.getSoapuiProject());
        this.setConfig(this.projectDocument.getSoapuiProject());
        if (!this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS)) {
            this.removeDefinitionCaches(this.projectDocument);
        }
        try {
            int majorVersion = Integer.parseInt(this.projectDocument.getSoapuiProject().getSoapuiVersion().split("\\.")[0]);
            if (majorVersion > Integer.parseInt(SoapUI.SOAPUI_VERSION.split("\\.")[0])) {
                log.warn((Object)("Project '" + this.projectDocument.getSoapuiProject().getName() + "' is from a newer version (" + this.projectDocument.getSoapuiProject().getSoapuiVersion() + ") of SoapUI than this (" + SoapUI.SOAPUI_VERSION + ") and parts of it may be incompatible or incorrect. Saving this project with this version of SoapUI may cause it to function differently."));
            }
        }
        catch (Exception majorVersion) {
            // empty catch block
        }
        if (!((ProjectConfig)this.getConfig()).isSetProperties()) {
            ((ProjectConfig)this.getConfig()).addNewProperties();
        }
        this.setPropertiesConfig(((ProjectConfig)this.getConfig()).getProperties());
        List<InterfaceConfig> interfaceConfigs = ((ProjectConfig)this.getConfig()).getInterfaceList();
        for (InterfaceConfig interfaceConfig : interfaceConfigs) {
            AbstractInterface<?> abstractInterface = InterfaceFactoryRegistry.build(this, interfaceConfig);
            this.interfaces.add(abstractInterface);
        }
        List<TestSuiteConfig> testSuiteConfigs = ((ProjectConfig)this.getConfig()).getTestSuiteList();
        for (TestSuiteConfig testSuiteConfig : testSuiteConfigs) {
            this.testSuites.add(this.buildTestSuite(testSuiteConfig));
        }
        List<MockServiceConfig> list = ((ProjectConfig)this.getConfig()).getMockServiceList();
        for (MockServiceConfig config : list) {
            this.addWsdlMockService(new WsdlMockService(this, config));
        }
        List<RESTMockServiceConfig> list2 = ((ProjectConfig)this.getConfig()).getRestMockServiceList();
        for (RESTMockServiceConfig config : list2) {
            this.addRestMockService(new RestMockService(this, config));
        }
        if (!((ProjectConfig)this.getConfig()).isSetWssContainer()) {
            ((ProjectConfig)this.getConfig()).addNewWssContainer();
        }
        this.wssContainer = new DefaultWssContainer(this, ((ProjectConfig)this.getConfig()).getWssContainer());
        if (!((ProjectConfig)this.getConfig()).isSetOAuth2ProfileContainer()) {
            ((ProjectConfig)this.getConfig()).addNewOAuth2ProfileContainer();
        }
        this.oAuth2ProfileContainer = new DefaultOAuth2ProfileContainer(this, ((ProjectConfig)this.getConfig()).getOAuth2ProfileContainer());
        if (!((ProjectConfig)this.getConfig()).isSetOAuth1ProfileContainer()) {
            ((ProjectConfig)this.getConfig()).addNewOAuth1ProfileContainer();
        }
        this.oAuth1ProfileContainer = new OAuth1ProfileContainer(this, ((ProjectConfig)this.getConfig()).getOAuth1ProfileContainer());
        this.endpointStrategy.init(this);
        this.setActiveEnvironment(DefaultEnvironment.getInstance());
        if (!((ProjectConfig)this.getConfig()).isSetAbortOnError()) {
            ((ProjectConfig)this.getConfig()).setAbortOnError(false);
        }
        if (!((ProjectConfig)this.getConfig()).isSetRunType()) {
            ((ProjectConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.SEQUENTIAL);
        }
        this.afterLoad();
        return this.projectDocument;
    }

    public Environment getActiveEnvironment() {
        return this.environment;
    }

    public void setActiveEnvironment(Environment environment) {
        if (!environment.equals(this.environment)) {
            this.environment = environment;
            ((ProjectConfig)this.getConfig()).setActiveEnvironment(environment.getName());
            this.fireEnvironmentSwitched(environment);
        }
    }

    public boolean isEnvironmentMode() {
        return false;
    }

    protected WsdlTestSuite buildTestSuite(TestSuiteConfig config) {
        return new WsdlTestSuite(this, config);
    }

    public boolean isWrongPasswordSupplied() {
        return this.wrongPasswordSupplied;
    }

    protected ProjectEncryptionStatus checkForEncodedData(ProjectConfig soapuiProject) throws IOException, GeneralSecurityException {
        byte[] data;
        byte[] encryptedContent = soapuiProject.getEncryptedContent();
        if (encryptedContent == null || encryptedContent.length == 0) {
            return ProjectEncryptionStatus.NOT_ENCRYPTED;
        }
        String projectPassword = this.workspace != null ? this.workspace.getProjectPassword(soapuiProject.getName()) : this.projectPassword;
        char[] password = projectPassword == null ? UISupport.promptPassword("Enter Password:", soapuiProject.getName()) : projectPassword.toCharArray();
        if (password == null) {
            return ProjectEncryptionStatus.ENCRYPTED_BAD_OR_NO_PASSWORD;
        }
        try {
            String encryptionAlgorithm = soapuiProject.getEncryptedContentAlgorithm();
            data = OpenSSL.decrypt((String)(StringUtils.isNullOrEmpty(encryptionAlgorithm) ? "des3" : encryptionAlgorithm), (char[])password, (byte[])encryptedContent);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return ProjectEncryptionStatus.ENCRYPTED_BAD_OR_NO_PASSWORD;
        }
        String decryptedData = new String(data, "UTF-8");
        if (data != null) {
            if (decryptedData.length() > 0) {
                try {
                    this.projectDocument.getSoapuiProject().set(XmlUtils.createXmlObject(decryptedData));
                    this.wrongPasswordSupplied = false;
                }
                catch (XmlException e) {
                    UISupport.showErrorMessage("Wrong password. Project needs to be reloaded.");
                    this.wrongPasswordSupplied = true;
                    this.getWorkspace().clearProjectPassword(soapuiProject.getName());
                    return ProjectEncryptionStatus.ENCRYPTED_BAD_OR_NO_PASSWORD;
                }
            }
        } else {
            UISupport.showErrorMessage("Wrong project password");
            this.wrongPasswordSupplied = true;
            this.getWorkspace().clearProjectPassword(soapuiProject.getName());
            return ProjectEncryptionStatus.ENCRYPTED_BAD_OR_NO_PASSWORD;
        }
        this.projectDocument.getSoapuiProject().setEncryptedContent(null);
        return ProjectEncryptionStatus.ENCRYPTED_GOOD_PASSWORD;
    }

    @Override
    public void afterLoad() {
        super.afterLoad();
        try {
            ProjectListener[] a;
            for (ProjectListener listener : a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
                listener.afterLoad(this);
            }
            this.runAfterLoadScript();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    protected void setProjectRoot(String path) {
        int ix;
        if (path != null && this.projectDocument != null && (ix = path.lastIndexOf(File.separatorChar)) > 0) {
            this.getSettings().setString(ProjectSettings.PROJECT_ROOT, path.substring(0, ix));
        }
    }

    @Override
    public String getResourceRoot() {
        if (!((ProjectConfig)this.getConfig()).isSetResourceRoot()) {
            ((ProjectConfig)this.getConfig()).setResourceRoot("");
        }
        return ((ProjectConfig)this.getConfig()).getResourceRoot();
    }

    public void setResourceRoot(String resourceRoot) {
        String old = this.getResourceRoot();
        ((ProjectConfig)this.getConfig()).setResourceRoot(resourceRoot);
        this.notifyPropertyChanged(RESOURCE_ROOT_PROPERTY, old, resourceRoot);
    }

    private void initProjectIcons() {
        this.closedIcon = UISupport.createImageIcon("/closed_project.png");
        this.remoteIcon = UISupport.createImageIcon("/remote_project.png");
        this.disabledIcon = UISupport.createImageIcon("/disabled_project.png");
        this.openEncyptedIcon = UISupport.createImageIcon("/encrypted_project.png");
        this.closedEncyptedIcon = UISupport.createImageIcon("/disabled_encrypted_project.png");
    }

    private void createEmptyProjectConfiguration(String path, String tempName) {
        this.projectDocument = SoapuiProjectDocumentConfig.Factory.newInstance();
        this.setConfig(this.projectDocument.addNewSoapuiProject());
        if (tempName != null || path != null) {
            ((ProjectConfig)this.getConfig()).setName(StringUtils.isNullOrEmpty(tempName) ? this.getNameFromPath() : tempName);
        }
        this.setPropertiesConfig(((ProjectConfig)this.getConfig()).addNewProperties());
        this.wssContainer = new DefaultWssContainer(this, ((ProjectConfig)this.getConfig()).addNewWssContainer());
        this.oAuth2ProfileContainer = new DefaultOAuth2ProfileContainer(this, ((ProjectConfig)this.getConfig()).addNewOAuth2ProfileContainer());
        this.oAuth1ProfileContainer = new OAuth1ProfileContainer(this, ((ProjectConfig)this.getConfig()).addNewOAuth1ProfileContainer());
    }

    private void finalizeProjectLoading(boolean open) {
        if (this.getConfig() != null) {
            this.endpointStrategy.init(this);
        }
        if (this.getConfig() != null && this.environment == null) {
            this.setActiveEnvironment(DefaultEnvironment.getInstance());
        }
        this.open = open && !this.disabled && this.encryptionStatus != ProjectEncryptionStatus.ENCRYPTED_BAD_OR_NO_PASSWORD;
        this.addPropertyChangeListener(this);
    }

    @Override
    public ImageIcon getIcon() {
        if (this.isDisabled()) {
            return this.disabledIcon;
        }
        if (this.getEncryptionStatus() != ProjectEncryptionStatus.NOT_ENCRYPTED) {
            if (this.isOpen()) {
                return this.openEncyptedIcon;
            }
            return this.closedEncyptedIcon;
        }
        if (!this.isOpen()) {
            return this.closedIcon;
        }
        if (this.isRemote()) {
            return this.remoteIcon;
        }
        return super.getIcon();
    }

    private String getNameFromPath() {
        int ix = this.path.lastIndexOf(this.isRemote() ? 47 : (int)File.separatorChar);
        return ix == -1 ? this.path : this.path.substring(ix + 1);
    }

    private void addProjectListeners() {
        for (ProjectListener projectListener : SoapUI.getListenerRegistry().getListeners(ProjectListener.class)) {
            this.addProjectListener(projectListener);
        }
        for (ProjectRunListener projectRunListener : SoapUI.getListenerRegistry().getListeners(ProjectRunListener.class)) {
            this.addProjectRunListener(projectRunListener);
        }
    }

    @Override
    public String getDescription() {
        if (this.isOpen()) {
            return super.getDescription();
        }
        String name = this.getName();
        name = this.isDisabled() ? name + " - disabled [" + this.getPath() + "]" : name + " - closed [" + this.getPath() + "]";
        return name;
    }

    @Override
    public WorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    @Override
    public AbstractInterface<?> getInterfaceAt(int index) {
        return this.interfaces.get(index);
    }

    @Override
    public AbstractInterface<?> getInterfaceByName(String interfaceName) {
        return (AbstractInterface)this.getWsdlModelItemByName(this.interfaces, interfaceName);
    }

    public AbstractInterface<?> getInterfaceByTechnicalId(String technicalId) {
        for (int c = 0; c < this.getInterfaceCount(); ++c) {
            if (!this.getInterfaceAt(c).getTechnicalId().equals(technicalId)) continue;
            return this.getInterfaceAt(c);
        }
        return null;
    }

    @Override
    public int getInterfaceCount() {
        return this.interfaces.size();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public SaveStatus save() throws IOException {
        return this.save(null);
    }

    public SaveStatus save(String folder) throws IOException {
        SaveStatus saveStatus;
        if (!this.isOpen() || this.isDisabled() || this.isRemote()) {
            return SaveStatus.SUCCESS;
        }
        File projectFile = null;
        if (!this.hasBeenSavedBefore()) {
            String tempPath = this.createProjectFileName();
            if (folder != null) {
                tempPath = folder + File.separatorChar + tempPath;
            }
            while (projectFile == null || projectFile.exists() && !UISupport.confirm("File [" + projectFile.getName() + "] exists, overwrite?", "Overwrite File?")) {
                projectFile = UISupport.getFileDialogs().saveAs(this, "Save project " + this.getName(), XML_EXTENSION, XML_FILE_TYPE, new File(tempPath));
                if (projectFile != null) continue;
                return SaveStatus.CANCELLED;
            }
        }
        if (projectFile == null) {
            projectFile = this.createFile(this.path);
        }
        while (projectFile.exists() && !projectFile.canWrite()) {
            Boolean confirm = UISupport.confirmOrCancel("Project file [" + projectFile.getAbsolutePath() + "] can not be written to, save to new file?", "Save Project");
            if (confirm == null) {
                return SaveStatus.CANCELLED;
            }
            if (!confirm.booleanValue()) {
                return SaveStatus.DONT_SAVE;
            }
            projectFile = UISupport.getFileDialogs().saveAs(this, "Save project " + this.getName(), XML_EXTENSION, XML_FILE_TYPE, projectFile);
            if (projectFile != null) continue;
            return SaveStatus.CANCELLED;
        }
        if (this.projectFileModified(projectFile) && !UISupport.confirm("Project file for [" + this.getName() + "] has been modified externally, overwrite?", "Save Project")) {
            return SaveStatus.DONT_SAVE;
        }
        if (this.shouldCreateBackup(projectFile)) {
            this.createBackup(projectFile);
        }
        if ((saveStatus = this.saveIn(projectFile)) == SaveStatus.SUCCESS) {
            this.path = projectFile.getAbsolutePath();
        }
        return saveStatus;
    }

    protected boolean shouldCreateBackup(File projectFile) {
        return projectFile.exists() && this.getSettings().getBoolean(UISettings.CREATE_BACKUP);
    }

    protected String createProjectFileName() {
        return StringUtils.createFileName2(this.getName(), '-') + "-soapui-project.xml";
    }

    File createFile(String filePath) {
        return new File(filePath);
    }

    protected boolean projectFileModified(File projectFile) {
        return projectFile.exists() && this.lastModified != 0L && this.lastModified < projectFile.lastModified();
    }

    private boolean hasBeenSavedBefore() {
        return this.path != null;
    }

    public SaveStatus saveBackup() throws IOException {
        File projectFile = this.hasBeenSavedBefore() || this.isRemote() ? new File(StringUtils.createFileName2(this.getName(), '-') + "-soapui-project.xml") : new File(this.path);
        File backupFile = this.getBackupFile(projectFile);
        return this.saveIn(backupFile);
    }

    public SaveStatus saveIn(File projectFile) throws IOException {
        long size;
        this.beforeSave();
        SoapuiProjectDocumentConfig projectDocument = (SoapuiProjectDocumentConfig)this.projectDocument.copy();
        if (!this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS)) {
            this.removeDefinitionCaches(projectDocument);
        }
        this.removeProjectRoot(projectDocument);
        if (this.hasBeenSuccessfullyDecrypted(projectDocument) && this.hasEncryptionPassword()) {
            ProjectConfig encryptedProjectConfig = this.encrypt(projectDocument);
            projectDocument.setSoapuiProject(encryptedProjectConfig);
        }
        XmlOptions options = new XmlOptions();
        if (SoapUI.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_PROJECT_FILES)) {
            options.setSavePrettyPrint();
        }
        projectDocument.getSoapuiProject().setSoapuiVersion(SoapUI.SOAPUI_VERSION);
        try {
            File tempFile = File.createTempFile("project-temp-", XML_EXTENSION, projectFile.getParentFile());
            FileOutputStream tempOut = new FileOutputStream(tempFile);
            projectDocument.save(tempOut, options);
            tempOut.close();
            if (this.getSettings().getBoolean(UISettings.LINEBREAK)) {
                WsdlProject.normalizeLineBreak(projectFile, tempFile);
            } else {
                FileOutputStream projectOut = new FileOutputStream(projectFile);
                projectDocument.save(projectOut, options);
                projectOut.close();
            }
            if (!tempFile.delete()) {
                SoapUI.getErrorLog().warn((Object)("Failed to delete temporary project file; " + tempFile.getAbsolutePath()));
                tempFile.deleteOnExit();
            }
            size = projectFile.length();
        }
        catch (Throwable t) {
            SoapUI.logError(t);
            UISupport.showErrorMessage("Failed to save project [" + this.getName() + "]: " + t.toString());
            return SaveStatus.FAILED;
        }
        this.lastModified = projectFile.lastModified();
        log.info((Object)("Saved project [" + this.getName() + "] to [" + projectFile.getAbsolutePath() + " - " + size + " bytes"));
        this.setProjectRoot(this.getPath());
        return SaveStatus.SUCCESS;
    }

    private boolean hasEncryptionPassword() {
        String passwordForEncryption = this.getSettings().getString(ProjectSettings.SHADOW_PASSWORD, null);
        return StringUtils.hasContent(passwordForEncryption);
    }

    private boolean hasBeenSuccessfullyDecrypted(SoapuiProjectDocumentConfig projectDocument) {
        return projectDocument.getSoapuiProject().getEncryptedContent() == null;
    }

    private void removeProjectRoot(SoapuiProjectDocumentConfig projectDocument) {
        XmlBeansSettingsImpl tempSettings = new XmlBeansSettingsImpl(this, null, projectDocument.getSoapuiProject().getSettings());
        tempSettings.clearSetting(ProjectSettings.PROJECT_ROOT);
    }

    private ProjectConfig encrypt(SoapuiProjectDocumentConfig projectDocument) throws IOException {
        String passwordForEncryption = this.getSettings().getString(ProjectSettings.SHADOW_PASSWORD, null);
        if (this.hasEncryptionPassword()) {
            try {
                String data = ((ProjectConfig)this.getConfig()).xmlText();
                String encryptionAlgorithm = "des3";
                byte[] encrypted = OpenSSL.encrypt((String)encryptionAlgorithm, (char[])passwordForEncryption.toCharArray(), (byte[])data.getBytes());
                ProjectConfig newProjectConfig = ProjectConfig.Factory.newInstance();
                ProjectConfig soapuiProject = projectDocument.getSoapuiProject();
                newProjectConfig.setName(soapuiProject.getName());
                newProjectConfig.setEncryptedContent(encrypted);
                newProjectConfig.setEncryptedContentAlgorithm(encryptionAlgorithm);
                return newProjectConfig;
            }
            catch (GeneralSecurityException e) {
                UISupport.showErrorMessage("Encryption Error");
            }
        }
        return projectDocument.getSoapuiProject();
    }

    @Override
    public void beforeSave() {
        try {
            ProjectListener[] listeners;
            for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
                listener.beforeSave(this);
            }
            this.runBeforeSaveScript();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        for (AbstractInterface<?> abstractInterface : this.interfaces) {
            abstractInterface.beforeSave();
        }
        for (WsdlTestSuite wsdlTestSuite : this.testSuites) {
            wsdlTestSuite.beforeSave();
        }
        for (WsdlMockService wsdlMockService : this.mockServices) {
            wsdlMockService.beforeSave();
        }
        for (RestMockService restMockService : this.restMockServices) {
            restMockService.beforeSave();
        }
        this.endpointStrategy.onSave();
    }

    protected void createBackup(File projectFile) throws IOException {
        File backupFile = this.getBackupFile(projectFile);
        log.info((Object)("Backing up [" + projectFile + "] to [" + backupFile + "]"));
        Tools.copyFile(projectFile, backupFile, true);
    }

    protected File getBackupFile(File projectFile) {
        String backupFolderName = this.getSettings().getString(UISettings.BACKUP_FOLDER, "");
        File backupFolder = new File(backupFolderName);
        if (!backupFolder.isAbsolute()) {
            backupFolder = new File(projectFile.getParentFile(), backupFolderName);
        }
        if (!backupFolder.exists()) {
            backupFolder.mkdirs();
        }
        return new File(backupFolder, projectFile.getName() + ".backup");
    }

    protected void removeDefinitionCaches(SoapuiProjectDocumentConfig config) {
        for (InterfaceConfig ifaceConfig : config.getSoapuiProject().getInterfaceList()) {
            if (!ifaceConfig.isSetDefinitionCache()) continue;
            log.info((Object)("Removing definition cache from interface [" + ifaceConfig.getName() + "]"));
            ifaceConfig.unsetDefinitionCache();
        }
    }

    public AbstractInterface<?> addNewInterface(String name, String type) {
        AbstractInterface<?> iface = InterfaceFactoryRegistry.createNew(this, type, name);
        if (iface != null) {
            iface.getConfig().setType(type);
            this.interfaces.add(iface);
            this.fireInterfaceAdded(iface);
        }
        return iface;
    }

    @Override
    public void addProjectListener(ProjectListener listener) {
        this.projectListeners.add(listener);
    }

    @Override
    public void removeProjectListener(ProjectListener listener) {
        this.projectListeners.remove(listener);
    }

    public void fireInterfaceAdded(AbstractInterface<?> iface) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.interfaceAdded(iface);
        }
    }

    public void fireInterfaceRemoved(AbstractInterface<?> iface) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.interfaceRemoved(iface);
        }
    }

    public void fireInterfaceUpdated(AbstractInterface<?> iface) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.interfaceUpdated(iface);
        }
    }

    public void fireTestSuiteAdded(WsdlTestSuite testSuite) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.testSuiteAdded(testSuite);
        }
    }

    private void fireTestSuiteMoved(WsdlTestSuite testCase, int ix, int offset) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.testSuiteMoved(testCase, ix, offset);
        }
    }

    public void fireTestSuiteRemoved(WsdlTestSuite testSuite) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.testSuiteRemoved(testSuite);
        }
    }

    public void fireMockServiceAdded(MockService mockService) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.mockServiceAdded(mockService);
        }
    }

    public void fireMockServiceRemoved(MockService mockService) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.mockServiceRemoved(mockService);
        }
    }

    public void fireEnvironmentAdded(Environment env) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.environmentAdded(env);
        }
    }

    private void fireEnvironmentSwitched(Environment environment) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.environmentSwitched(environment);
        }
    }

    public void fireEnvironmentRemoved(Environment env, int index) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.environmentRemoved(env, index);
        }
    }

    public void fireEnvironmentRenamed(Environment env, String oldName, String newName) {
        ProjectListener[] listeners;
        for (ProjectListener listener : listeners = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()])) {
            listener.environmentRenamed(env, oldName, newName);
        }
    }

    public void removeInterface(AbstractInterface<?> iface) {
        int ix = this.interfaces.indexOf(iface);
        this.interfaces.remove(ix);
        try {
            this.fireInterfaceRemoved(iface);
        }
        finally {
            iface.release();
            ((ProjectConfig)this.getConfig()).removeInterface(ix);
        }
    }

    public void removeTestSuite(WsdlTestSuite testSuite) {
        int ix = this.testSuites.indexOf(testSuite);
        this.testSuites.remove(ix);
        try {
            this.fireTestSuiteRemoved(testSuite);
        }
        finally {
            testSuite.release();
            ((ProjectConfig)this.getConfig()).removeTestSuite(ix);
        }
    }

    public void firePropertyValueChanged(Property property) {
        EnvironmentListener[] listeners;
        for (EnvironmentListener listener : listeners = this.environmentListeners.toArray(new EnvironmentListener[this.environmentListeners.size()])) {
            listener.propertyValueChanged(property);
        }
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public int getTestSuiteCount() {
        return this.testSuites.size();
    }

    @Override
    public WsdlTestSuite getTestSuiteAt(int index) {
        return this.testSuites.get(index);
    }

    @Override
    public WsdlTestSuite getTestSuiteByName(String testSuiteName) {
        return (WsdlTestSuite)this.getWsdlModelItemByName(this.testSuites, testSuiteName);
    }

    @Override
    public TestSuite getTestSuiteById(UUID testSuiteId) {
        return null;
    }

    @Override
    public WsdlTestSuite addNewTestSuite(String name) {
        WsdlTestSuite testSuite = this.buildTestSuite(((ProjectConfig)this.getConfig()).addNewTestSuite());
        testSuite.setName(name);
        this.testSuites.add(testSuite);
        this.fireTestSuiteAdded(testSuite);
        return testSuite;
    }

    public boolean isCacheDefinitions() {
        return this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS);
    }

    public void setCacheDefinitions(boolean cacheDefinitions) {
        this.getSettings().setBoolean(WsdlSettings.CACHE_WSDLS, cacheDefinitions);
    }

    public SaveStatus saveAs(String fileName) throws IOException {
        if (!this.isOpen() || this.isDisabled()) {
            return SaveStatus.FAILED;
        }
        String oldPath = this.path;
        this.path = fileName;
        SaveStatus result = this.save();
        if (result == SaveStatus.SUCCESS) {
            this.remote = false;
        } else {
            this.path = oldPath;
        }
        this.setProjectRoot(this.path);
        return result;
    }

    @Override
    public void release() {
        super.release();
        if (this.isOpen()) {
            this.endpointStrategy.release();
            for (WsdlTestSuite wsdlTestSuite : this.testSuites) {
                wsdlTestSuite.release();
            }
            for (WsdlMockService wsdlMockService : this.mockServices) {
                wsdlMockService.release();
            }
            for (RestMockService restMockService : this.restMockServices) {
                restMockService.release();
            }
            for (AbstractInterface abstractInterface : this.interfaces) {
                abstractInterface.release();
            }
            if (this.wssContainer != null) {
                this.wssContainer.release();
                this.wssContainer = null;
            }
            if (this.oAuth2ProfileContainer != null) {
                this.oAuth2ProfileContainer.release();
                this.oAuth2ProfileContainer = null;
            }
        }
        this.projectListeners.clear();
        this.environmentListeners.clear();
        if (this.afterLoadScriptEngine != null) {
            this.afterLoadScriptEngine.release();
        }
        if (this.beforeSaveScriptEngine != null) {
            this.beforeSaveScriptEngine.release();
        }
    }

    @Override
    public WsdlMockService addNewMockService(String name) {
        WsdlMockService mockService = new WsdlMockService(this, ((ProjectConfig)this.getConfig()).addNewMockService());
        mockService.setName(name);
        this.addWsdlMockService(mockService);
        this.fireMockServiceAdded(mockService);
        return mockService;
    }

    public void addWsdlMockService(WsdlMockService mockService) {
        this.mockServices.add(mockService);
    }

    @Override
    public RestMockService addNewRestMockService(String name) {
        RestMockService mockService = new RestMockService(this, ((ProjectConfig)this.getConfig()).addNewRestMockService());
        mockService.setName(name);
        this.addRestMockService(mockService);
        this.fireMockServiceAdded(mockService);
        return mockService;
    }

    public void addRestMockService(RestMockService mockService) {
        if (!mockService.getParent().equals(this)) {
            throw new IllegalStateException("In Illegal state");
        }
        this.restMockServices.add(mockService);
    }

    @Override
    public WsdlMockService getMockServiceAt(int index) {
        return this.mockServices.get(index);
    }

    @Override
    public WsdlMockService getMockServiceByName(String mockServiceName) {
        return (WsdlMockService)this.getWsdlModelItemByName(this.mockServices, mockServiceName);
    }

    @Override
    public int getMockServiceCount() {
        return this.mockServices.size();
    }

    @Override
    public RestMockService getRestMockServiceAt(int index) {
        return this.restMockServices.get(index);
    }

    @Override
    public RestMockService getRestMockServiceByName(String mockServiceName) {
        return (RestMockService)this.getWsdlModelItemByName(this.restMockServices, mockServiceName);
    }

    @Override
    public int getRestMockServiceCount() {
        return this.restMockServices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMockService(MockService mockService) {
        boolean isRestMockService;
        int ix = this.mockServices.indexOf(mockService);
        boolean bl = isRestMockService = ix == -1;
        if (isRestMockService) {
            ix = this.restMockServices.indexOf(mockService);
        }
        this.removeMockServiceFromList(ix, isRestMockService);
        try {
            this.fireMockServiceRemoved(mockService);
        }
        finally {
            mockService.release();
            this.removeMockServiceFromConfig(ix, isRestMockService);
        }
    }

    private void removeMockServiceFromList(int ix, boolean isRestMockService) {
        if (isRestMockService) {
            this.restMockServices.remove(ix);
        } else {
            this.mockServices.remove(ix);
        }
    }

    private void removeMockServiceFromConfig(int ix, boolean isRestMockService) {
        if (isRestMockService) {
            ((ProjectConfig)this.getConfig()).removeRestMockService(ix);
        } else {
            ((ProjectConfig)this.getConfig()).removeMockService(ix);
        }
    }

    @Override
    public List<TestSuite> getTestSuiteList() {
        return new ArrayList<TestSuite>(this.testSuites);
    }

    @Override
    public List<WsdlMockService> getMockServiceList() {
        return new ArrayList<WsdlMockService>(this.mockServices);
    }

    @Override
    public List<RestMockService> getRestMockServiceList() {
        return this.restMockServices;
    }

    @Override
    public List<Interface> getInterfaceList() {
        return new ArrayList<Interface>(this.interfaces);
    }

    public Map<String, Interface> getInterfaces() {
        HashMap<String, Interface> result = new HashMap<String, Interface>();
        for (Interface interface_ : this.interfaces) {
            result.put(interface_.getName(), interface_);
        }
        return result;
    }

    public Map<String, TestSuite> getTestSuites() {
        HashMap<String, TestSuite> result = new HashMap<String, TestSuite>();
        for (TestSuite testSuite : this.testSuites) {
            result.put(testSuite.getName(), testSuite);
        }
        return result;
    }

    public Map<String, MockService> getMockServices() {
        HashMap<String, MockService> result = new HashMap<String, MockService>();
        for (MockService mockService : this.mockServices) {
            result.put(mockService.getName(), mockService);
        }
        return result;
    }

    public void reload() throws SoapUIException {
        this.reload(this.path);
    }

    public void reload(String path) throws SoapUIException {
        this.path = path;
        this.getWorkspace().reloadProject(this);
    }

    @Override
    public boolean hasNature(String natureId) {
        XmlBeansSettingsImpl projectSettings = this.getSettings();
        String projectNature = projectSettings.getString(ProjectSettings.PROJECT_NATURE, null);
        return natureId.equals(projectNature);
    }

    public AbstractInterface<?> importInterface(AbstractInterface<?> iface, boolean importEndpoints, boolean createCopy) {
        iface.beforeSave();
        InterfaceConfig ifaceConfig = (InterfaceConfig)iface.getConfig().copy();
        ifaceConfig = (InterfaceConfig)((ProjectConfig)this.getConfig()).addNewInterface().set(ifaceConfig);
        AbstractInterface<?> imported = InterfaceFactoryRegistry.build(this, ifaceConfig);
        this.interfaces.add(imported);
        if (iface.getProject() != this && importEndpoints) {
            this.endpointStrategy.importEndpoints(iface);
        }
        if (createCopy) {
            ModelSupport.createNewIds(imported);
        }
        imported.afterLoad();
        this.fireInterfaceAdded(imported);
        return imported;
    }

    public WsdlTestSuite importTestSuite(WsdlTestSuite testSuite, String name, int index, boolean createCopy, String description) {
        testSuite.beforeSave();
        TestSuiteConfig testSuiteConfig = index == -1 ? (TestSuiteConfig)((ProjectConfig)this.getConfig()).addNewTestSuite().set(((TestSuiteConfig)testSuite.getConfig()).copy()) : (TestSuiteConfig)((ProjectConfig)this.getConfig()).insertNewTestSuite(index).set(((TestSuiteConfig)testSuite.getConfig()).copy());
        testSuiteConfig.setName(name);
        if (createCopy) {
            for (TestCaseConfig testCaseConfig : testSuiteConfig.getTestCaseList()) {
                testCaseConfig.setSecurityTestArray(new SecurityTestConfig[0]);
            }
        }
        WsdlTestSuite oldTestSuite = testSuite;
        testSuite = this.buildTestSuite(testSuiteConfig);
        if (description != null) {
            testSuite.setDescription(description);
        }
        if (index == -1) {
            this.testSuites.add(testSuite);
        } else {
            this.testSuites.add(index, testSuite);
        }
        if (createCopy) {
            ModelSupport.createNewIds(testSuite);
        }
        testSuite.afterLoad();
        if (createCopy) {
            testSuite.afterCopy(oldTestSuite);
        }
        this.fireTestSuiteAdded(testSuite);
        this.resolveImportedTestSuite(testSuite);
        return testSuite;
    }

    public WsdlMockService importMockService(WsdlMockService mockService, String name, boolean createCopy, String description) {
        mockService.beforeSave();
        MockServiceConfig mockServiceConfig = (MockServiceConfig)((ProjectConfig)this.getConfig()).addNewMockService().set(((MockServiceConfig)mockService.getConfig()).copy());
        mockServiceConfig.setName(name);
        if (mockServiceConfig.isSetId() && createCopy) {
            mockServiceConfig.unsetId();
        }
        mockService = new WsdlMockService(this, mockServiceConfig);
        mockService.setDescription(description);
        this.addWsdlMockService(mockService);
        if (createCopy) {
            ModelSupport.createNewIds(mockService);
        }
        mockService.afterLoad();
        this.fireMockServiceAdded(mockService);
        return mockService;
    }

    @Override
    public EndpointStrategy getEndpointStrategy() {
        return this.endpointStrategy;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        ArrayList<ModelItem> list = new ArrayList<ModelItem>();
        list.addAll(this.getInterfaceList());
        list.addAll(this.getTestSuiteList());
        list.addAll(this.getMockServiceList());
        list.addAll(this.getRestMockServiceList());
        return list;
    }

    public String getAfterLoadScript() {
        return ((ProjectConfig)this.getConfig()).isSetAfterLoadScript() ? ((ProjectConfig)this.getConfig()).getAfterLoadScript().getStringValue() : null;
    }

    public void setAfterLoadScript(String script) {
        String oldScript = this.getAfterLoadScript();
        if (!((ProjectConfig)this.getConfig()).isSetAfterLoadScript()) {
            ((ProjectConfig)this.getConfig()).addNewAfterLoadScript();
        }
        ((ProjectConfig)this.getConfig()).getAfterLoadScript().setStringValue(script);
        if (this.afterLoadScriptEngine != null) {
            this.afterLoadScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(AFTER_LOAD_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getBeforeSaveScript() {
        return ((ProjectConfig)this.getConfig()).isSetBeforeSaveScript() ? ((ProjectConfig)this.getConfig()).getBeforeSaveScript().getStringValue() : null;
    }

    public void setBeforeSaveScript(String script) {
        String oldScript = this.getBeforeSaveScript();
        if (!((ProjectConfig)this.getConfig()).isSetBeforeSaveScript()) {
            ((ProjectConfig)this.getConfig()).addNewBeforeSaveScript();
        }
        ((ProjectConfig)this.getConfig()).getBeforeSaveScript().setStringValue(script);
        if (this.beforeSaveScriptEngine != null) {
            this.beforeSaveScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(BEFORE_SAVE_SCRIPT_PROPERTY, oldScript, script);
    }

    public Object runAfterLoadScript() throws Exception {
        String script = this.getAfterLoadScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.afterLoadScriptEngine == null) {
            this.afterLoadScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.afterLoadScriptEngine.setScript(script);
        }
        this.afterLoadScriptEngine.setVariable("context", this.context);
        this.afterLoadScriptEngine.setVariable("project", this);
        this.afterLoadScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.afterLoadScriptEngine.run();
    }

    public Object runBeforeSaveScript() throws Exception {
        String script = this.getBeforeSaveScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.beforeSaveScriptEngine == null) {
            this.beforeSaveScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.beforeSaveScriptEngine.setScript(script);
        }
        this.beforeSaveScriptEngine.setVariable("context", this.context);
        this.beforeSaveScriptEngine.setVariable("project", this);
        this.beforeSaveScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.beforeSaveScriptEngine.run();
    }

    public PropertyExpansionContext getContext() {
        return this.context;
    }

    public DefaultWssContainer getWssContainer() {
        return this.wssContainer;
    }

    @Override
    public OAuth2ProfileContainer getOAuth2ProfileContainer() {
        return this.oAuth2ProfileContainer;
    }

    @Override
    public OAuth1ProfileContainer getOAuth1ProfileContainer() {
        return this.oAuth1ProfileContainer;
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.wssContainer.resolve(context);
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(Arrays.asList(this.wssContainer.getPropertyExpansions()));
        result.addAll(Arrays.asList(this.oAuth2ProfileContainer.getPropertyExpansions()));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    protected void addExternalDependencies(List<ExternalDependency> dependencies) {
        super.addExternalDependencies(dependencies);
        this.wssContainer.addExternalDependency(dependencies);
    }

    @Override
    public String getShadowPassword() {
        this.projectPassword = this.getSettings() == null ? this.projectPassword : this.getSettings().getString(ProjectSettings.SHADOW_PASSWORD, null);
        return this.projectPassword;
    }

    @Override
    public void setShadowPassword(String password) {
        String oldPassword = this.getSettings().getString(ProjectSettings.SHADOW_PASSWORD, null);
        this.getSettings().setString(ProjectSettings.SHADOW_PASSWORD, password);
        this.notifyPropertyChanged("projectPassword", oldPassword, password);
    }

    public String getHermesConfig() {
        this.hermesConfig = this.getSettings() == null ? this.hermesConfig : this.resolveHermesConfig();
        return this.hermesConfig;
    }

    public void setHermesConfig(String hermesConfigPath) {
        String oldHermesConfigPath = this.getSettings().getString(ProjectSettings.HERMES_CONFIG, null);
        this.getSettings().setString(ProjectSettings.HERMES_CONFIG, hermesConfigPath);
        this.notifyPropertyChanged("hermesConfig", oldHermesConfigPath, hermesConfigPath);
    }

    private String resolveHermesConfig() {
        String hermesConfigProperty = this.getSettings().getString(ProjectSettings.HERMES_CONFIG, null);
        if (hermesConfigProperty != null && !hermesConfigProperty.equals("")) {
            return hermesConfigProperty;
        }
        if (System.getenv("HERMES_CONFIG") != null) {
            return System.getenv("HERMES_CONFIG");
        }
        return "${#System#user.home}\\.hermes";
    }

    @Override
    public void inspect() {
        if (!this.isOpen()) {
            return;
        }
        byte[] data = this.projectDocument.getSoapuiProject().getEncryptedContent();
        if (data != null && data.length > 0) {
            try {
                this.reload();
            }
            catch (SoapUIException e) {
                e.printStackTrace();
            }
        }
    }

    public ProjectEncryptionStatus getEncryptionStatus() {
        return this.encryptionStatus;
    }

    public ProjectEncryptionStatus setEncryptionStatus(ProjectEncryptionStatus status) {
        this.encryptionStatus = status;
        return this.encryptionStatus;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("projectPassword".equals(evt.getPropertyName())) {
            if (this.encryptionStatus == ProjectEncryptionStatus.NOT_ENCRYPTED && (evt.getOldValue() == null || ((String)evt.getOldValue()).length() == 0)) {
                this.encryptionStatus = ProjectEncryptionStatus.ENCRYPTED_GOOD_PASSWORD;
            }
            if (this.encryptionStatus == ProjectEncryptionStatus.ENCRYPTED_GOOD_PASSWORD && (evt.getNewValue() == null || ((String)evt.getNewValue()).length() == 0)) {
                this.encryptionStatus = ProjectEncryptionStatus.NOT_ENCRYPTED;
            }
            if (SoapUI.getNavigator() != null) {
                SoapUI.getNavigator().repaint();
            }
        }
    }

    public SoapuiProjectDocumentConfig getProjectDocument() {
        return this.projectDocument;
    }

    public int getInterfaceCount(String type) {
        int result = 0;
        for (AbstractInterface<?> iface : this.interfaces) {
            if (!iface.getType().equals(type)) continue;
            ++result;
        }
        return result;
    }

    public List<AbstractInterface<?>> getInterfaces(String type) {
        ArrayList result = new ArrayList();
        for (AbstractInterface<?> iface : this.interfaces) {
            if (!iface.getType().equals(type)) continue;
            result.add(iface);
        }
        return result;
    }

    public void importTestSuite(File file) {
        if (!file.exists()) {
            UISupport.showErrorMessage("Error loading test case ");
            return;
        }
        TestSuiteDocumentConfig newTestSuiteConfig = null;
        WsdlTestSuite oldTestSuite = null;
        try {
            newTestSuiteConfig = TestSuiteDocumentConfig.Factory.parse(file);
            oldTestSuite = this.buildTestSuite(TestSuiteDocumentConfig.Factory.parse(file).getTestSuite());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        if (newTestSuiteConfig == null) {
            UISupport.showErrorMessage("Not valid test case xml");
        } else {
            TestSuiteConfig config = (TestSuiteConfig)this.projectDocument.getSoapuiProject().addNewTestSuite().set(newTestSuiteConfig.getTestSuite());
            WsdlTestSuite testSuite = this.buildTestSuite(config);
            ModelSupport.createNewIds(testSuite);
            testSuite.afterLoad();
            for (int cnt2 = 0; cnt2 < config.getTestCaseList().size(); ++cnt2) {
                TestCaseConfig newTestCase = config.getTestCaseList().get(cnt2);
                TestCaseConfig importTestCaseConfig = newTestSuiteConfig.getTestSuite().getTestCaseList().get(cnt2);
                LinkedHashMap<String, String> oldNewIds = new LinkedHashMap<String, String>();
                for (int cnt = 0; cnt < importTestCaseConfig.getTestStepList().size(); ++cnt) {
                    oldNewIds.put(importTestCaseConfig.getTestStepList().get(cnt).getId(), newTestCase.getTestStepList().get(cnt).getId());
                }
                for (SecurityTestConfig scan : newTestCase.getSecurityTestList()) {
                    for (TestStepSecurityTestConfig secStepConfig : scan.getTestStepSecurityTestList()) {
                        if (!oldNewIds.containsKey(secStepConfig.getTestStepId())) continue;
                        secStepConfig.setTestStepId((String)oldNewIds.get(secStepConfig.getTestStepId()));
                    }
                }
            }
            List<TestCase> testCaseList = testSuite.getTestCaseList();
            for (int i = 0; i < testCaseList.size(); ++i) {
                TestCase testCase = testCaseList.get(i);
                for (int j = 0; j < testCase.getTestStepList().size(); ++j) {
                    TestStep testStep = testCase.getTestStepAt(j);
                    if (!(testStep instanceof WsdlTestStep)) continue;
                    ((WsdlTestStep)testStep).afterCopy(oldTestSuite, oldTestSuite.getTestCaseAt(i));
                }
            }
            this.testSuites.add(testSuite);
            this.fireTestSuiteAdded(testSuite);
            this.resolveImportedTestSuite(testSuite);
        }
    }

    private void resolveImportedTestSuite(WsdlTestSuite testSuite) {
        ResolveDialog resolver = new ResolveDialog("Validate TestSuite", "Checks TestSuite for inconsistencies", null);
        resolver.setShowOkMessage(false);
        resolver.resolve(testSuite);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests) throws SoapUIException {
        return WsdlInterfaceFactory.importWsdl(this, url, createRequests);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests, WsdlLoader wsdlLoader) throws SoapUIException {
        return WsdlInterfaceFactory.importWsdl(this, url, createRequests, null, wsdlLoader);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests, QName bindingName, WsdlLoader wsdlLoader) throws SoapUIException {
        return WsdlInterfaceFactory.importWsdl(this, url, createRequests, bindingName, wsdlLoader);
    }

    public String getDefaultScriptLanguage() {
        if (((ProjectConfig)this.getConfig()).isSetDefaultScriptLanguage()) {
            return ((ProjectConfig)this.getConfig()).getDefaultScriptLanguage();
        }
        return "Groovy";
    }

    public void setDefaultScriptLanguage(String id) {
        ((ProjectConfig)this.getConfig()).setDefaultScriptLanguage(id);
    }

    @Override
    public int getIndexOfTestSuite(TestSuite testSuite) {
        return this.testSuites.indexOf(testSuite);
    }

    public String getBeforeRunScript() {
        return ((ProjectConfig)this.getConfig()).isSetBeforeRunScript() ? ((ProjectConfig)this.getConfig()).getBeforeRunScript().getStringValue() : null;
    }

    public void setBeforeRunScript(String script) {
        String oldScript = this.getBeforeRunScript();
        if (!((ProjectConfig)this.getConfig()).isSetBeforeRunScript()) {
            ((ProjectConfig)this.getConfig()).addNewBeforeRunScript();
        }
        ((ProjectConfig)this.getConfig()).getBeforeRunScript().setStringValue(script);
        if (this.beforeRunScriptEngine != null) {
            this.beforeRunScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged("beforeRunScript", oldScript, script);
    }

    public Object runBeforeRunScript(ProjectRunContext context, ProjectRunner runner) throws Exception {
        String script = this.getBeforeRunScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.beforeRunScriptEngine == null) {
            this.beforeRunScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.beforeRunScriptEngine.setScript(script);
        }
        this.beforeRunScriptEngine.setVariable("runner", runner);
        this.beforeRunScriptEngine.setVariable("context", context);
        this.beforeRunScriptEngine.setVariable("project", this);
        this.beforeRunScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.beforeRunScriptEngine.run();
    }

    public String getAfterRunScript() {
        return ((ProjectConfig)this.getConfig()).isSetAfterRunScript() ? ((ProjectConfig)this.getConfig()).getAfterRunScript().getStringValue() : null;
    }

    public void setAfterRunScript(String script) {
        String oldScript = this.getAfterRunScript();
        if (!((ProjectConfig)this.getConfig()).isSetAfterRunScript()) {
            ((ProjectConfig)this.getConfig()).addNewAfterRunScript();
        }
        ((ProjectConfig)this.getConfig()).getAfterRunScript().setStringValue(script);
        if (this.afterRunScriptEngine != null) {
            this.afterRunScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged("afterRunScript", oldScript, script);
    }

    public Object runAfterRunScript(ProjectRunContext context, ProjectRunner runner) throws Exception {
        String script = this.getAfterRunScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.afterRunScriptEngine == null) {
            this.afterRunScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.afterRunScriptEngine.setScript(script);
        }
        this.afterRunScriptEngine.setVariable("runner", runner);
        this.afterRunScriptEngine.setVariable("context", context);
        this.afterRunScriptEngine.setVariable("project", this);
        this.afterRunScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.afterRunScriptEngine.run();
    }

    public void addProjectRunListener(ProjectRunListener projectRunListener) {
        this.runListeners.add(projectRunListener);
    }

    public void removeProjectRunListener(ProjectRunListener projectRunListener) {
        this.runListeners.remove(projectRunListener);
    }

    @Override
    public WsdlProjectRunner run(StringToObjectMap context, boolean async) {
        WsdlProjectRunner runner = new WsdlProjectRunner(this, context);
        runner.start(async);
        return runner;
    }

    public boolean isAbortOnError() {
        return ((ProjectConfig)this.getConfig()).getAbortOnError();
    }

    public void setAbortOnError(boolean arg0) {
        ((ProjectConfig)this.getConfig()).setAbortOnError(arg0);
    }

    public long getTimeout() {
        return ((ProjectConfig)this.getConfig()).getTimeout();
    }

    public void setTimeout(long timeout) {
        ((ProjectConfig)this.getConfig()).setTimeout(timeout);
    }

    public ProjectRunListener[] getProjectRunListeners() {
        return this.runListeners.toArray(new ProjectRunListener[this.runListeners.size()]);
    }

    public TestSuite.TestSuiteRunType getRunType() {
        TestSuiteRunTypesConfig.Enum runType = ((ProjectConfig)this.getConfig()).getRunType();
        if (((Object)((Object)TestSuiteRunTypesConfig.PARALLELL)).equals((Object)runType)) {
            return TestSuite.TestSuiteRunType.PARALLEL;
        }
        return TestSuite.TestSuiteRunType.SEQUENTIAL;
    }

    public void setRunType(TestSuite.TestSuiteRunType runType) {
        TestSuite.TestSuiteRunType oldRunType = this.getRunType();
        if (runType == TestSuite.TestSuiteRunType.PARALLEL && oldRunType != TestSuite.TestSuiteRunType.PARALLEL) {
            ((ProjectConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.PARALLELL);
            this.notifyPropertyChanged("runType", (Object)oldRunType, (Object)runType);
        } else if (runType == TestSuite.TestSuiteRunType.SEQUENTIAL && oldRunType != TestSuite.TestSuiteRunType.SEQUENTIAL) {
            ((ProjectConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.SEQUENTIAL);
            this.notifyPropertyChanged("runType", (Object)oldRunType, (Object)runType);
        }
    }

    public WsdlTestSuite moveTestSuite(int ix, int offset) {
        int c;
        WsdlTestSuite testSuite = this.testSuites.get(ix);
        if (offset == 0) {
            return testSuite;
        }
        this.testSuites.remove(ix);
        this.testSuites.add(ix + offset, testSuite);
        TestSuiteConfig[] configs = new TestSuiteConfig[this.testSuites.size()];
        for (c = 0; c < this.testSuites.size(); ++c) {
            if (offset > 0) {
                if (c < ix) {
                    configs[c] = (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c).copy();
                    continue;
                }
                if (c < ix + offset) {
                    configs[c] = (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c + 1).copy();
                    continue;
                }
                if (c == ix + offset) {
                    configs[c] = (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(ix).copy();
                    continue;
                }
                configs[c] = (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c).copy();
                continue;
            }
            configs[c] = c < ix + offset ? (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c).copy() : (c == ix + offset ? (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(ix).copy() : (c <= ix ? (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c - 1).copy() : (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c).copy()));
        }
        ((ProjectConfig)this.getConfig()).setTestSuiteArray(configs);
        for (c = 0; c < configs.length; ++c) {
            this.testSuites.get(c).resetConfigOnMove(((ProjectConfig)this.getConfig()).getTestSuiteArray(c));
        }
        this.fireTestSuiteMoved(testSuite, ix, offset);
        return testSuite;
    }

    public void importMockService(File file) {
        if (!file.exists()) {
            UISupport.showErrorMessage("Error loading test case ");
            return;
        }
        MockServiceDocumentConfig newMockServiceConfig = null;
        try {
            newMockServiceConfig = MockServiceDocumentConfig.Factory.parse(file);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        if (newMockServiceConfig == null) {
            UISupport.showErrorMessage("Not valid mock service xml");
        } else {
            MockServiceConfig config = (MockServiceConfig)this.projectDocument.getSoapuiProject().addNewMockService().set(newMockServiceConfig.getMockService());
            WsdlMockService mockService = new WsdlMockService(this, config);
            ModelSupport.createNewIds(mockService);
            mockService.afterLoad();
            this.addWsdlMockService(mockService);
            this.fireMockServiceAdded(mockService);
            this.resolveImportedMockService(mockService);
        }
    }

    private void resolveImportedMockService(WsdlMockService mockService) {
        ResolveDialog resolver = new ResolveDialog("Validate MockService", "Checks MockService for inconsistencies", null);
        resolver.setShowOkMessage(false);
        resolver.resolve(mockService);
    }

    public void addEnvironmentListener(EnvironmentListener listener) {
        this.environmentListeners.add(listener);
    }

    public void removeEnvironmentListener(EnvironmentListener listener) {
        this.environmentListeners.remove(listener);
    }

    public static enum ProjectEncryptionStatus {
        NOT_ENCRYPTED,
        ENCRYPTED_BAD_OR_NO_PASSWORD,
        ENCRYPTED_GOOD_PASSWORD;

    }
}

