/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessagePart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xmlbeans.SchemaType;

public final class HttpAttachmentPart
extends MessagePart.AttachmentPart {
    public static final String ANONYMOUS_NAME = "<anonymous>";
    private String name;
    private List<String> contentTypes = new ArrayList<String>();
    private Attachment.AttachmentType type;
    private boolean anonymous;
    private SchemaType schemaType;

    public HttpAttachmentPart() {
        this.anonymous = true;
        this.name = ANONYMOUS_NAME;
        this.type = Attachment.AttachmentType.UNKNOWN;
    }

    public HttpAttachmentPart(String name, List<String> types) {
        this.name = name;
        if (types != null) {
            this.contentTypes.addAll(types);
        }
    }

    public HttpAttachmentPart(String name, String type) {
        this.name = name;
        if (type != null) {
            this.contentTypes.add(type);
        }
    }

    @Override
    public String[] getContentTypes() {
        return this.contentTypes.toArray(new String[this.contentTypes.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addContentType(String contentType) {
        this.contentTypes.add(contentType);
    }

    public Attachment.AttachmentType getAttachmentType() {
        return this.type;
    }

    public void setType(Attachment.AttachmentType type) {
        this.type = type;
    }

    @Override
    public String getDescription() {
        return this.name + " attachment; [" + Arrays.toString(this.getContentTypes()) + "]";
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }
}

