/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.types;

import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.inferredSchema.CustomTypeConfig;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class CustomType
implements Type {
    private String xsd;
    private String name;
    private Schema schema;

    public CustomType(String name, String xsd) {
        this.name = name;
        this.xsd = xsd;
    }

    public CustomType(CustomTypeConfig xml, Schema schema) {
        this.schema = schema;
        this.name = xml.getName();
        this.xsd = xml.getXsd();
    }

    @Override
    public CustomTypeConfig save() {
        CustomTypeConfig xml = CustomTypeConfig.Factory.newInstance();
        xml.setName(this.name);
        xml.setXsd(this.xsd);
        return xml;
    }

    @Override
    public Type validate(Context context) throws XmlException {
        String name = context.getCursor().getName().getLocalPart();
        SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((String)("<schema xmlns=\"http://www.w3.org/2001/XMLSchema\"><element name=\"" + name + "\">" + this.xsd + "</element></schema>"))}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), null);
        SchemaTypeLoader stl = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{sts, XmlBeans.getBuiltinTypeSystem()});
        if (!stl.parse(context.getCursor().xmlText(), null, null).validate()) {
            throw new XmlException("Element '" + name + "' does not validate for custom type!");
        }
        return this;
    }

    @Override
    public String toString() {
        return this.xsd;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

