/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Particle;
import com.eviware.soapui.impl.wadl.inference.schema.SchemaSystem;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.impl.wadl.inference.schema.types.ComplexType;
import com.eviware.soapui.impl.wadl.inference.schema.types.EmptyType;
import com.eviware.soapui.inferredSchema.ComplexTypeConfig;
import com.eviware.soapui.inferredSchema.MapEntryConfig;
import com.eviware.soapui.inferredSchema.ParticleConfig;
import com.eviware.soapui.inferredSchema.SchemaConfig;
import com.eviware.soapui.support.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;

public class Schema {
    private SchemaSystem schemaSystem;
    private String namespace;
    private Map<String, String> prefixes;
    private Map<String, ComplexType> types;
    private List<Particle> particles;
    private EmptyType empty = new EmptyType(this);

    public Schema(String namespace, SchemaSystem schemaSystem) {
        this.schemaSystem = schemaSystem;
        this.namespace = namespace;
        this.prefixes = new HashMap<String, String>();
        this.particles = new ArrayList<Particle>();
        this.types = new HashMap<String, ComplexType>();
        this.putPrefixForNamespace("xs", "http://www.w3.org/2001/XMLSchema");
    }

    public Schema(SchemaConfig xml, SchemaSystem schemaSystem) {
        this.schemaSystem = schemaSystem;
        this.namespace = xml.getNamespace();
        this.prefixes = new HashMap<String, String>();
        this.particles = new ArrayList<Particle>();
        this.types = new HashMap<String, ComplexType>();
        for (MapEntryConfig mapEntryConfig : xml.getPrefixList()) {
            this.prefixes.put(mapEntryConfig.getKey(), mapEntryConfig.getValue());
        }
        for (ParticleConfig particleConfig : xml.getParticleList()) {
            this.particles.add(Particle.Factory.parse(particleConfig, this));
        }
        for (ComplexTypeConfig complexTypeConfig : xml.getComplexTypeList()) {
            this.types.put(complexTypeConfig.getName(), new ComplexType(complexTypeConfig, this));
        }
    }

    public void save(SchemaConfig xml) {
        xml.setNamespace(this.namespace);
        for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
            MapEntryConfig mapEntryConfig = xml.addNewPrefix();
            mapEntryConfig.setKey(entry.getKey());
            mapEntryConfig.setValue(entry.getValue());
        }
        ArrayList<ParticleConfig> particleList = new ArrayList<ParticleConfig>();
        for (Particle particle : this.particles) {
            particleList.add(particle.save());
        }
        xml.setParticleArray(particleList.toArray(new ParticleConfig[0]));
        for (ComplexType complexType : this.types.values()) {
            complexType.save(xml.addNewComplexType());
        }
    }

    public void addType(ComplexType type) {
        this.types.put(type.getName(), type);
        type.setSchema(this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefixForNamespace(String namespace) {
        return this.prefixes.get(namespace);
    }

    public void putPrefixForNamespace(String prefix, String namespace) {
        this.prefixes.put(namespace, prefix);
    }

    public Type getType(String name) {
        return this.types.get(name);
    }

    public Particle newElement(String name) {
        Particle p = Particle.Factory.newElementInstance(this, name);
        this.particles.add(p);
        return p;
    }

    public Particle newAttribute(String name) {
        Particle p = Particle.Factory.newAttributeInstance(this, name);
        this.particles.add(p);
        return p;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\" ?><" + this.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") + ":schema ");
        if (StringUtils.hasContent(this.namespace)) {
            s.append("targetNamespace=\"" + this.namespace + "\" xmlns=\"" + this.namespace + "\" ");
        }
        for (Map.Entry<String, String> entry : this.prefixes.entrySet()) {
            s.append("xmlns:" + entry.getValue() + "=\"" + entry.getKey() + "\" ");
        }
        s.append("elementFormDefault=\"qualified\">");
        for (Particle particle : this.particles) {
            s.append(particle);
        }
        for (Type type : this.types.values()) {
            s.append(type);
        }
        if (s.toString().contains("type=\"" + this.empty.getName() + "\"")) {
            s.append(this.empty);
        }
        s.append("</" + this.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") + ":schema>");
        return s.toString();
    }

    public void validate(Context context) throws XmlException {
        XmlCursor cursor = context.getCursor();
        Particle root = this.getParticle(cursor.getName().getLocalPart());
        if (root == null) {
            if (context.getHandler().callback(ConflictHandler.Event.CREATION, ConflictHandler.Type.ELEMENT, cursor.getName(), "/" + cursor.getName().getLocalPart(), "Undeclared root element.")) {
                root = this.newElement(cursor.getName().getLocalPart());
            } else {
                throw new XmlException("Illegal root element");
            }
        }
        root.validate(context);
    }

    public SchemaSystem getSystem() {
        return this.schemaSystem;
    }

    public Particle getParticle(String name) {
        for (Particle item : this.particles) {
            if (!item.getName().getLocalPart().equals(name)) continue;
            return item;
        }
        return null;
    }
}

