/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.definition.support;

import com.eviware.soapui.impl.wsdl.support.xsd.SchemaException;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.wsdl.WSDLException;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;

public class InvalidDefinitionException
extends SoapUIException {
    private SchemaException schemaException;
    private WSDLException wsdlException;
    private XmlException xmlException;
    private Exception exception;
    private String message;

    public InvalidDefinitionException(SchemaException schemaException) {
        this.schemaException = schemaException;
    }

    public InvalidDefinitionException(WSDLException wsdlException) {
        this.wsdlException = wsdlException;
    }

    public InvalidDefinitionException(XmlException xmlException) {
        this.xmlException = xmlException;
    }

    public InvalidDefinitionException(Exception exception) {
        this.exception = exception;
    }

    public InvalidDefinitionException(String message) {
        this.message = message;
    }

    public Exception getException() {
        return this.exception;
    }

    public WSDLException getWsdlException() {
        return this.wsdlException;
    }

    public SchemaException getSchemaException() {
        return this.schemaException;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDetailedMessage() {
        ArrayList<?> errorList;
        StringBuffer result = new StringBuffer();
        if (this.message != null) {
            result.append(this.message);
            result.append("<hr>");
        }
        if (this.exception != null) {
            result.append(this.exception.getMessage());
        } else if (this.wsdlException != null) {
            result.append(this.wsdlException.getMessage());
        } else if (this.xmlException != null) {
            XmlError error = this.xmlException.getError();
            result.append(error.getMessage()).append(" on line ").append(error.getLine()).append(", column ").append(error.getColumn());
        } else if (this.schemaException != null && (errorList = this.schemaException.getErrorList()) != null) {
            StringToStringMap doubles = new StringToStringMap();
            boolean appended = false;
            for (int c = 0; c < errorList.size(); ++c) {
                Object error = errorList.get(c);
                if (error instanceof XmlError) {
                    XmlError xmlError = (XmlError)error;
                    String sourceName = xmlError.getSourceName();
                    String message = xmlError.getMessage();
                    if (doubles.containsKey(message) && ((String)doubles.get(message)).equalsIgnoreCase(sourceName)) continue;
                    if (appended) {
                        result.append("<hr>");
                    }
                    result.append("<b>Source:</b> ").append(sourceName).append("<br>");
                    result.append("<b>Error:</b> ").append(message).append("<br>");
                    appended = true;
                    doubles.put(message, sourceName);
                    continue;
                }
                if (appended) {
                    result.append("<hr>");
                }
                result.append("<b>Error:</b> ").append(error.toString()).append("<br>");
                appended = true;
            }
        }
        return result.toString();
    }

    public void show() {
        UISupport.showExtendedInfo("Error loading WSDL", "There was something wrong with the WSDL you are trying to import", StringUtils.toHtml(this.getDetailedMessage()), new Dimension(600, 300));
    }
}

