/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support.definition.support;

import com.eviware.soapui.config.DefinitionCacheConfig;
import com.eviware.soapui.config.DefinitionCacheTypeConfig;
import com.eviware.soapui.config.DefintionPartConfig;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.support.definition.DefinitionCache;
import com.eviware.soapui.impl.support.definition.DefinitionLoader;
import com.eviware.soapui.impl.support.definition.InterfaceDefinitionPart;
import com.eviware.soapui.impl.support.definition.support.ConfigInterfaceDefinitionPart;
import com.eviware.soapui.impl.support.definition.support.InterfaceCacheDefinitionLoader;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDefinitionCache<T extends AbstractInterface<?>>
implements DefinitionCache {
    protected DefinitionCacheConfig definitionCache;
    private T container;
    private InterfaceDefinitionPart rootPart;
    private List<InterfaceDefinitionPart> parts;

    public AbstractDefinitionCache(DefinitionCacheConfig definitionCache, T container) {
        this.definitionCache = definitionCache;
        this.container = container;
        if (this.definitionCache == null) {
            this.definitionCache = this.reinit(container);
        }
    }

    protected abstract DefinitionCacheConfig reinit(T var1);

    public T getContainer() {
        return this.container;
    }

    @Override
    public boolean validate() {
        if (this.definitionCache.getRootPart() == null) {
            return false;
        }
        return this.definitionCache.sizeOfPartArray() != 0;
    }

    public void importCache(DefinitionCache cache) throws Exception {
        if (cache instanceof AbstractDefinitionCache) {
            this.definitionCache = this.reinit(this.container);
            this.definitionCache.set(((AbstractDefinitionCache)cache).getConfig());
            this.initParts();
        } else {
            this.update(new InterfaceCacheDefinitionLoader(cache));
        }
    }

    protected DefinitionCacheConfig getConfig() {
        return this.definitionCache;
    }

    @Override
    public void update(DefinitionLoader loader) throws Exception {
        this.definitionCache = this.reinit(this.container);
        String baseUri = loader.getBaseURI();
        this.definitionCache.setType(DefinitionCacheTypeConfig.TEXT);
        Map<String, XmlObject> urls = SchemaUtils.getDefinitionParts(loader);
        this.definitionCache.setRootPart(baseUri);
        for (Map.Entry<String, XmlObject> entry : urls.entrySet()) {
            Node node;
            DefintionPartConfig definitionPart = this.definitionCache.addNewPart();
            String url = entry.getKey();
            definitionPart.setUrl(url);
            XmlObject xmlObject = entry.getValue();
            Node domNode = xmlObject.getDomNode();
            if (domNode.getNodeType() == 11 && (node = ((DocumentFragment)domNode).getFirstChild()).getNodeType() == 3) {
                domNode = XmlUtils.parseXml(node.getNodeValue());
                xmlObject = XmlUtils.createXmlObject(domNode);
            }
            Element contentElement = ((Document)domNode).getDocumentElement();
            Node newDomNode = definitionPart.addNewContent().getDomNode();
            newDomNode.appendChild(newDomNode.getOwnerDocument().createTextNode(xmlObject.toString()));
            definitionPart.setType(contentElement.getNamespaceURI());
        }
        this.initParts();
    }

    @Override
    public List<InterfaceDefinitionPart> getDefinitionParts() throws Exception {
        if (this.parts == null) {
            this.initParts();
        }
        return this.parts;
    }

    private void initParts() {
        this.parts = new ArrayList<InterfaceDefinitionPart>();
        List<DefintionPartConfig> partList = this.definitionCache.getPartList();
        for (DefintionPartConfig part : partList) {
            try {
                boolean rootElement = URLDecoder.decode(part.getUrl(), "UTF-8").equals(URLDecoder.decode(this.definitionCache.getRootPart(), "UTF-8"));
                ConfigInterfaceDefinitionPart configInterfaceDefinitionPart = new ConfigInterfaceDefinitionPart(part, rootElement, this.definitionCache.getType());
                this.parts.add(configInterfaceDefinitionPart);
                if (!configInterfaceDefinitionPart.isRootPart()) continue;
                this.rootPart = configInterfaceDefinitionPart;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public InterfaceDefinitionPart getRootPart() {
        if (this.parts == null) {
            this.initParts();
        }
        return this.rootPart;
    }

    @Override
    public void clear() {
        this.definitionCache.setRootPart(null);
        while (this.definitionCache.sizeOfPartArray() > 0) {
            this.definitionCache.removePart(0);
        }
    }
}

