/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.BaseMockResponseConfig;
import com.eviware.soapui.config.CompressedStringConfig;
import com.eviware.soapui.config.HeaderConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.MutableWsdlAttachmentContainer;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MimeMessageMockResponseEntity;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.MockResponseDataSource;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.MapTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.MessageXmlObject;
import com.eviware.soapui.impl.wsdl.support.MessageXmlPart;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunContext;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.settings.CommonSettings;
import com.eviware.soapui.support.scripting.ScriptEnginePool;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import org.apache.ws.security.WSSecurityException;

public abstract class AbstractMockResponse<MockResponseConfigType extends BaseMockResponseConfig>
extends AbstractWsdlModelItem<MockResponseConfigType>
implements MockResponse,
MutableWsdlAttachmentContainer,
PropertyExpansionContainer,
TestPropertyHolder {
    public static final String AUTO_RESPONSE_COMPRESSION = "<auto>";
    public static final String NO_RESPONSE_COMPRESSION = "<none>";
    private MapTestPropertyHolder propertyHolder;
    private String responseContent;
    private MockResult mockResult;
    private ScriptEnginePool scriptEnginePool = new ScriptEnginePool(this);

    public AbstractMockResponse(MockResponseConfigType config, MockOperation operation, String icon) {
        super(config, operation, icon);
        this.scriptEnginePool.setScript(this.getScript());
        this.propertyHolder = new MapTestPropertyHolder(this);
        this.propertyHolder.addProperty("Request");
        if (!config.isSetHttpResponseStatus()) {
            config.setHttpResponseStatus("200");
        }
    }

    @Override
    public void setConfig(MockResponseConfigType config) {
        super.setConfig(config);
        if (this.scriptEnginePool != null) {
            this.scriptEnginePool.setScript(this.getScript());
        }
    }

    @Override
    public String getResponseContent() {
        if (((BaseMockResponseConfig)this.getConfig()).getResponseContent() == null) {
            ((BaseMockResponseConfig)this.getConfig()).addNewResponseContent();
        }
        if (this.responseContent == null) {
            this.responseContent = CompressedStringSupport.getString(((BaseMockResponseConfig)this.getConfig()).getResponseContent());
        }
        return this.responseContent;
    }

    @Override
    public void setResponseContent(String responseContent) {
        String oldContent = this.getResponseContent();
        if (responseContent != null && responseContent.equals(oldContent)) {
            return;
        }
        this.responseContent = responseContent;
        this.setConfigResponseContent(responseContent);
        this.notifyPropertyChanged(RESPONSE_CONTENT_PROPERTY, oldContent, responseContent);
    }

    private void setConfigResponseContent(String responseContent) {
        CompressedStringConfig compressedResponseContent = CompressedStringConfig.Factory.newInstance();
        compressedResponseContent.setStringValue(responseContent);
        ((BaseMockResponseConfig)this.getConfig()).setResponseContent(compressedResponseContent);
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        StringToStringsMap result = new StringToStringsMap();
        List<HeaderConfig> headerList = ((BaseMockResponseConfig)this.getConfig()).getHeaderList();
        for (HeaderConfig header : headerList) {
            result.add(header.getName(), header.getValue());
        }
        return result;
    }

    @Override
    public void setResponseHttpStatus(int httpStatus) {
        ((BaseMockResponseConfig)this.getConfig()).setHttpResponseStatus("" + httpStatus);
    }

    @Override
    public int getResponseHttpStatus() {
        if (((BaseMockResponseConfig)this.getConfig()).getHttpResponseStatus() != null) {
            return Integer.valueOf(((BaseMockResponseConfig)this.getConfig()).getHttpResponseStatus());
        }
        return 200;
    }

    public String getResponseCompression() {
        if (((BaseMockResponseConfig)this.getConfig()).isSetCompression()) {
            return ((BaseMockResponseConfig)this.getConfig()).getCompression();
        }
        return AUTO_RESPONSE_COMPRESSION;
    }

    public void setMockResult(MockResult mockResult) {
        MockResult oldResult = this.mockResult;
        this.mockResult = mockResult;
        this.notifyPropertyChanged(this.mockresultProperty(), oldResult, mockResult);
    }

    @Override
    public MockResult getMockResult() {
        return this.mockResult;
    }

    protected abstract String mockresultProperty();

    @Override
    public String getScript() {
        return ((BaseMockResponseConfig)this.getConfig()).isSetScript() ? ((BaseMockResponseConfig)this.getConfig()).getScript().getStringValue() : null;
    }

    @Override
    public void evaluateScript(MockRequest request) throws Exception {
        String script = this.getScript();
        if (script == null || script.trim().length() == 0) {
            return;
        }
        MockService mockService = this.getMockOperation().getMockService();
        MockRunner mockRunner = mockService.getMockRunner();
        MockRunContext context = mockRunner == null ? new WsdlMockRunContext(mockService, null) : mockRunner.getMockContext();
        context.setMockResponse(this);
        SoapUIScriptEngine scriptEngine = this.scriptEnginePool.getScriptEngine();
        try {
            scriptEngine.setVariable("context", context);
            scriptEngine.setVariable("requestContext", request == null ? null : request.getRequestContext());
            scriptEngine.setVariable("mockContext", context);
            scriptEngine.setVariable("mockRequest", request);
            scriptEngine.setVariable("mockResponse", this);
            scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
            scriptEngine.run();
        }
        catch (RuntimeException e) {
            throw new Exception(e.getMessage(), e);
        }
        finally {
            this.scriptEnginePool.returnScriptEngine(scriptEngine);
        }
    }

    @Override
    public void setScript(String script) {
        String oldScript = this.getScript();
        if (!script.equals(oldScript)) {
            if (!((BaseMockResponseConfig)this.getConfig()).isSetScript()) {
                ((BaseMockResponseConfig)this.getConfig()).addNewScript();
            }
            ((BaseMockResponseConfig)this.getConfig()).getScript().setStringValue(script);
            this.scriptEnginePool.setScript(script);
        }
    }

    @Override
    public void release() {
        super.release();
        this.scriptEnginePool.release();
    }

    @Override
    public MockResult execute(MockRequest request, MockResult result) throws DispatchException {
        try {
            String script;
            this.getProperty("Request").setValue(request.getRequestContent());
            long delay = this.getResponseDelay();
            if (delay > 0L) {
                Thread.sleep(delay);
            }
            if ((script = this.getScript()) != null && script.trim().length() > 0) {
                this.evaluateScript(request);
            }
            String responseContent = this.getResponseContent();
            WsdlMockRunContext context = new WsdlMockRunContext(request.getContext().getMockService(), null);
            context.setMockResponse(this);
            context.putAll((WsdlMockRunContext)request.getContext());
            context.putAll((WsdlMockRunContext)request.getRequestContext());
            StringToStringsMap responseHeaders = this.getResponseHeaders();
            for (Map.Entry headerEntry : responseHeaders.entrySet()) {
                for (String value : (List)headerEntry.getValue()) {
                    result.addHeader((String)headerEntry.getKey(), PropertyExpander.expandProperties(context, value));
                }
            }
            responseContent = PropertyExpander.expandProperties(context, responseContent, this.isEntitizeProperties());
            responseContent = this.executeSpecifics(request, responseContent, context);
            if (!result.isCommitted()) {
                responseContent = this.writeResponse(result, responseContent);
            }
            result.setResponseContent(responseContent);
            this.setMockResult(result);
            return result;
        }
        catch (Throwable e) {
            SoapUI.logError(e);
            throw new DispatchException(e);
        }
    }

    public String writeResponse(MockResult result, String responseContent) throws Exception {
        MimeMultipart mp = null;
        Operation operation = this.getMockOperation().getOperation();
        boolean isXOP = this.isMtomEnabled() && this.isForceMtom();
        StringToStringMap contentIds = new StringToStringMap();
        if (operation instanceof WsdlOperation) {
            if (operation == null) {
                throw new IllegalStateException("Missing WsdlOperation for mock response");
            }
            if (this.isMtomEnabled() || this.isInlineFilesEnabled() || this.getAttachmentCount() > 0) {
                try {
                    MessageXmlPart[] requestParts;
                    mp = new MimeMultipart();
                    WsdlOperation wsdlOperation = (WsdlOperation)operation;
                    MessageXmlObject requestXmlObject = this.createMessageXmlObject(responseContent, wsdlOperation);
                    for (MessageXmlPart requestPart : requestParts = requestXmlObject.getMessageParts()) {
                        if (!this.prepareMessagePart(mp, contentIds, requestPart)) continue;
                        isXOP = true;
                    }
                    responseContent = requestXmlObject.getMessageContent();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
            responseContent = this.removeEmptyContent(responseContent);
        }
        if (this.isStripWhitespaces()) {
            responseContent = XmlUtils.stripWhitespaces(responseContent);
        }
        MockRequest request = result.getMockRequest();
        request.getHttpResponse().setStatus(this.getResponseHttpStatus());
        ByteArrayOutputStream outData = new ByteArrayOutputStream();
        String responseCompression = this.getResponseCompression();
        if (!(isXOP || mp != null && mp.getCount() != 0 || this.getAttachmentCount() != 0)) {
            byte[] content;
            String encoding = this.getEncoding();
            if (responseContent == null) {
                responseContent = "";
            }
            byte[] byArray = content = encoding == null ? responseContent.getBytes() : responseContent.getBytes(encoding);
            if (!result.getResponseHeaders().containsKeyIgnoreCase("Content-Type")) {
                result.setContentType(this.getContentType());
            }
            String acceptEncoding = result.getMockRequest().getRequestHeaders().get("Accept-Encoding", "");
            if (AUTO_RESPONSE_COMPRESSION.equals(responseCompression) && acceptEncoding != null && acceptEncoding.toUpperCase().contains("GZIP")) {
                if (!this.headerExists("Content-Encoding", "gzip", result)) {
                    result.addHeader("Content-Encoding", "gzip");
                }
                outData.write(CompressionSupport.compress("gzip", content));
            } else if (AUTO_RESPONSE_COMPRESSION.equals(responseCompression) && acceptEncoding != null && acceptEncoding.toUpperCase().contains("DEFLATE")) {
                result.addHeader("Content-Encoding", "deflate");
                outData.write(CompressionSupport.compress("deflate", content));
            } else {
                outData.write(content);
            }
        } else {
            if (mp == null) {
                mp = new MimeMultipart();
            }
            this.initRootPart(responseContent, mp, isXOP);
            AttachmentUtils.addMimeParts(this, Arrays.asList(this.getAttachments()), mp, contentIds);
            MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
            message.setContent((Multipart)mp);
            message.saveChanges();
            MimeMessageMockResponseEntity mimeMessageRequestEntity = new MimeMessageMockResponseEntity(message, isXOP, this);
            result.addHeader("Content-Type", mimeMessageRequestEntity.getContentType().getValue());
            result.addHeader("MIME-Version", "1.0");
            mimeMessageRequestEntity.writeTo(outData);
        }
        if (outData.size() > 0) {
            byte[] data = outData.toByteArray();
            if (responseCompression.equals("deflate") || responseCompression.equals("gzip")) {
                result.addHeader("Content-Encoding", responseCompression);
                data = CompressionSupport.compress(responseCompression, data);
            }
            if (result.getResponseHeaders().get("Transfer-Encoding") == null) {
                result.addHeader("Content-Length", "" + data.length);
            }
            result.writeRawResponseData(data);
        }
        return responseContent;
    }

    private boolean headerExists(String headerName, String headerValue, MockResult result) {
        StringToStringsMap resultResponseHeaders = result.getResponseHeaders();
        return resultResponseHeaders.containsKeyIgnoreCase(headerName) && ((List)resultResponseHeaders.get(headerName)).contains(headerValue);
    }

    public boolean prepareMessagePart(MimeMultipart mp, StringToStringMap contentIds, MessageXmlPart requestPart) throws Exception {
        return AttachmentUtils.prepareMessagePart(this, mp, requestPart, contentIds);
    }

    public MessageXmlObject createMessageXmlObject(String responseContent, WsdlOperation wsdlOperation) {
        return new MessageXmlObject(wsdlOperation, responseContent, false);
    }

    private void initRootPart(String requestContent, MimeMultipart mp, boolean isXOP) throws MessagingException {
        PreencodedMimeBodyPart rootPart = new PreencodedMimeBodyPart("8bit");
        rootPart.setContentID("<rootpart@soapui.org>");
        mp.addBodyPart((BodyPart)rootPart, 0);
        DataHandler dataHandler = new DataHandler((DataSource)new MockResponseDataSource(this, requestContent, isXOP));
        rootPart.setDataHandler(dataHandler);
    }

    protected abstract String removeEmptyContent(String var1);

    @Override
    public void setResponseHeaders(StringToStringsMap headers) {
        StringToStringsMap oldHeaders = this.getResponseHeaders();
        ((BaseMockResponseConfig)this.getConfig()).setHeaderArray(new HeaderConfig[0]);
        for (Map.Entry header : headers.entrySet()) {
            for (String value : (List)header.getValue()) {
                HeaderConfig headerConfig = ((BaseMockResponseConfig)this.getConfig()).addNewHeader();
                headerConfig.setName((String)header.getKey());
                headerConfig.setValue(value);
            }
        }
        this.notifyPropertyChanged(WsdlMockResponse.HEADERS_PROPERTY, oldHeaders, headers);
    }

    protected abstract String executeSpecifics(MockRequest var1, String var2, WsdlMockRunContext var3) throws IOException, WSSecurityException;

    public boolean isEntitizeProperties() {
        return this.getSettings().getBoolean(CommonSettings.ENTITIZE_PROPERTIES);
    }

    public abstract long getResponseDelay();

    public abstract boolean isForceMtom();

    public abstract boolean isStripWhitespaces();

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolder.addTestPropertyListener(listener);
    }

    @Override
    public ModelItem getModelItem() {
        return this.propertyHolder.getModelItem();
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.propertyHolder.getProperties();
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.propertyHolder.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyHolder.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.propertyHolder.getPropertyValue(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyHolder.hasProperty(name);
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolder.removeTestPropertyListener(listener);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        this.propertyHolder.setPropertyValue(name, value);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyHolder.getPropertyAt(index);
    }

    @Override
    public int getPropertyCount() {
        return this.propertyHolder.getPropertyCount();
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.propertyHolder.getPropertyList();
    }

    @Override
    public String getEncoding() {
        return ((BaseMockResponseConfig)this.getConfig()).getEncoding();
    }

    public void setEncoding(String encoding) {
        ((BaseMockResponseConfig)this.getConfig()).setEncoding(encoding);
    }
}

