/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AbstractRequestConfig;
import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.AbstractHttpOperation;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.HttpAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.IAfterRequestInjection;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.FileAttachment;
import com.eviware.soapui.impl.wsdl.support.IconAnimator;
import com.eviware.soapui.impl.wsdl.support.RequestFileAttachment;
import com.eviware.soapui.impl.wsdl.support.jms.header.JMSHeaderContainer;
import com.eviware.soapui.impl.wsdl.support.jms.property.JMSPropertyContainer;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.SettingPathPropertySupport;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.settings.CommonSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public abstract class AbstractHttpRequest<T extends AbstractRequestConfig>
extends AbstractWsdlModelItem<T>
implements Request,
AbstractHttpRequestInterface<T>,
JMSHeaderContainer,
JMSPropertyContainer {
    public static final String BASIC_AUTH_PROFILE = "Basic";
    public static final String SELECTED_AUTH_PROFILE_PROPERTY_NAME = "selectedAuthProfile";
    public static final String CR_ESCAPE_SEQUENCE = "\\\\_r";
    private Set<SubmitListener> submitListeners = new HashSet<SubmitListener>();
    private String requestContent;
    private RequestIconAnimator<?> iconAnimator;
    private HttpResponse response;
    private SettingPathPropertySupport dumpFile;
    private List<FileAttachment<?>> attachments = new ArrayList();
    private IAfterRequestInjection afterRequestInjection;

    protected AbstractHttpRequest(T config, AbstractHttpOperation parent, String icon, boolean forLoadTest) {
        super(config, parent, icon);
        if (!forLoadTest) {
            this.iconAnimator = this.initIconAnimator();
            if (SoapUI.usingGraphicalEnvironment()) {
                this.addSubmitListener(this.iconAnimator);
            }
        }
        this.initAttachments();
        this.dumpFile = new SettingPathPropertySupport(this, DUMP_FILE);
    }

    private void initAttachments() {
        for (AttachmentConfig ac : ((AbstractRequestConfig)this.getConfig()).getAttachmentList()) {
            RequestFileAttachment attachment = new RequestFileAttachment(ac, this);
            this.attachments.add(attachment);
        }
    }

    protected List<FileAttachment<?>> getAttachmentsList() {
        return this.attachments;
    }

    public Attachment attachBinaryData(byte[] data, String contentType) {
        try {
            File temp = File.createTempFile("binaryContent", ".tmp");
            FileOutputStream out = new FileOutputStream(temp);
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
            RequestFileAttachment fileAttachment = new RequestFileAttachment(temp, false, this);
            fileAttachment.setContentType(contentType);
            this.attachments.add(fileAttachment);
            this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, null, fileAttachment);
            return fileAttachment;
        }
        catch (IOException e) {
            SoapUI.logError(e);
            return null;
        }
    }

    @Override
    public Attachment attachFile(File file, boolean cache) throws IOException {
        RequestFileAttachment fileAttachment = new RequestFileAttachment(file, cache, this);
        this.attachments.add(fileAttachment);
        this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, null, fileAttachment);
        return fileAttachment;
    }

    @Override
    public abstract RestRequestInterface.HttpMethod getMethod();

    @Override
    public abstract HttpAttachmentPart getAttachmentPart(String var1);

    @Override
    public int getAttachmentCount() {
        return this.attachments.size();
    }

    @Override
    public Attachment getAttachmentAt(int index) {
        return this.attachments.get(index);
    }

    public void setAttachmentAt(int index, Attachment attachment) {
        if (this.attachments.size() > index) {
            this.attachments.set(index, (FileAttachment)attachment);
        } else {
            this.attachments.add((FileAttachment)attachment);
        }
        this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, null, attachment);
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment attachment : this.attachments) {
            if (!partName.equals(attachment.getPart())) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        int ix = this.attachments.indexOf(attachment);
        this.attachments.remove(ix);
        try {
            this.notifyPropertyChanged(ATTACHMENTS_PROPERTY, attachment, null);
        }
        finally {
            ((AbstractRequestConfig)this.getConfig()).removeAttachment(ix);
        }
    }

    @Override
    public Attachment[] getAttachments() {
        return this.attachments.toArray(new Attachment[this.attachments.size()]);
    }

    protected RequestIconAnimator<?> initIconAnimator() {
        return new RequestIconAnimator<AbstractHttpRequest>(this, "/soap_request.png", "/soap_request.png", 4);
    }

    @Override
    public void addSubmitListener(SubmitListener listener) {
        this.submitListeners.add(listener);
    }

    @Override
    public void removeSubmitListener(SubmitListener listener) {
        this.submitListeners.remove(listener);
    }

    @Override
    public boolean isMultipartEnabled() {
        return !this.getSettings().getBoolean(DISABLE_MULTIPART_ATTACHMENTS);
    }

    @Override
    public void setMultipartEnabled(boolean multipartEnabled) {
        this.getSettings().setBoolean(DISABLE_MULTIPART_ATTACHMENTS, !multipartEnabled);
    }

    @Override
    public boolean isEntitizeProperties() {
        return this.getSettings().getBoolean(CommonSettings.ENTITIZE_PROPERTIES);
    }

    @Override
    public void setEntitizeProperties(boolean entitizeProperties) {
        this.getSettings().setBoolean(CommonSettings.ENTITIZE_PROPERTIES, entitizeProperties);
    }

    @Override
    public void release() {
        this.submitListeners.clear();
        super.release();
    }

    @Override
    public SubmitListener[] getSubmitListeners() {
        return this.submitListeners.toArray(new SubmitListener[this.submitListeners.size()]);
    }

    @Override
    public AbstractHttpOperation getOperation() {
        return (AbstractHttpOperation)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyAttachmentsTo(WsdlRequest newRequest) {
        if (this.getAttachmentCount() > 0) {
            try {
                UISupport.setHourglassCursor();
                for (int c = 0; c < this.getAttachmentCount(); ++c) {
                    try {
                        Attachment attachment = this.getAttachmentAt(c);
                        newRequest.importAttachment(attachment);
                        continue;
                    }
                    catch (Exception e) {
                        SoapUI.logError(e);
                    }
                }
            }
            finally {
                UISupport.resetCursor();
            }
        }
    }

    @Override
    public Attachment importAttachment(Attachment attachment) {
        if (attachment instanceof FileAttachment) {
            AttachmentConfig oldConfig = ((FileAttachment)attachment).getConfig();
            AttachmentConfig newConfig = (AttachmentConfig)((AbstractRequestConfig)this.getConfig()).addNewAttachment().set(oldConfig);
            RequestFileAttachment newAttachment = new RequestFileAttachment(newConfig, this);
            this.attachments.add(newAttachment);
            return newAttachment;
        }
        log.error((Object)("Unknown attachment type: " + attachment));
        return null;
    }

    @Override
    public void addAttachmentsChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(ATTACHMENTS_PROPERTY, listener);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void removeAttachmentsChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(ATTACHMENTS_PROPERTY, listener);
    }

    @Override
    public String getRequestContent() {
        if (((AbstractRequestConfig)this.getConfig()).getRequest() == null) {
            ((AbstractRequestConfig)this.getConfig()).addNewRequest();
        }
        if (this.requestContent == null) {
            this.requestContent = this.unescapeCarriageReturnsIn(CompressedStringSupport.getString(((AbstractRequestConfig)this.getConfig()).getRequest()));
        }
        return this.requestContent;
    }

    @Override
    public void setRequestContent(String request) {
        String old = this.getRequestContent();
        if (StringUtils.isNullOrEmpty(request) && StringUtils.isNullOrEmpty(old) || request != null && request.equals(old)) {
            return;
        }
        this.requestContent = request;
        this.notifyPropertyChanged("request", old, request);
    }

    private String unescapeCarriageReturnsIn(String request) {
        if (request == null) {
            return null;
        }
        String modifiedRequest = request.replaceAll("\\\\r", "\r");
        modifiedRequest = modifiedRequest.replaceAll(CR_ESCAPE_SEQUENCE, "\\\\r");
        return modifiedRequest;
    }

    private String escapeCarriageReturnsIn(String request) {
        if (request == null) {
            return null;
        }
        String modifiedRequest = request.replaceAll("\\\\r", CR_ESCAPE_SEQUENCE);
        modifiedRequest = modifiedRequest.replaceAll("\r", "\\\\r");
        return modifiedRequest;
    }

    @Override
    public boolean isPrettyPrint() {
        return this.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES);
    }

    @Override
    public void setPrettyPrint(boolean prettyPrint) {
        boolean old = this.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES);
        this.getSettings().setBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES, prettyPrint);
        this.notifyPropertyChanged(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES, old, prettyPrint);
    }

    @Override
    public void setEndpoint(String endpoint) {
        if (this.getOperation() != null) {
            ((AbstractInterface)this.getOperation().getInterface()).getProject().getEndpointSupport().setEndpoint(this, endpoint);
        } else {
            String old = this.getEndpoint();
            if (old != null && old.equals(endpoint)) {
                return;
            }
            ((AbstractRequestConfig)this.getConfig()).setEndpoint(endpoint);
            this.notifyPropertyChanged("endpoint", old, endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        if (this.getOperation() != null) {
            return ((AbstractInterface)this.getOperation().getInterface()).getProject().getEndpointSupport().getEndpoint(this);
        }
        return ((AbstractRequestConfig)this.getConfig()).getEndpoint();
    }

    @Override
    public String getEncoding() {
        return ((AbstractRequestConfig)this.getConfig()).getEncoding();
    }

    @Override
    public void setEncoding(String encoding) {
        String old = this.getEncoding();
        ((AbstractRequestConfig)this.getConfig()).setEncoding(encoding);
        this.notifyPropertyChanged("encoding", old, encoding);
    }

    @Override
    public String getTimeout() {
        return ((AbstractRequestConfig)this.getConfig()).getTimeout();
    }

    public void setTimeout(String timeout) {
        String old = this.getTimeout();
        ((AbstractRequestConfig)this.getConfig()).setTimeout(timeout);
        this.notifyPropertyChanged("timeout", old, timeout);
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return StringToStringsMap.fromXml(this.getSettings().getString(REQUEST_HEADERS_PROPERTY, null));
    }

    @Override
    public RequestIconAnimator<?> getIconAnimator() {
        return this.iconAnimator;
    }

    public void setRequestHeaders(StringToStringMap map) {
        this.setRequestHeaders(new StringToStringsMap(map));
    }

    @Override
    public void setRequestHeaders(StringToStringsMap map) {
        StringToStringsMap old = this.getRequestHeaders();
        this.getSettings().setString(REQUEST_HEADERS_PROPERTY, map.toXml());
        this.notifyPropertyChanged(REQUEST_HEADERS_PROPERTY, old, map);
    }

    @Override
    public ImageIcon getIcon() {
        return this.iconAnimator == null ? null : this.iconAnimator.getIcon();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        PropertyExpansionsResult result = new PropertyExpansionsResult(this, this);
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "requestContent"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "endpoint"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "username"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "password"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this, this, "domain"));
        StringToStringsMap requestHeaders = this.getRequestHeaders();
        for (String key : requestHeaders.keySet()) {
            for (String value : (List)requestHeaders.get(key)) {
                result.extractAndAddAll(new HttpTestRequestStep.RequestHeaderHolder(key, value, this), "value");
            }
        }
        return result.toArray();
    }

    @Override
    public String getUsername() {
        CredentialsConfig credentialsConfig = ((AbstractRequestConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            return null;
        }
        return credentialsConfig.getUsername();
    }

    @Override
    public String getPassword() {
        CredentialsConfig credentialsConfig = ((AbstractRequestConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            return null;
        }
        return credentialsConfig.getPassword();
    }

    @Override
    public String getDomain() {
        CredentialsConfig credentialsConfig = ((AbstractRequestConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            return null;
        }
        return credentialsConfig.getDomain();
    }

    public String getSelectedAuthProfile() {
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        String selectedAuthProfile = credentialsConfig.getSelectedAuthProfile();
        if (selectedAuthProfile == null) {
            String authType = this.getAuthType();
            if (CredentialsConfig.AuthType.PREEMPTIVE.toString().equals(authType) || CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS.toString().equals(authType)) {
                this.addBasicProfileAndRemoveGlobalHttpSettingsAndPreEmptive(BASIC_AUTH_PROFILE);
                return BASIC_AUTH_PROFILE;
            }
            if (CredentialsConfig.AuthType.NTLM.toString().equals(authType) || CredentialsConfig.AuthType.SPNEGO_KERBEROS.toString().equals(authType)) {
                this.addBasicAuthenticationProfile(authType);
                return authType;
            }
            return CredentialsConfig.AuthType.NO_AUTHORIZATION.toString();
        }
        if (CredentialsConfig.AuthType.PREEMPTIVE.toString().equals(selectedAuthProfile) || CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS.toString().equals(selectedAuthProfile)) {
            this.addBasicProfileAndRemoveGlobalHttpSettingsAndPreEmptive(BASIC_AUTH_PROFILE);
            return BASIC_AUTH_PROFILE;
        }
        return selectedAuthProfile;
    }

    private void addBasicProfileAndRemoveGlobalHttpSettingsAndPreEmptive(String authType) {
        this.addBasicAuthenticationProfile(authType);
        this.removeGlobalHttpSettingsAndPreEmptiveProfiles();
    }

    private void removeGlobalHttpSettingsAndPreEmptiveProfiles() {
        this.removeBasicAuthenticationProfile(CredentialsConfig.AuthType.PREEMPTIVE.toString());
        this.removeBasicAuthenticationProfile(CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS.toString());
    }

    public Set<String> getBasicAuthenticationProfiles() {
        HashSet<String> authTypes = new HashSet<String>();
        CredentialsConfig credentialsConfig = ((AbstractRequestConfig)this.getConfig()).getCredentials();
        if (credentialsConfig != null) {
            for (String type : credentialsConfig.getAddedBasicAuthenticationTypesList()) {
                if (CredentialsConfig.AuthType.PREEMPTIVE.toString().equals(type) || CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS.toString().equals(type)) {
                    authTypes.add(BASIC_AUTH_PROFILE);
                    continue;
                }
                authTypes.add(type);
            }
        }
        if (authTypes.contains(BASIC_AUTH_PROFILE)) {
            this.removeGlobalHttpSettingsAndPreEmptiveProfiles();
        }
        return authTypes;
    }

    @Override
    public String getAuthType() {
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        this.initializeAuthType(credentialsConfig);
        return credentialsConfig.getAuthType().toString();
    }

    private void initializeAuthType(CredentialsConfig credentialsConfig) {
        try {
            if (credentialsConfig.getAuthType() == null) {
                credentialsConfig.setAuthType(CredentialsConfig.AuthType.NO_AUTHORIZATION);
            }
        }
        catch (XmlValueOutOfRangeException e) {
            credentialsConfig.setAuthType(CredentialsConfig.AuthType.NTLM);
        }
    }

    public void addBasicAuthenticationProfile(String authType) {
        List<String> addedBasicAuthenticationTypesList = this.getCredentialsConfig().getAddedBasicAuthenticationTypesList();
        if (!addedBasicAuthenticationTypesList.contains(authType)) {
            addedBasicAuthenticationTypesList.add(authType);
        }
    }

    public void removeBasicAuthenticationProfile(String authType) {
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        for (int count = 0; count < credentialsConfig.sizeOfAddedBasicAuthenticationTypesArray(); ++count) {
            if (!credentialsConfig.getAddedBasicAuthenticationTypesArray(count).equals(authType)) continue;
            credentialsConfig.removeAddedBasicAuthenticationTypes(count);
            break;
        }
    }

    @Override
    public void setUsername(String username) {
        String old = this.getUsername();
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        credentialsConfig.setUsername(username);
        this.notifyPropertyChanged("username", old, username);
    }

    @Override
    public void setPassword(String password) {
        String old = this.getPassword();
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        credentialsConfig.setPassword(password);
        this.notifyPropertyChanged("password", old, password);
    }

    @Override
    public void setDomain(String domain) {
        String old = this.getDomain();
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        credentialsConfig.setDomain(domain);
        this.notifyPropertyChanged("domain", old, domain);
    }

    public void setSelectedAuthProfileAndAuthType(String authProfile, CredentialsConfig.AuthType.Enum authType) {
        this.setSelectedAuthProfile(authProfile);
        this.setAuthType(authType);
    }

    public CredentialsConfig.AuthType.Enum getBasicAuthType(String selectedProfile) {
        if (BASIC_AUTH_PROFILE.equals(selectedProfile)) {
            if (this.getPreemptive()) {
                return CredentialsConfig.AuthType.PREEMPTIVE;
            }
            return CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS;
        }
        return CredentialsConfig.AuthType.Enum.forString(selectedProfile);
    }

    private void setSelectedAuthProfile(String authProfile) {
        String old = this.getSelectedAuthProfile();
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        credentialsConfig.setSelectedAuthProfile(authProfile);
        this.notifyPropertyChanged(SELECTED_AUTH_PROFILE_PROPERTY_NAME, old, authProfile);
    }

    private void setAuthType(CredentialsConfig.AuthType.Enum authType) {
        if (!(authType == null || ((Object)((Object)CredentialsConfig.AuthType.O_AUTH_2_0)).equals((Object)authType) || ((Object)((Object)CredentialsConfig.AuthType.NO_AUTHORIZATION)).equals((Object)authType) || ((Object)((Object)CredentialsConfig.AuthType.O_AUTH_1_0)).equals((Object)authType))) {
            if (((Object)((Object)authType)).equals((Object)CredentialsConfig.AuthType.PREEMPTIVE) || ((Object)((Object)authType)).equals((Object)CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS)) {
                this.addBasicAuthenticationProfile(BASIC_AUTH_PROFILE);
            } else {
                this.addBasicAuthenticationProfile(authType.toString());
            }
        }
        String old = this.getAuthType();
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        credentialsConfig.setAuthType(authType);
        this.notifyPropertyChanged("authType", (Object)old, (Object)authType);
    }

    public boolean getPreemptive() {
        CredentialsConfig credentialsConfig = this.getCredentialsConfig();
        if (CredentialsConfig.AuthType.PREEMPTIVE.toString().equals(this.getAuthType()) && !credentialsConfig.getPreemptive()) {
            credentialsConfig.setPreemptive(true);
        }
        return credentialsConfig.getPreemptive();
    }

    public void setPreemptive(boolean preemptive) {
        boolean old = this.getPreemptive();
        this.getCredentialsConfig().setPreemptive(preemptive);
        this.notifyPropertyChanged("preemptive", old, preemptive);
    }

    @Override
    public String getSslKeystore() {
        return ((AbstractRequestConfig)this.getConfig()).getSslKeystore();
    }

    @Override
    public void setSslKeystore(String sslKeystore) {
        String old = this.getSslKeystore();
        ((AbstractRequestConfig)this.getConfig()).setSslKeystore(sslKeystore);
        this.notifyPropertyChanged("sslKeystore", old, sslKeystore);
    }

    @Override
    public String getBindAddress() {
        return this.getSettings().getString(BIND_ADDRESS, "");
    }

    @Override
    public void setBindAddress(String bindAddress) {
        String old = this.getSettings().getString(BIND_ADDRESS, "");
        this.getSettings().setString(BIND_ADDRESS, bindAddress);
        this.notifyPropertyChanged(BIND_ADDRESS, old, bindAddress);
    }

    @Override
    public long getMaxSize() {
        return this.getSettings().getLong(MAX_SIZE, 0L);
    }

    @Override
    public void setMaxSize(long maxSize) {
        long old = this.getSettings().getLong(MAX_SIZE, 0L);
        this.getSettings().setLong(MAX_SIZE, maxSize);
        this.notifyPropertyChanged(MAX_SIZE, old, maxSize);
    }

    @Override
    public String getDumpFile() {
        return this.dumpFile.get();
    }

    @Override
    public void setDumpFile(String df) {
        String old = this.getDumpFile();
        this.dumpFile.set(df, false);
        this.notifyPropertyChanged(DUMP_FILE, old, this.getDumpFile());
    }

    @Override
    public boolean isRemoveEmptyContent() {
        return this.getSettings().getBoolean(REMOVE_EMPTY_CONTENT);
    }

    @Override
    public void setRemoveEmptyContent(boolean removeEmptyContent) {
        boolean old = this.getSettings().getBoolean(REMOVE_EMPTY_CONTENT);
        this.getSettings().setBoolean(REMOVE_EMPTY_CONTENT, removeEmptyContent);
        this.notifyPropertyChanged(REMOVE_EMPTY_CONTENT, old, removeEmptyContent);
    }

    @Override
    public boolean isStripWhitespaces() {
        return this.getSettings().getBoolean(STRIP_WHITESPACES);
    }

    @Override
    public void setStripWhitespaces(boolean stripWhitespaces) {
        boolean old = this.getSettings().getBoolean(STRIP_WHITESPACES);
        this.getSettings().setBoolean(STRIP_WHITESPACES, stripWhitespaces);
        this.notifyPropertyChanged(STRIP_WHITESPACES, old, stripWhitespaces);
    }

    @Override
    public boolean isFollowRedirects() {
        if (!this.getSettings().isSet(FOLLOW_REDIRECTS)) {
            return true;
        }
        return this.getSettings().getBoolean(FOLLOW_REDIRECTS);
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        boolean old = this.getSettings().getBoolean(FOLLOW_REDIRECTS);
        this.getSettings().setBoolean(FOLLOW_REDIRECTS, followRedirects);
        this.notifyPropertyChanged(FOLLOW_REDIRECTS, old, followRedirects);
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        if (this.requestContent != null) {
            if (((AbstractRequestConfig)this.getConfig()).getRequest() == null) {
                ((AbstractRequestConfig)this.getConfig()).addNewRequest();
            }
            CompressedStringSupport.setString(((AbstractRequestConfig)this.getConfig()).getRequest(), this.escapeCarriageReturnsIn(this.requestContent));
        }
    }

    private CredentialsConfig getCredentialsConfig() {
        CredentialsConfig credentialsConfig = ((AbstractRequestConfig)this.getConfig()).getCredentials();
        if (credentialsConfig == null) {
            credentialsConfig = ((AbstractRequestConfig)this.getConfig()).addNewCredentials();
        }
        return credentialsConfig;
    }

    @Override
    public void setIconAnimator(RequestIconAnimator<?> iconAnimator) {
        if (this.iconAnimator != null) {
            this.removeSubmitListener(this.iconAnimator);
        }
        this.iconAnimator = iconAnimator;
        if (SoapUI.usingGraphicalEnvironment()) {
            this.addSubmitListener(this.iconAnimator);
        }
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(HttpResponse response, SubmitContext context) {
        HttpResponse oldResponse = this.getResponse();
        this.response = response;
        this.notifyPropertyChanged(RESPONSE_PROPERTY, oldResponse, response);
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        for (FileAttachment<?> attachment : this.attachments) {
            attachment.resolve(context);
        }
    }

    @Override
    public void addExternalDependencies(List<ExternalDependency> dependencies) {
        super.addExternalDependencies(dependencies);
        for (FileAttachment<?> attachment : this.attachments) {
            attachment.addExternalDependency(dependencies);
        }
    }

    @Override
    public boolean hasEndpoint() {
        return StringUtils.hasContent(this.getEndpoint());
    }

    public void setAfterRequestInjection(IAfterRequestInjection afterRequestInjection) {
        this.afterRequestInjection = afterRequestInjection;
    }

    @Override
    public IAfterRequestInjection getAfterRequestInjection() {
        return this.afterRequestInjection;
    }

    public static class RequestIconAnimator<T extends AbstractHttpRequest<?>>
    extends IconAnimator<T>
    implements SubmitListener {
        public RequestIconAnimator(T modelItem, String baseIcon, String animIcon, int iconCounts) {
            super(modelItem, baseIcon, animIcon, iconCounts);
        }

        @Override
        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            if (this.isEnabled() && submit.getRequest() == this.getTarget()) {
                this.start();
            }
            return true;
        }

        @Override
        public void afterSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() == this.getTarget()) {
                this.stop();
            }
        }
    }
}

