/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.service;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.definition.InterfaceDefinitionPart;
import com.eviware.soapui.impl.wadl.WadlDefinitionContext;
import com.eviware.soapui.impl.wsdl.panels.iface.WsdlInterfaceDesktopPanel;
import com.eviware.soapui.impl.wsdl.support.xsd.SchemaUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JEditorStatusBar;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.MetricsPanel;
import com.eviware.soapui.support.components.ProgressDialog;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.JXTable;
import org.w3c.dom.Element;

public class RestServiceDesktopPanel
extends ModelItemDesktopPanel<RestService> {
    private static final Logger logger = Logger.getLogger(WsdlInterfaceDesktopPanel.class);
    private JTabbedPane partTabs;
    private List<RSyntaxTextArea> editors = new ArrayList<RSyntaxTextArea>();
    private JTree tree;
    private Map<String, DefaultMutableTreeNode> groupNodes = new HashMap<String, DefaultMutableTreeNode>();
    private Map<String, TreePath> pathMap = new HashMap<String, TreePath>();
    private List<TreePath> navigationHistory = new ArrayList<TreePath>();
    private StringList targetNamespaces = new StringList();
    private int historyIndex;
    private boolean navigating;
    private JEditorStatusBar statusBar;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private final RestService restService;
    private MetricsPanel metrics;
    private boolean updatingService;
    private ResourcesTableModel operationsTableModel;
    private static final String DEFINITION_PARTS_SECTION = "Definition Parts";

    public RestServiceDesktopPanel(RestService service) {
        super(service);
        this.restService = service;
        try {
            this.buildUI();
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SoapUI.getDesktop().closeDesktopPanel(RestServiceDesktopPanel.this);
                }
            });
        }
    }

    private void buildUI() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Overview", this.buildServiceOverviewTab());
        tabs.addTab("Service Endpoints", this.buildEndpointsTab());
        tabs.addTab("WADL Content", this.buildWadlContentTab());
        this.add((Component)UISupport.createTabPanel(tabs, true), "Center");
    }

    private Component buildServiceOverviewTab() {
        this.metrics = new MetricsPanel();
        MetricsPanel.MetricsSection section = this.metrics.addSection("WADL Definition");
        try {
            section.addMetric("WADL URL", MetricsPanel.MetricType.URL).set(this.restService.getWadlUrl() + (this.restService.isGenerated() ? " - generated" : ""));
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
        section.finish();
        this.metrics.addSection(DEFINITION_PARTS_SECTION);
        section = this.metrics.addSection("Resources");
        this.operationsTableModel = new ResourcesTableModel();
        JXTable table = section.addTable(this.operationsTableModel);
        table.getColumn(1).setPreferredWidth(60);
        section.finish();
        return new JScrollPane(this.metrics);
    }

    private Component buildEndpointsTab() {
        return this.restService.getProject().getEndpointStrategy().getConfigurationPanel(this.restService);
    }

    private JComponent buildWadlContentTab() {
        this.partTabs = new JTabbedPane();
        this.partTabs.setTabLayoutPolicy(1);
        this.rootNode = new DefaultMutableTreeNode(this.restService.getName());
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addTreeSelectionListener(new InternalTreeSelectionListener());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                InspectItem item;
                DefaultMutableTreeNode treeNode;
                Object userObject;
                TreePath selectionPath;
                if (arg0.getClickCount() > 1 && (selectionPath = RestServiceDesktopPanel.this.tree.getSelectionPath()) != null && (userObject = (treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof InspectItem && (item = (InspectItem)userObject) != null && item.selector != null) {
                    item.selector.selectNode(item);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        UISupport.addPreviewCorner(scrollPane, true);
        JSplitPane split = UISupport.createHorizontalSplit(scrollPane, UISupport.createTabPanel(this.partTabs, true));
        split.setDividerLocation(250);
        split.setResizeWeight(0.3);
        this.initTreeModel(this.restService);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)split, "Center");
        panel.add(this.buildWadlTabToolbar(), "First");
        this.statusBar = new JEditorStatusBar();
        panel.add((Component)this.statusBar, "Last");
        this.setPreferredSize(new Dimension(600, 500));
        return panel;
    }

    private void initTreeModel(RestService iface) {
        try {
            if (iface.getWadlContext().loadIfNecessary()) {
                XProgressDialog progressDialog = UISupport.getDialogs().createProgressDialog("Loading Defintion", 3, "Initializing definition..", true);
                Loader loader = new Loader(iface);
                progressDialog.run(loader);
                loader = null;
                this.treeModel.nodeStructureChanged(this.rootNode);
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    private Component buildWadlTabToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new BackwardAction()));
        toolbar.addFixed(UISupport.createToolbarButton(new ForwardAction()));
        toolbar.addUnrelatedGap();
        JButton button = UISupport.createToolbarButton(SwingActionDelegate.createDelegate("ExportWadlAction", this.getModelItem(), null, "/export.png"));
        button.setText(null);
        toolbar.addFixed(button);
        toolbar.addFixed(UISupport.createToolbarButton(SwingActionDelegate.createDelegate("CreateWadlDocumentationAction", this.restService, null, "/report.png")));
        toolbar.addFixed(button);
        if (this.restService.isGenerated()) {
            toolbar.addUnrelatedGap();
            toolbar.addFixed(UISupport.createToolbarButton(new RecreateWadlAction()));
        }
        toolbar.addGlue();
        button = UISupport.createToolbarButton(new ShowOnlineHelpAction("/SOAP-and-WSDL/working-with-wsdls.html"));
        button.setText(null);
        return toolbar;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return ((RestService)this.getModelItem()).dependsOn(modelItem);
    }

    public List<DefaultMutableTreeNode> mapTreeItems(XmlObject xmlObject, DefaultMutableTreeNode treeRoot, boolean createEmpty, int tabIndex, String groupName, String query, String nameQuery, boolean sort, NodeSelector selector) {
        ArrayList<DefaultMutableTreeNode> resultNodes = new ArrayList<DefaultMutableTreeNode>();
        try {
            XmlObject[] items = xmlObject.selectPath(query);
            ArrayList<DefaultMutableTreeNode> treeNodes = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode root = treeRoot;
            if (groupName != null) {
                String groupKey = new TreePath(root.getPath()).toString() + "/" + groupName;
                if ((root = this.groupNodes.get(groupKey)) == null && (items.length > 0 || createEmpty)) {
                    root = new DefaultMutableTreeNode(groupName);
                    treeRoot.add(root);
                    this.groupNodes.put(groupKey, root);
                } else if (root != null) {
                    Enumeration<TreeNode> children = root.children();
                    while (children.hasMoreElements()) {
                        treeNodes.add((DefaultMutableTreeNode)children.nextElement());
                    }
                }
            }
            if (items.length == 0) {
                return resultNodes;
            }
            for (XmlObject item : items) {
                XmlObject[] selectPath = item.selectPath(nameQuery);
                if (selectPath.length <= 0) continue;
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(new InspectItem(item, selectPath[0], tabIndex, selector));
                treeNodes.add(treeNode);
                resultNodes.add(treeNode);
            }
            if (sort) {
                Collections.sort(treeNodes, new Comparator<DefaultMutableTreeNode>(){

                    @Override
                    public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
            }
            root.removeAllChildren();
            for (DefaultMutableTreeNode treeNode : treeNodes) {
                root.add(treeNode);
                String path = "/" + this.getTreeNodeName(treeNode);
                TreePath treePath = new TreePath(treeNode.getPath());
                while (treeNode.getParent() != null) {
                    treeNode = (DefaultMutableTreeNode)treeNode.getParent();
                    path = "/" + this.getTreeNodeName(treeNode) + path;
                }
                this.pathMap.put(path, treePath);
            }
        }
        catch (Throwable e) {
            SoapUI.log("Failed to map items for query [" + query + "]:[" + nameQuery + "]");
            SoapUI.logError(e);
        }
        return resultNodes;
    }

    private String getTreeNodeName(DefaultMutableTreeNode treeNode) {
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof InspectItem) {
            return ((InspectItem)userObject).getName();
        }
        return treeNode.toString();
    }

    @Override
    public boolean onClose(boolean canCancel) {
        return this.release();
    }

    private void simpleSelect(InspectItem item, String attribute, String targetGroup) {
        Element elm = item.getElement();
        String type = elm.getAttribute(attribute);
        if (type.length() > 0) {
            TreePath treePath;
            int ix = type.indexOf(58);
            if (ix != -1) {
                type = type.substring(ix + 1);
            }
            if ((treePath = this.pathMap.get("/" + ((RestService)this.getModelItem()).getName() + "/" + targetGroup + "/" + type)) != null) {
                this.tree.setSelectionPath(treePath);
            }
        }
    }

    private class ResourcesTableModel
    extends AbstractTableModel {
        private ResourcesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return RestServiceDesktopPanel.this.restService.getOperationCount();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Path";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (RestServiceDesktopPanel.this.updatingService) {
                return "<updating>";
            }
            RestResource operation = RestServiceDesktopPanel.this.restService.getOperationAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return operation.getName();
                }
                case 1: {
                    return operation.getPath();
                }
            }
            return null;
        }
    }

    private class RecreateWadlAction
    extends AbstractAction {
        public RecreateWadlAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/updateDefinition.gif"));
            this.putValue("ShortDescription", "Recreate WADL");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            RestServiceDesktopPanel.this.partTabs.removeAll();
            RestServiceDesktopPanel.this.tree.setSelectionRow(-1);
            RestServiceDesktopPanel.this.rootNode.removeAllChildren();
            RestServiceDesktopPanel.this.editors.clear();
            RestServiceDesktopPanel.this.groupNodes.clear();
            RestServiceDesktopPanel.this.pathMap.clear();
            RestServiceDesktopPanel.this.targetNamespaces.clear();
            RestServiceDesktopPanel.this.initTreeModel(RestServiceDesktopPanel.this.restService);
            RestServiceDesktopPanel.this.operationsTableModel.fireTableDataChanged();
            RestServiceDesktopPanel.this.updatingService = false;
        }
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_right.png"));
            this.putValue("ShortDescription", "Navigate to next selection");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (RestServiceDesktopPanel.this.historyIndex < RestServiceDesktopPanel.this.navigationHistory.size() - 1) {
                RestServiceDesktopPanel.this.historyIndex++;
                RestServiceDesktopPanel.this.navigating = true;
                RestServiceDesktopPanel.this.tree.setSelectionPath((TreePath)RestServiceDesktopPanel.this.navigationHistory.get(RestServiceDesktopPanel.this.historyIndex));
                RestServiceDesktopPanel.this.navigating = false;
            }
        }
    }

    private class BackwardAction
    extends AbstractAction {
        public BackwardAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_left.png"));
            this.putValue("ShortDescription", "Navigate to previous selection");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (RestServiceDesktopPanel.this.historyIndex > 0) {
                RestServiceDesktopPanel.this.historyIndex--;
                RestServiceDesktopPanel.this.navigating = true;
                RestServiceDesktopPanel.this.tree.setSelectionPath((TreePath)RestServiceDesktopPanel.this.navigationHistory.get(RestServiceDesktopPanel.this.historyIndex));
                RestServiceDesktopPanel.this.navigating = false;
            }
        }
    }

    public class BindingOperationSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            Element elm = item.getElement();
            String name = elm.getAttribute("name");
            Element operationElm = (Element)elm.getParentNode();
            Element bindingElm = (Element)operationElm.getParentNode();
            String type = bindingElm.getAttribute("type");
            if (type.length() > 0) {
                TreePath treePath;
                int ix = type.indexOf(58);
                if (ix != -1) {
                    type = type.substring(ix + 1);
                }
                if ((treePath = (TreePath)RestServiceDesktopPanel.this.pathMap.get("/" + ((RestService)RestServiceDesktopPanel.this.getModelItem()).getName() + "/PortTypes/" + type + "/" + operationElm.getAttribute("name") + "/" + name)) != null) {
                    RestServiceDesktopPanel.this.tree.setSelectionPath(treePath);
                }
            }
        }
    }

    public class PortSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            RestServiceDesktopPanel.this.simpleSelect(item, "binding", "Bindings");
        }
    }

    public class GlobalElementSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            RestServiceDesktopPanel.this.simpleSelect(item, "type", "Complex Types");
        }
    }

    public class MessageSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            RestServiceDesktopPanel.this.simpleSelect(item, "message", "Messages");
        }
    }

    public class PartSelector
    implements NodeSelector {
        @Override
        public void selectNode(InspectItem item) {
            Element elm = item.getElement();
            String type = elm.getAttribute("type");
            String element = elm.getAttribute("element");
            if (type.length() > 0) {
                RestServiceDesktopPanel.this.simpleSelect(item, "type", "Complex Types");
            } else if (element.length() > 0) {
                RestServiceDesktopPanel.this.simpleSelect(item, "element", "Global Elements");
            }
        }
    }

    protected static interface NodeSelector {
        public void selectNode(InspectItem var1);
    }

    private final class InspectItem {
        private final XmlObject item;
        private String name;
        private final int tabIndex;
        private XmlLineNumber lineNumber;
        private final NodeSelector selector;

        public InspectItem(XmlObject item, XmlObject nameObj, int tabIndex, NodeSelector selector) {
            this.item = item;
            this.selector = selector;
            this.name = XmlUtils.getNodeValue(nameObj.getDomNode());
            if (this.name == null) {
                this.name = nameObj.toString();
            }
            this.tabIndex = tabIndex;
            ArrayList list = new ArrayList();
            XmlCursor cursor = item.newCursor();
            cursor.getAllBookmarkRefs(list);
            for (Object o : list) {
                if (!(o instanceof XmlLineNumber)) continue;
                this.lineNumber = (XmlLineNumber)o;
            }
            cursor.dispose();
        }

        public String getDescription() {
            return this.getName() + "@" + (String)RestServiceDesktopPanel.this.targetNamespaces.get(this.tabIndex);
        }

        public String getName() {
            int ix = this.name.indexOf(32);
            return ix == -1 ? this.name : this.name.substring(0, ix);
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public int getLineNumber() {
            return this.lineNumber == null ? -1 : this.lineNumber.getLine() - 1;
        }

        public String toString() {
            return this.name;
        }

        public NodeSelector getSelector() {
            return this.selector;
        }

        public Element getElement() {
            return (Element)this.item.getDomNode();
        }
    }

    private class Loader
    implements Worker {
        private ProgressDialog progressDialog;
        private final RestService iface;
        private JProgressBar progressBar;

        public Loader(RestService iface) {
            this.iface = iface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct(XProgressMonitor monitor) {
            MetricsPanel.MetricsSection section = RestServiceDesktopPanel.this.metrics.getSection(RestServiceDesktopPanel.DEFINITION_PARTS_SECTION);
            section.clear();
            try {
                WadlDefinitionContext wadlContext = this.iface.getWadlContext();
                if (this.iface.isGenerated()) {
                    wadlContext.regenerateWadl();
                }
                List<InterfaceDefinitionPart> parts = wadlContext.getDefinitionParts();
                int tabCount = RestServiceDesktopPanel.this.partTabs.getTabCount();
                for (InterfaceDefinitionPart part : parts) {
                    this.addTab(part.getUrl(), part.getContent());
                }
                while (tabCount-- > 0) {
                    RestServiceDesktopPanel.this.partTabs.remove(0);
                }
                Iterator<InterfaceDefinitionPart> iterator = null;
                return iterator;
            }
            catch (Exception e) {
                logger.error((Object)("Failed to load WSDL; " + e.getClass().getSimpleName() + "; " + e.getMessage()));
                RestServiceDesktopPanel.this.add((Component)new JLabel("Failed to load WSDL; " + e.toString()), "North");
                SoapUI.logError(e);
                Exception exception = e;
                return exception;
            }
            finally {
                section.finish();
            }
        }

        private void addTab(String url, String content) throws Exception {
            int ix;
            int n = ix = url.startsWith("file:") ? url.lastIndexOf(File.separatorChar) : url.lastIndexOf(47);
            if (ix == -1) {
                ix = url.lastIndexOf(47);
            }
            String title = url.substring(ix + 1);
            RestServiceDesktopPanel.this.metrics.getSection(RestServiceDesktopPanel.DEFINITION_PARTS_SECTION).addMetric(title, MetricsPanel.MetricType.URL).set(url);
            if (this.progressBar != null) {
                this.progressBar.setString(title);
            } else if (this.progressDialog != null) {
                this.progressDialog.setProgress(1, title);
            }
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(url);
            label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            panel.add((Component)label, "North");
            RSyntaxTextArea inputArea = SyntaxEditorUtil.createDefaultXmlSyntaxTextArea();
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(XmlUtils.createXmlObject(content), (Writer)writer);
            String xmlString = writer.toString();
            XmlObject xmlObject = XmlUtils.createXmlObject(xmlString, new XmlOptions().setLoadLineNumbers());
            inputArea.setText(xmlString);
            inputArea.setEditable(false);
            JPanel p = new JPanel(new BorderLayout());
            RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)inputArea);
            p.add((Component)scrollPane, "Center");
            UISupport.addPreviewCorner((JScrollPane)scrollPane, true);
            panel.add((Component)scrollPane, "Center");
            RestServiceDesktopPanel.this.partTabs.addTab(title, panel);
            if (RestServiceDesktopPanel.this.tree != null) {
                this.initInspectionTree(xmlObject, inputArea);
            }
        }

        private void initInspectionTree(XmlObject xmlObject, RSyntaxTextArea inputArea) {
            DefaultMutableTreeNode treeRoot = RestServiceDesktopPanel.this.rootNode;
            RestServiceDesktopPanel.this.targetNamespaces.add(SchemaUtils.getTargetNamespace(xmlObject));
            int tabCount = RestServiceDesktopPanel.this.partTabs.getTabCount() - 1;
            String wadlNsDeclaration = "declare namespace wadl='http://research.sun.com/wadl/2006/10';";
            this.mapWadlItems(xmlObject, treeRoot, tabCount, wadlNsDeclaration);
            wadlNsDeclaration = "declare namespace wadl='http://wadl.dev.java.net/2009/02';";
            this.mapWadlItems(xmlObject, treeRoot, tabCount, wadlNsDeclaration);
            RestServiceDesktopPanel.this.tree.expandRow(0);
            RestServiceDesktopPanel.this.editors.add(inputArea);
        }

        private void mapWadlItems(XmlObject xmlObject, DefaultMutableTreeNode treeRoot, int tabCount, String wadlNsDeclaration) {
            String xmlNsDeclaration = "declare namespace xs='http://www.w3.org/2001/XMLSchema';";
            RestServiceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Complex Types", xmlNsDeclaration + "//xs:complexType[@name!='']", "@name", true, null);
            RestServiceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Simple Types", xmlNsDeclaration + "//xs:simpleType[@name!='']", "@name", true, null);
            RestServiceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Anonymous Complex Types", xmlNsDeclaration + "//xs:complexType[not(exists(@name))]", "parent::node()/@name", true, null);
            RestServiceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Global Elements", xmlNsDeclaration + "//xs:schema/xs:element[@name!='']", "@name", true, new GlobalElementSelector());
            RestServiceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Schemas", xmlNsDeclaration + "//xs:schema", "@targetNamespace", true, null);
            RestServiceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Resources", wadlNsDeclaration + "//wadl:resource", "concat( @path, ' [', *:doc[1]/@title, ']' )", true, null);
            RestServiceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Methods", wadlNsDeclaration + "//wadl:method[exists(@name)]", "concat( @name, ' [', parent::node()/*:doc[1]/@title, ']' )", true, null);
            RestServiceDesktopPanel.this.mapTreeItems(xmlObject, treeRoot, false, tabCount, "Representations", wadlNsDeclaration + "//wadl:representation[@mediaType!='' or @status!='']", "concat( @mediaType, ' [', @status, '] (', parent::node()/parent::node()/parent::node()/@id, ' - ', parent::node()/parent::node()/@id, ' - ', name(parent::node()), ')' )", true, null);
        }

        @Override
        public void finished() {
            if (this.progressDialog != null) {
                this.progressDialog.setVisible(false);
            }
            this.progressDialog = null;
        }

        @Override
        public boolean onCancel() {
            this.progressBar = new JProgressBar(0, 1);
            this.progressBar.setSize(new Dimension(120, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("Loading Definition..");
            this.progressBar.setIndeterminate(true);
            ButtonBarBuilder builder = ButtonBarBuilder.createLeftToRightBuilder();
            builder.addGlue();
            builder.addFixed((JComponent)this.progressBar);
            builder.addGlue();
            builder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            RestServiceDesktopPanel.this.partTabs.addTab("Loading.. ", builder.getPanel());
            return true;
        }
    }

    private final class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath newLeadSelectionPath = e.getNewLeadSelectionPath();
            if (newLeadSelectionPath != null) {
                DefaultMutableTreeNode tn;
                if (!RestServiceDesktopPanel.this.navigating) {
                    while (RestServiceDesktopPanel.this.historyIndex < RestServiceDesktopPanel.this.navigationHistory.size() - 1) {
                        TreePath path = (TreePath)RestServiceDesktopPanel.this.navigationHistory.remove(RestServiceDesktopPanel.this.navigationHistory.size() - 1);
                        RestServiceDesktopPanel.this.navigationHistory.add(RestServiceDesktopPanel.this.historyIndex++, path);
                    }
                    RestServiceDesktopPanel.this.navigationHistory.add(newLeadSelectionPath);
                    RestServiceDesktopPanel.this.historyIndex = RestServiceDesktopPanel.this.navigationHistory.size() - 1;
                }
                if ((tn = (DefaultMutableTreeNode)newLeadSelectionPath.getLastPathComponent()).getUserObject() instanceof InspectItem) {
                    InspectItem item = (InspectItem)tn.getUserObject();
                    RestServiceDesktopPanel.this.partTabs.setSelectedIndex(item.getTabIndex());
                    RestServiceDesktopPanel.this.statusBar.setInfo(item.getDescription());
                    RSyntaxTextArea editor = (RSyntaxTextArea)RestServiceDesktopPanel.this.editors.get(item.getTabIndex());
                    int lineNumber = item.getLineNumber();
                    try {
                        if (lineNumber > 0 && editor.getLineStartOffset(lineNumber) >= 0) {
                            editor.setCaretPosition(editor.getLineStartOffset(lineNumber));
                        } else {
                            editor.setCaretPosition(0);
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
                RestServiceDesktopPanel.this.tree.scrollPathToVisible(newLeadSelectionPath);
                RestServiceDesktopPanel.this.tree.expandPath(newLeadSelectionPath);
            }
        }
    }
}

