/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.method;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.JTableFactory;
import com.eviware.soapui.support.types.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class RestRepresentationsTable
extends JPanel
implements PropertyChangeListener {
    private RestMethod restMethod;
    private List<RestRepresentation.Type> types;
    private JTable representationsTable;
    private RepresentationsTableModel tableModel;
    private AddRepresentationAction addRepresentationAction;
    private RemoveRepresentationAction removeRepresentationAction;
    private boolean readOnly;

    public RestRepresentationsTable(RestMethod restMethod, RestRepresentation.Type[] types, boolean readOnly) {
        super(new BorderLayout());
        this.restMethod = restMethod;
        this.types = Arrays.asList(types);
        this.readOnly = readOnly;
        this.tableModel = new RepresentationsTableModel();
        this.representationsTable = JTableFactory.getInstance().makeJTable(this.tableModel);
        this.representationsTable.setRowHeight(18);
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)new JScrollPane(this.representationsTable), "Center");
        restMethod.addPropertyChangeListener("representations", this);
    }

    protected JXToolBar buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        if (!this.readOnly) {
            this.addRepresentationAction = new AddRepresentationAction();
            toolbar.addFixed(UISupport.createToolbarButton(this.addRepresentationAction));
            this.removeRepresentationAction = new RemoveRepresentationAction();
            this.removeRepresentationAction.setEnabled(false);
            this.representationsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    RestRepresentationsTable.this.removeRepresentationAction.setEnabled(RestRepresentationsTable.this.representationsTable.getSelectedRow() != -1);
                }
            });
            toolbar.addFixed(UISupport.createToolbarButton(this.removeRepresentationAction));
        }
        return toolbar;
    }

    public RestRepresentation getRepresentationAtRow(int rowIndex) {
        return this.tableModel.getRepresentationAtRow(rowIndex);
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.tableModel.refresh();
    }

    public void release() {
        this.tableModel.release();
        this.restMethod.removePropertyChangeListener("representations", this);
    }

    public void refresh() {
        this.tableModel.refresh();
    }

    public int getSelectedRow() {
        return this.representationsTable.getSelectedRow();
    }

    private class RemoveRepresentationAction
    extends AbstractAction {
        private RemoveRepresentationAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Removes selected Representation from this Method");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Remove selected Representation?", "Remove Representation")) {
                RestRepresentationsTable.this.restMethod.removeRepresentation(RestRepresentationsTable.this.tableModel.getRepresentationAtRow(RestRepresentationsTable.this.representationsTable.getSelectedRow()));
            }
        }
    }

    private class AddRepresentationAction
    extends AbstractAction {
        private AddRepresentationAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Adds a new Response Representation to this Method");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String type;
            String string = type = RestRepresentationsTable.this.types.size() == 1 ? ((RestRepresentation.Type)((Object)RestRepresentationsTable.this.types.get(0))).toString() : UISupport.prompt("Specify type of Representation to add", "Add Representation", new StringList((Collection<?>)RestRepresentationsTable.this.types).toStringArray());
            if (type != null) {
                RestRepresentationsTable.this.restMethod.addNewRepresentation(RestRepresentation.Type.valueOf(type));
            }
        }
    }

    public class RepresentationsTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        private List<RestRepresentation> data = new ArrayList<RestRepresentation>();

        public RepresentationsTableModel() {
            this.initData();
        }

        private void initData() {
            if (!this.data.isEmpty()) {
                this.release();
                this.data.clear();
            }
            for (RestRepresentation representation : RestRepresentationsTable.this.restMethod.getRepresentations()) {
                if (!RestRepresentationsTable.this.types.contains((Object)representation.getType())) continue;
                representation.addPropertyChangeListener(this);
                this.data.add(representation);
            }
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RestRepresentation representation = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return representation.getType().toString();
                }
                case 1: {
                    return representation.getMediaType();
                }
                case 2: {
                    return representation.getType().equals((Object)RestRepresentation.Type.REQUEST) ? "n/a" : representation.getStatus().toString();
                }
                case 3: {
                    return representation.getElement() == null ? null : representation.getElement().toString();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return !RestRepresentationsTable.this.readOnly && columnIndex > 0 && columnIndex < 3 && (!this.data.get(rowIndex).getType().equals((Object)RestRepresentation.Type.REQUEST) || columnIndex != 2);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (RestRepresentationsTable.this.readOnly) {
                return;
            }
            RestRepresentation representation = this.data.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    representation.setMediaType(value == null ? "" : value.toString());
                    break;
                }
                case 2: {
                    if (value == null) {
                        value = "";
                    }
                    String[] items = value.toString().split(" ");
                    ArrayList<Integer> status = new ArrayList<Integer>();
                    for (String item : items) {
                        try {
                            if (!StringUtils.hasContent(item)) continue;
                            status.add(Integer.parseInt(item.trim()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    representation.setStatus(status);
                    break;
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Type";
                }
                case 1: {
                    return "Media-Type";
                }
                case 2: {
                    return "Status Codes";
                }
                case 3: {
                    return "QName";
                }
            }
            return null;
        }

        public void refresh() {
            this.initData();
            this.fireTableDataChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireTableDataChanged();
        }

        public void release() {
            for (RestRepresentation representation : this.data) {
                representation.removePropertyChangeListener(this);
            }
        }

        public RestRepresentation getRepresentationAtRow(int rowIndex) {
            return this.data.get(rowIndex);
        }
    }
}

