/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.service;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.definition.export.WadlDefinitionExporter;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.TransformerFactoryImpl;

public class CreateWadlDocumentationAction
extends AbstractSoapUIAction<RestService> {
    public static final String SOAPUI_ACTION_ID = "CreateWadlDocumentationAction";
    private static final String REPORT_DIRECTORY_SETTING = CreateWadlDocumentationAction.class.getSimpleName() + "@report-directory";
    private XFormDialog dialog;
    private static Map<String, Transformer> transformers;

    public CreateWadlDocumentationAction() {
        super(SOAPUI_ACTION_ID, "Create Documentation", "Generate simple HTML Documentation for this WADL");
    }

    @Override
    public void perform(RestService target, Object param) {
        try {
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(Form.class);
            }
            XmlBeansSettingsImpl settings = target.getSettings();
            this.dialog.setValue("Output Folder", settings.getString(REPORT_DIRECTORY_SETTING, ""));
            if (!this.dialog.show()) {
                return;
            }
            settings.setString(REPORT_DIRECTORY_SETTING, this.dialog.getValue("Output Folder"));
            File reportDirectory = new File(settings.getString(REPORT_DIRECTORY_SETTING, ""));
            String reportDirAbsolutePath = reportDirectory.getAbsolutePath();
            String filename = reportDirAbsolutePath + File.separatorChar + "report.xml";
            String reportUrl = CreateWadlDocumentationAction.transform(target, reportDirAbsolutePath, filename);
            Tools.openURL(reportUrl);
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    private static String transform(RestService target, String reportDirAbsolutePath, String filename) throws Exception {
        Transformer transformer;
        if (transformers == null) {
            CreateWadlDocumentationAction.initTransformers();
        }
        if ((transformer = transformers.get("WADL")) == null) {
            throw new Exception("Missing transformer for format [" + target + "]");
        }
        transformer.setParameter("output.dir", reportDirAbsolutePath);
        String reportFile = reportDirAbsolutePath + File.separatorChar + "wadl-report.html";
        StreamResult result = new StreamResult(new FileWriter(reportFile));
        WadlDefinitionExporter exporter = new WadlDefinitionExporter(target);
        String infile = exporter.export(reportDirAbsolutePath);
        transformer.setURIResolver(new FileUriResolver(reportDirAbsolutePath));
        transformer.transform(new StreamSource(new FileReader(infile)), result);
        String reportUrl = new File(reportFile).toURI().toURL().toString();
        return reportUrl;
    }

    protected static void initTransformers() throws Exception {
        transformers = new HashMap<String, Transformer>();
        TransformerFactoryImpl xformFactory = new TransformerFactoryImpl();
        transformers.put("WADL", xformFactory.newTemplates(new StreamSource(SoapUI.class.getResourceAsStream("/com/eviware/soapui/resources/doc/wadl_documentation.xsl"))).newTransformer());
    }

    public static class FileUriResolver
    implements URIResolver {
        private final String basePath;

        public FileUriResolver(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            try {
                if (PathUtils.isHttpPath(href)) {
                    return new StreamSource(new URL(href).openStream());
                }
                File file = PathUtils.isAbsolutePath(href) ? new File(href) : new File(this.basePath, href);
                FileReader reader = new FileReader(file);
                return new StreamSource(reader);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    @AForm(description="Creates an HTML-Report for the current WADL", name="Create Report", helpUrl="/REST-Testing/working-with-rest-services.html", icon="/applications-system.png")
    public static interface Form {
        @AField(name="Output Folder", description="The folder where to create the report", type=AField.AFieldType.FOLDER)
        public static final String OUTPUT_FOLDER = "Output Folder";
    }
}

