/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.InvalidOAuthParametersException;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth1Parameters;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2Parameters;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1GetTokenForm;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class OAuthParameterValidator {
    static void validate(OAuth2Parameters parameters) {
        if (parameters.getOAuth2Flow() == OAuth2Profile.OAuth2Flow.RESOURCE_OWNER_PASSWORD_CREDENTIALS) {
            OAuthParameterValidator.validateRequiredStringValue(parameters.resourceOwnerName, "Resource Owner Name");
            OAuthParameterValidator.validateRequiredStringValue(parameters.resourceOwnerName, "Resource Owner Password");
        }
        OAuthParameterValidator.validateRequiredStringValue(parameters.clientId, "Client Identification");
        if (parameters.getOAuth2Flow() != OAuth2Profile.OAuth2Flow.IMPLICIT_GRANT) {
            OAuthParameterValidator.validateRequiredStringValue(parameters.clientSecret, "Client Secret");
            OAuthParameterValidator.validateHttpUrl(parameters.accessTokenUri, "Access Token URI");
        }
        if (parameters.getOAuth2Flow() != OAuth2Profile.OAuth2Flow.RESOURCE_OWNER_PASSWORD_CREDENTIALS && parameters.getOAuth2Flow() != OAuth2Profile.OAuth2Flow.CLIENT_CREDENTIALS_GRANT) {
            OAuthParameterValidator.validateHttpUrl(parameters.authorizationUri, "Authorization URI");
            OAuthParameterValidator.validateUri(parameters.redirectUri, "Redirect URI");
        }
    }

    static void validate(OAuth1Parameters parameters) {
        OAuthParameterValidator.validateRequiredStringValue(parameters.consumerKey, OAuth1GetTokenForm.CONSUMER_KEY_TITLE);
        OAuthParameterValidator.validateRequiredStringValue(parameters.consumerSecret, OAuth1GetTokenForm.CONSUMER_SECRET_TITLE);
        OAuthParameterValidator.validateHttpUrl(parameters.temporaryTokenUri, OAuth1GetTokenForm.TEMPORARY_TOKEN_URI_TITLE);
        OAuthParameterValidator.validateHttpUrl(parameters.authorizationUri, OAuth1GetTokenForm.AUTHORIZATION_URI_TITLE);
        OAuthParameterValidator.validateHttpUrl(parameters.accessTokenUri, OAuth1GetTokenForm.ACCESS_TOKEN_URI_TITLE);
        OAuthParameterValidator.validateUri(parameters.redirectUri, OAuth1GetTokenForm.REDIRECT_URI_TITLE);
    }

    private static void validateUri(String uri, String uriName) {
        if (!StringUtils.hasContent(uri)) {
            throw new InvalidOAuthParametersException(uri + " is not a valid " + uriName);
        }
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new InvalidOAuthParametersException(uri + " is not a valid " + uriName);
        }
    }

    private static void validateHttpUrl(String authorizationUri, String uriName) {
        if (!OAuthParameterValidator.isValidHttpUrl(authorizationUri)) {
            throw new InvalidOAuthParametersException(uriName + " " + authorizationUri + " is not a valid HTTP URL");
        }
    }

    private static boolean isValidHttpUrl(String authorizationUri) {
        if (!StringUtils.hasContent(authorizationUri)) {
            return false;
        }
        try {
            URL url = new URL(authorizationUri);
            return url.getProtocol().startsWith("http");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    static void validateRequiredStringValue(String value, String propertyName) {
        if (!StringUtils.hasContent(value)) {
            throw new InvalidOAuthParametersException(propertyName + " is empty");
        }
    }
}

