/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.oauth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.InvalidOAuthParametersException;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2ClientFacade;
import com.eviware.soapui.impl.rest.actions.oauth.OltuOAuth2ClientFacade;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class GetOAuthAccessTokenAction
extends AbstractAction {
    private static final MessageSupport messages = MessageSupport.getMessages(GetOAuthAccessTokenAction.class);
    private OAuth2Profile target;

    public GetOAuthAccessTokenAction(OAuth2Profile target) {
        this.target = target;
        this.putValue("Name", messages.get("GetOAuthAccessTokenAction.Action.Name"));
        this.putValue("ShortDescription", messages.get("GetOAuthAccessTokenAction.Action.Description"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this.getOAuthClientFacade().requestAccessToken(this.target);
        }
        catch (InvalidOAuthParametersException e) {
            UISupport.showErrorMessage(messages.get("GetOAuthAccessTokenAction.Error.InvalidParameters", e.getMessage()));
        }
        catch (Exception e) {
            SoapUI.logError(e, messages.get("GetOAuthAccessTokenAction.Error.RetrievingFailLog"));
            UISupport.showErrorMessage(messages.get("GetOAuthAccessTokenAction.Error.RetrievingFailMessage"));
        }
    }

    protected OAuth2ClientFacade getOAuthClientFacade() {
        return new OltuOAuth2ClientFacade();
    }
}

