/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.io.File;

public class SwitchWorkspaceAction
extends AbstractSoapUIAction<WorkspaceImpl> {
    public static final String SOAPUI_ACTION_ID = "SwitchWorkspaceAction";
    public static final MessageSupport messages = MessageSupport.getMessages(SwitchWorkspaceAction.class);

    public SwitchWorkspaceAction() {
        super(messages.get("SwitchWorkspaceAction.Title"), messages.get("SwitchWorkspaceAction.Description"));
    }

    @Override
    public void perform(WorkspaceImpl workspace, Object param) {
        if (SoapUI.getTestMonitor().hasRunningTests()) {
            UISupport.showErrorMessage(messages.get("SwitchWorkspaceAction.WhileTestsAreRunningError"));
            return;
        }
        File newPath = null;
        newPath = param != null ? new File(param.toString()) : UISupport.getFileDialogs().open(this, messages.get("SwitchWorkspaceAction.FileOpenTitle"), ".xml", "SoapUI Workspace (*.xml)", workspace.getPath());
        if (newPath != null && SoapUI.getDesktop().closeAll()) {
            boolean save = true;
            if (!newPath.exists()) {
                if (!UISupport.confirm(messages.get("SwitchWorkspaceAction.Confirm.Label", newPath.getName()), messages.get("SwitchWorkspaceAction.Confirm.Title"))) {
                    return;
                }
                save = false;
            } else if (workspace.getOpenProjectList().size() > 0) {
                Boolean val = UISupport.confirmOrCancel(messages.get("SwitchWorkspaceAction.SaveOpenProjects.Label"), messages.get("SwitchWorkspaceAction.SaveOpenProjects.Title"));
                if (val == null) {
                    return;
                }
                save = val;
            }
            workspace.save(!save);
            try {
                workspace.switchWorkspace(newPath);
                SoapUI.getSettings().setString(SoapUI.CURRENT_SOAPUI_WORKSPACE, newPath.getAbsolutePath());
                UISupport.select(workspace);
                Analytics.trackAction(SoapUIActions.SWITCH_WORKSPACE);
            }
            catch (SoapUIException e) {
                UISupport.showErrorMessage(e);
            }
        }
    }
}

